/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.debug.DebuggingUtils;
import org.eclipse.dltk.tcl.activestatedebugger.ITclActiveStateDebuggerEnvironment;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclActiveStateDebuggerEnvironment
implements ITclActiveStateDebuggerEnvironment {
    private final IEnvironment environment;
    private static final char ENVIRONMENT_SEPARATOR = ';';
    private static final char VALUE_SEPARATOR = '=';

    public TclActiveStateDebuggerEnvironment(IEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public String getDebuggerPath() {
        String path = this.getEnviromentPath("debugging_engine_path");
        if (path == null) {
            return DebuggingUtils.getDefaultEnginePath((IEnvironment)this.environment, (String)"org.eclipse.dltk.tcl.activestatedebugger");
        }
        return path;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.getEnvironmentBoolean("debugging_engine_log_enable", true);
    }

    @Override
    public String getLoggingPath() {
        return this.getEnviromentPath("log_file_name");
    }

    @Override
    public String getPDXPath() {
        return this.getEnviromentPath("debugging_engine_pdx_path");
    }

    @Override
    public void setDebuggerPath(String path) {
        this.setEnvironmentPath("debugging_engine_path", path);
    }

    @Override
    public void setLoggingEnabled(boolean value) {
        this.setEnvironmentBoolean("debugging_engine_log_enable", value);
    }

    @Override
    public void setLoggingPath(String path) {
        this.setEnvironmentPath("log_file_name", path);
    }

    @Override
    public void setPDXPath(String path) {
        this.setEnvironmentPath("debugging_engine_pdx_path", path);
    }

    private static IPreferenceStore getPreferenceStore() {
        return TclActiveStateDebuggerPlugin.getDefault().getPreferenceStore();
    }

    public static Map<String, Boolean> decodeBooleans(String value) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String[] parts = TextUtils.split((String)value, (char)';');
        if (parts != null) {
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                int pos = part.indexOf(61);
                if (pos > 0) {
                    String environmentId = part.substring(0, pos);
                    String environmentValue = part.substring(pos + 1);
                    result.put(environmentId, Boolean.valueOf(environmentValue));
                }
                ++n2;
            }
        }
        return result;
    }

    public static String encodeBooleans(Map<String, Boolean> value) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Boolean> entry : value.entrySet()) {
            if (sb.length() != 0) {
                sb.append(';');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue().toString());
        }
        return sb.toString();
    }

    private boolean getEnvironmentBoolean(String key, boolean defaultValue) {
        IPreferenceStore store = TclActiveStateDebuggerEnvironment.getPreferenceStore();
        Map<String, Boolean> values = TclActiveStateDebuggerEnvironment.decodeBooleans(store.getString(key));
        Boolean value = values.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private void setEnvironmentBoolean(String key, boolean value) {
        IPreferenceStore store = TclActiveStateDebuggerEnvironment.getPreferenceStore();
        Map<String, Boolean> values = TclActiveStateDebuggerEnvironment.decodeBooleans(store.getString(key));
        values.put(this.environment.getId(), value);
        store.setValue(key, TclActiveStateDebuggerEnvironment.encodeBooleans(values));
    }

    private String getEnviromentPath(String key) {
        IPreferenceStore store = TclActiveStateDebuggerEnvironment.getPreferenceStore();
        Map paths = EnvironmentPathUtils.decodePaths((String)store.getString(key));
        return (String)paths.get(this.environment);
    }

    private void setEnvironmentPath(String key, String path) {
        IPreferenceStore store = TclActiveStateDebuggerEnvironment.getPreferenceStore();
        Map paths = EnvironmentPathUtils.decodePaths((String)store.getString(key));
        String oldPath = (String)paths.get(this.environment);
        if (path != null) {
            if (path.equals(oldPath)) {
                return;
            }
            paths.put(this.environment, path);
        } else {
            if (oldPath == null) {
                return;
            }
            paths.remove(this.environment);
        }
        store.setValue(key, EnvironmentPathUtils.encodePaths((Map)paths));
    }
}

