/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.cdo.common.util.Support;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.widgets.TextAndDisable;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RepositoryLocalPage
extends AbstractRepositoryPage {
    private static final boolean SERVER_SECURITY_AVAILABLE = Support.SERVER_SECURITY.isAvailable();
    private static final boolean SERVER_LM_AVAILABLE = Support.SERVER_LM.isAvailable();
    private static final String DEFAULT_SECURITY_DESCRIPTION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryLocalPage.DEFAULT_SECURITY_DESCRIPTION", "security:annotation:home(/home)");
    private static final String DEFAULT_LM_DESCRIPTION = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryLocalPage.DEFAULT_LM_DESCRIPTION", "system:module.md:dropTypes(Tag,Milestone):releaseTypes(Release)");
    private final Set<Integer> configuredPorts = new HashSet<Integer>();
    private Text nameText;
    private Button normalButton;
    private Button auditingButton;
    private Button branchingButton;
    private Button counterButton;
    private Button uuidButton;
    private TextAndDisable securityText;
    private TextAndDisable lmText;
    private TextAndDisable portText;

    public RepositoryLocalPage() {
        super("local", "Local Repository");
        this.setTitle("New Local Repository");
        this.setMessage("Enter label and database parameters of the new local repository.");
        CDORepositoryManager repositoryManager = CDOExplorerUtil.getRepositoryManager();
        CDORepository[] cDORepositoryArray = repositoryManager.getRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository repository = cDORepositoryArray[n2];
            try {
                String host;
                URI uri = new URI(repository.getURI());
                if ("tcp".equals(uri.getScheme()) && ("localhost".equals(host = uri.getHost()) || "127.0.0.1".equals(host))) {
                    this.configuredPorts.add(uri.getPort());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            ++n2;
        }
    }

    @Override
    protected void fillPage(Composite container) {
        RepositoryLocalPage.createLabel(container, "Repository name:");
        this.nameText = new Text(container, 2048);
        this.nameText.setText(RepositoryLocalPage.getUniqueRepositoryName());
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener((ModifyListener)this);
        new Label(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)layout);
        Group modeGroup = new Group(composite, 0);
        modeGroup.setLayout((Layout)new GridLayout(1, false));
        modeGroup.setLayoutData((Object)new GridData(272));
        modeGroup.setText("Versioning Mode");
        this.normalButton = new Button((Composite)modeGroup, 16);
        this.normalButton.setText("Normal (no history)");
        this.normalButton.addSelectionListener((SelectionListener)this);
        this.auditingButton = new Button((Composite)modeGroup, 16);
        this.auditingButton.setText("Auditing (linear history)");
        this.auditingButton.addSelectionListener((SelectionListener)this);
        this.branchingButton = new Button((Composite)modeGroup, 16);
        this.branchingButton.setText("Branching (history tree)");
        this.branchingButton.setSelection(true);
        this.branchingButton.addSelectionListener((SelectionListener)this);
        Group idGroup = new Group(composite, 0);
        idGroup.setLayout((Layout)new GridLayout(1, false));
        idGroup.setLayoutData((Object)new GridData(272));
        idGroup.setText("ID Generation");
        this.counterButton = new Button((Composite)idGroup, 16);
        this.counterButton.setText("Counter (efficient)");
        this.counterButton.addSelectionListener((SelectionListener)this);
        this.uuidButton = new Button((Composite)idGroup, 16);
        this.uuidButton.setText("UUID (replicable)");
        this.uuidButton.setSelection(true);
        this.uuidButton.addSelectionListener((SelectionListener)this);
        if (SERVER_SECURITY_AVAILABLE) {
            RepositoryLocalPage.createLabel(container, "Security:");
            this.securityText = new TextAndDisable(container, 2048, null){

                protected GridData createTextLayoutData() {
                    return new GridData(4, 0x1000000, true, false);
                }
            };
            this.securityText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.securityText.setValue(DEFAULT_SECURITY_DESCRIPTION);
            this.securityText.setDisabled(true);
            this.securityText.addModifyListener((ModifyListener)this);
            this.securityText.addSelectionListener((SelectionListener)this);
        }
        if (SERVER_LM_AVAILABLE) {
            RepositoryLocalPage.createLabel(container, "Lifecycle Management:");
            this.lmText = new TextAndDisable(container, 2048, null){

                protected GridData createTextLayoutData() {
                    return new GridData(4, 0x1000000, true, false);
                }
            };
            this.lmText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.lmText.setValue(DEFAULT_LM_DESCRIPTION);
            this.lmText.setDisabled(true);
            this.lmText.addModifyListener((ModifyListener)this);
            this.lmText.addSelectionListener((SelectionListener)this);
        }
        RepositoryLocalPage.createLabel(container, "TCP port:");
        this.portText = new TextAndDisable(container, 2048, null);
        this.portText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.portText.setValue(Integer.toString(this.getDefaultPort()));
        this.portText.setDisabled(true);
        this.portText.addModifyListener((ModifyListener)this);
        this.portText.addSelectionListener((SelectionListener)this);
    }

    @Override
    protected void doValidate(Properties properties) throws Exception {
        super.doValidate(properties);
        String name = this.nameText.getText();
        if (StringUtil.isEmpty((String)name)) {
            throw new CheckoutWizardPage.ValidationProblem("Repository name is empty.");
        }
        CDORepository[] cDORepositoryArray = CDOExplorerUtil.getRepositoryManager().getRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository repository = cDORepositoryArray[n2];
            if ("local".equals(repository.getType()) && name.equals(repository.getName())) {
                throw new CheckoutWizardPage.ValidationProblem("Repository name is not unique.");
            }
            ++n2;
        }
        properties.setProperty("name", name);
        if (this.normalButton.getSelection()) {
            properties.setProperty("versioningMode", CDORepository.VersioningMode.Normal.toString());
        } else if (this.auditingButton.getSelection()) {
            properties.setProperty("versioningMode", CDORepository.VersioningMode.Auditing.toString());
        } else if (this.branchingButton.getSelection()) {
            properties.setProperty("versioningMode", CDORepository.VersioningMode.Branching.toString());
        }
        if (this.counterButton.getSelection()) {
            properties.setProperty("idGeneration", CDORepository.IDGeneration.Counter.toString());
        } else if (this.uuidButton.getSelection()) {
            properties.setProperty("idGeneration", CDORepository.IDGeneration.UUID.toString());
        }
        if (SERVER_SECURITY_AVAILABLE) {
            boolean securityDisabled = this.securityText.isDisabled();
            properties.setProperty("securityDisabled", Boolean.toString(securityDisabled));
            if (!securityDisabled) {
                String securityConfig = this.securityText.getText().getText().trim();
                if (securityConfig.isBlank()) {
                    throw new CheckoutWizardPage.ValidationProblem("Security configuration must start with the realm path.");
                }
                properties.setProperty("securityConfig", securityConfig);
            }
        }
        if (SERVER_LM_AVAILABLE) {
            boolean lmEnabled;
            boolean branching = this.branchingButton.getSelection();
            this.lmText.getButton().setEnabled(branching);
            boolean bl = lmEnabled = !this.lmText.isDisabled();
            if (lmEnabled && !branching) {
                lmEnabled = false;
                this.lmText.setDisabled(true);
            }
            properties.setProperty("lmEnabled", Boolean.toString(lmEnabled));
            if (lmEnabled) {
                properties.setProperty("lmConfig", this.lmText.getText().getText().trim());
            }
        }
        boolean tcpPortDisabled = this.portText.isDisabled();
        properties.setProperty("tcpDisabled", Boolean.toString(tcpPortDisabled));
        if (!tcpPortDisabled) {
            int port;
            try {
                port = Integer.parseInt(this.portText.getValue());
                if (port < 0 || port > 65535) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                throw new CheckoutWizardPage.ValidationProblem("Invalid TCP port.");
            }
            if (!this.isFreePort(port)) {
                throw new CheckoutWizardPage.ValidationProblem("TCP port " + port + " is not available.");
            }
            properties.setProperty("tcpPort", Integer.toString(port));
        }
    }

    private int getDefaultPort() {
        int port = 2036;
        while (port < 65535) {
            if (this.isFreePort(port)) {
                return port;
            }
            ++port;
        }
        return 2036;
    }

    private boolean isFreePort(int port) {
        if (this.configuredPorts.contains(port)) {
            return false;
        }
        return IOUtil.isFreePort((int)port);
    }

    public static String getUniqueRepositoryName() {
        HashSet<String> names = new HashSet<String>();
        CDORepositoryManager repositoryManager = CDOExplorerUtil.getRepositoryManager();
        CDORepository[] cDORepositoryArray = repositoryManager.getRepositories();
        int n = cDORepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDORepository repository = cDORepositoryArray[n2];
            if ("local".equals(repository.getType())) {
                names.add(repository.getName());
            }
            ++n2;
        }
        String defaultName = "repo";
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name;
            String string = name = i == 1 ? defaultName : defaultName + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many repositories");
    }
}

