/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.stack.LinkedStack;
import org.eclipse.jpt.common.utility.io.IndentingPrintWriter;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.GeneratedAnnotation2_0;

public class GenericMetamodelSynchronizer2_0
implements MetamodelSourceType2_0.Synchronizer {
    protected final MetamodelSourceType2_0 sourceType;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public GenericMetamodelSynchronizer2_0(MetamodelSourceType2_0 sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public IFile getFile() {
        return (IFile)this.getPackageFragment().getCompilationUnit(this.getFileName()).getResource();
    }

    @Override
    public void synchronize(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        try {
            this.synchronize_(memberTypeTree);
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    protected void synchronize_(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) throws JavaModelException {
        String fileName;
        IPackageFragment pkg = this.getPackageFragment();
        ICompilationUnit compilationUnit = pkg.getCompilationUnit(fileName = this.getFileName());
        if (compilationUnit.exists()) {
            String newSource = this.buildSource(compilationUnit, memberTypeTree);
            if (newSource != null) {
                pkg.createCompilationUnit(fileName, newSource, true, null);
            }
        } else {
            if (!pkg.exists()) {
                this.getSourceFolder().createPackageFragment(pkg.getElementName(), true, null);
            }
            pkg.createCompilationUnit(fileName, this.buildSource(memberTypeTree), false, null);
        }
    }

    protected String buildSource(ICompilationUnit compilationUnit, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) throws JavaModelException {
        IFile file = (IFile)compilationUnit.getResource();
        JavaResourceAbstractType genType = this.getJpaProject().getGeneratedMetamodelTopLevelType(file);
        if (genType == null) {
            return null;
        }
        String oldSource = compilationUnit.getSource();
        int oldLength = oldSource.length();
        String newSource = this.buildSource(memberTypeTree);
        int newLength = newSource.length();
        if (newLength != oldLength) {
            return newSource;
        }
        String date = ((GeneratedAnnotation2_0)genType.getAnnotation("javax.annotation.Generated")).getDate();
        int dateBegin = oldSource.indexOf(date);
        if (dateBegin == -1) {
            return null;
        }
        int dateEnd = dateBegin + date.length();
        if (dateEnd > oldLength) {
            return null;
        }
        if (newSource.regionMatches(0, oldSource, 0, dateBegin) && newSource.regionMatches(dateEnd, oldSource, dateEnd, oldLength - dateEnd)) {
            return null;
        }
        return newSource;
    }

    protected IPackageFragment getPackageFragment() {
        return this.getSourceFolder().getPackageFragment(this.getPackageName());
    }

    protected IPackageFragmentRoot getSourceFolder() {
        return this.getJpaProject().getMetamodelPackageFragmentRoot();
    }

    protected JpaProject2_0 getJpaProject() {
        return (JpaProject2_0)this.sourceType.getJpaProject();
    }

    protected String getPackageName() {
        return this.buildPackageName(this.sourceType.getName());
    }

    protected String buildPackageName(String topLevelSourceTypeName) {
        return this.buildPackageName_(ClassNameTools.packageName((String)topLevelSourceTypeName));
    }

    protected String buildPackageName_(String sourcePackageName) {
        return sourcePackageName;
    }

    protected String getFileName() {
        return ClassNameTools.simpleName((String)this.getClassName()) + ".java";
    }

    protected String getClassName() {
        return this.buildClassName(this.sourceType.getName());
    }

    protected String buildClassName(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        return this.buildClassName(this.sourceType.getName(), memberTypeTree);
    }

    protected String buildClassName(String sourceTypeName, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        String current = sourceTypeName;
        LinkedStack stack = new LinkedStack();
        while (true) {
            stack.push((Object)ClassNameTools.simpleName((String)current));
            String declaringTypeName = this.getDeclaringTypeName(current, memberTypeTree);
            if (declaringTypeName == null) break;
            current = declaringTypeName;
        }
        StringBuilder sb = new StringBuilder(sourceTypeName.length() + 10);
        sb.append(this.buildPackageName(current));
        while (!stack.isEmpty()) {
            sb.append('.');
            sb.append(this.buildSimpleClassName((String)stack.pop()));
        }
        return sb.toString();
    }

    protected String buildClassName(String topLevelSourceTypeName) {
        return this.buildPackageName(topLevelSourceTypeName) + "." + this.buildSimpleClassName(ClassNameTools.simpleName((String)topLevelSourceTypeName));
    }

    protected String getSimpleClassName() {
        return this.buildSimpleClassName(ClassNameTools.simpleName((String)this.sourceType.getName()));
    }

    protected String buildSimpleClassName(String simpleSourceTypeName) {
        return simpleSourceTypeName + "_";
    }

    protected String buildSource(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        BodySourceWriter bodySourceWriter = this.buildBodySourceWriter(memberTypeTree);
        StringWriter sw = new StringWriter(bodySourceWriter.getLength() + 2000);
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)sw, this.getLineSeparator());
        this.printPackageAndImportsOn(pw, bodySourceWriter);
        pw.print(bodySourceWriter.getSource());
        pw.close();
        bodySourceWriter.close();
        return sw.toString();
    }

    protected BodySourceWriter buildBodySourceWriter(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        BodySourceWriter pw = new BodySourceWriter(this.getPackageName(), this.getClassName(), this.getLineSeparator());
        this.printBodySourceOn(pw, memberTypeTree);
        return pw;
    }

    @Override
    public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        this.printClassDeclarationOn(pw, memberTypeTree);
        pw.print(" {");
        pw.println();
        pw.indent();
        boolean attributesPrinted = this.printAttributesOn(pw);
        this.printMemberTypesOn(pw, memberTypeTree, attributesPrinted);
        pw.undent();
        pw.print('}');
        pw.println();
    }

    protected void printClassDeclarationOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        boolean topLevel = this.sourceTypeIsTopLevel(memberTypeTree);
        if (topLevel) {
            this.printGeneratedAnnotationOn(pw);
        }
        if (this.sourceType.isManaged()) {
            this.printStaticMetamodelAnnotationOn(pw);
        }
        pw.print("public ");
        if (!topLevel) {
            pw.print("static ");
        }
        pw.print("class ");
        pw.print(this.getSimpleClassName());
        PersistentType superPersistentType = this.sourceType.getSuperPersistentType();
        if (superPersistentType != null) {
            pw.print(" extends ");
            pw.printTypeDeclaration(this.buildClassName(superPersistentType.getName(), memberTypeTree));
        }
    }

    protected boolean sourceTypeIsTopLevel(Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        return this.sourceTypeIsTopLevel(this.sourceType.getName(), memberTypeTree);
    }

    protected boolean sourceTypeIsTopLevel(String sourceTypeName, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        return this.getDeclaringTypeName(sourceTypeName, memberTypeTree) == null;
    }

    protected String getDeclaringTypeName(String sourceTypeName, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree) {
        int lastPeriod = sourceTypeName.lastIndexOf(46);
        if (lastPeriod == -1) {
            return null;
        }
        String declaringTypeName = sourceTypeName.substring(0, lastPeriod);
        return memberTypeTree.get(declaringTypeName) == null ? null : declaringTypeName;
    }

    protected void printGeneratedAnnotationOn(BodySourceWriter pw) {
        pw.printAnnotation("javax.annotation.Generated");
        pw.print('(');
        pw.print("value=");
        pw.printStringLiteral("Dali");
        pw.print(", ");
        pw.print("date=");
        pw.printStringLiteral(GenericMetamodelSynchronizer2_0.format(new Date()));
        pw.print(')');
        pw.println();
    }

    protected void printStaticMetamodelAnnotationOn(BodySourceWriter pw) {
        pw.printAnnotation("javax.persistence.metamodel.StaticMetamodel");
        pw.print('(');
        pw.printTypeDeclaration(this.sourceType.getName());
        pw.print(".class");
        pw.print(')');
        pw.println();
    }

    protected static synchronized String format(Date date) {
        return DATE_FORMAT.format(date);
    }

    protected boolean printAttributesOn(BodySourceWriter pw) {
        boolean printed = false;
        for (PersistentAttribute att : this.sourceType.getAttributes()) {
            this.printAttributeOn(att, pw);
            printed = true;
        }
        return printed;
    }

    protected void printAttributeOn(PersistentAttribute persistentAttribute, BodySourceWriter pw) {
        AttributeMapping attributeMapping = persistentAttribute.getMapping();
        if (attributeMapping != null) {
            this.printAttributeMappingOn(attributeMapping, pw);
        }
    }

    protected void printAttributeMappingOn(AttributeMapping attributeMapping, BodySourceWriter pw) {
        MetamodelField2_0 field = ((AttributeMapping2_0)attributeMapping).getMetamodelField();
        if (field != null) {
            this.printFieldOn(field, pw);
        }
    }

    protected void printFieldOn(MetamodelField2_0 field, BodySourceWriter pw) {
        for (String modifier : field.getModifiers()) {
            pw.print(modifier);
            pw.print(' ');
        }
        pw.printTypeDeclaration(field.getTypeName());
        pw.print('<');
        Iterator<String> stream = field.getTypeArgumentNames().iterator();
        while (stream.hasNext()) {
            pw.printTypeDeclaration(stream.next());
            if (!stream.hasNext()) continue;
            pw.print(", ");
        }
        pw.print('>');
        pw.print(' ');
        pw.print(field.getName());
        pw.print(';');
        pw.println();
    }

    protected void printMemberTypesOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType2_0>> memberTypeTree, boolean attributesPrinted) {
        Collection<MetamodelSourceType2_0> memberTypes = memberTypeTree.get(this.sourceType.getName());
        if (memberTypes != null) {
            if (attributesPrinted) {
                pw.println();
            }
            Iterator<MetamodelSourceType2_0> stream = memberTypes.iterator();
            while (stream.hasNext()) {
                stream.next().printBodySourceOn(pw, memberTypeTree);
                if (!stream.hasNext()) continue;
                pw.println();
            }
        }
    }

    protected void printPackageAndImportsOn(IndentingPrintWriter pw, BodySourceWriter bodySourceWriter) {
        if (this.getPackageName().length() != 0) {
            pw.print("package ");
            pw.print(this.getPackageName());
            pw.print(';');
            pw.println();
            pw.println();
        }
        for (String import_ : bodySourceWriter.getImports()) {
            pw.print("import ");
            pw.print(import_);
            pw.print(';');
            pw.println();
        }
        pw.println();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.sourceType.getName());
    }

    protected String getLineSeparator() {
        return PlatformTools.getNewTextFileLineDelimiter();
    }
}

