/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.PathType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebPathType
extends PathType
implements IMetaDataEnabledFeature,
IValidValues {
    @Override
    public boolean isValidValue(String value) {
        try {
            URL url = new URL(value);
            if (url.getProtocol().equals("file")) {
                this.validateFileRelativeToWebRoot(url.getPath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (value != null && value.length() > 1 && value.charAt(0) == '/') {
                this.validateFileRelativeToWebRoot(value);
            }
            this.validateFileRelativeToCurrentFile(value);
        }
        return this.getValidationMessages().size() == 0;
    }

    private void validateFileRelativeToWebRoot(String value) {
        IContainer webRoot = this.getWebRoot();
        if (webRoot == null) {
            return;
        }
        if (!webRoot.exists()) {
            this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_1));
        } else {
            IFile file = webRoot.getFile((IPath)new Path(value));
            if (!file.exists()) {
                this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_2));
            }
        }
    }

    protected IContainer getWebRoot() {
        IVirtualComponent component;
        IProject project = this.getProject2();
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
            return component.getRootFolder().getUnderlyingFolder();
        }
        return null;
    }

    private void validateFileRelativeToCurrentFile(String value) {
        IVirtualComponent component;
        IProject project = this.getProject2();
        if (project != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
            IPath filePath;
            IPath webContentPath = component.getRootFolder().getUnderlyingFolder().getFullPath();
            IFile resource = this.getFile2();
            if (resource != null && (filePath = resource.getFullPath()).matchingFirstSegments(webContentPath) == webContentPath.segmentCount()) {
                filePath = filePath.removeFirstSegments(webContentPath.segmentCount());
                filePath = filePath.removeLastSegments(1);
                filePath = filePath.append(value);
                IFile file = this.getWebRoot().getFile(filePath);
                if (!file.exists()) {
                    this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_2));
                }
            }
        }
    }
}

