/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class BackgroundImageMeta
extends CSSPropertyMeta {
    private static final String[] _keywords = new String[]{"none"};

    public BackgroundImageMeta() {
        super(false, "none");
    }

    @Override
    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        Object ret = null;
        String valueText = value.getCssText();
        if (valueText != null && valueText.length() > 0) {
            valueText = this.stripURLSyntax(valueText);
            ret = this.getImage(valueText, null);
        }
        if (ret == null) {
            ret = this.getInitialValue(propertyName, style);
        }
        return ret;
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        String attrValue;
        Image image = null;
        if (element != null && element.getNodeName() != null && element.getNodeName().equalsIgnoreCase("body") && "background-image".equalsIgnoreCase(propertyName) && (attrValue = DOMUtil.getAttributeIgnoreCase(element, "background")) != null && attrValue.trim().length() > 0) {
            image = this.getImage(attrValue.trim(), element);
        }
        return image;
    }

    @Override
    protected String[] getKeywordValues() {
        return _keywords;
    }

    private String stripURLSyntax(String input) {
        int endPos;
        int startPos;
        String output = null;
        if (input != null && (startPos = input.indexOf("url(") + 4) > -1 && startPos < input.length() - 1 && (endPos = input.indexOf(41, startPos)) > startPos) {
            String insideURL = input.substring(startPos, endPos).trim();
            output = insideURL.startsWith("\"") && insideURL.endsWith("\"") ? insideURL.substring(1, insideURL.length() - 1) : (insideURL.startsWith("'") && insideURL.endsWith("'") ? insideURL.substring(1, insideURL.length() - 1) : insideURL);
        }
        return output != null ? output : input;
    }

    private Image getImage(String imagePath, Element element) {
        Image image;
        block11: {
            image = null;
            if (imagePath != null && imagePath.length() > 0) {
                ImageRegistry registry = PDPlugin.getDefault().getImageRegistry();
                image = registry.get(imagePath);
                if (image == null) {
                    try {
                        URL imageURL = new URL(imagePath);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                        image = imageDescriptor.createImage();
                        if (image != null) {
                            registry.put(imagePath, image);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        URI imageURI;
                        IResource imageRes;
                        IContainer jspFolder;
                        IResource jspRes;
                        IWorkspaceRoot wsRoot;
                        String baseLocation;
                        IDOMModel model;
                        if (!(element instanceof IDOMNode) || (model = ((IDOMNode)element).getModel()) == null || (baseLocation = model.getBaseLocation()) == null || baseLocation.length() <= 0 || (wsRoot = ResourcesPlugin.getWorkspace().getRoot()) == null || (jspRes = wsRoot.findMember(baseLocation)) == null || (jspFolder = jspRes.getParent()) == null || (imageRes = jspFolder.findMember(imagePath)) == null || (imageURI = imageRes.getLocationURI()) == null) break block11;
                        try {
                            URL imageURL = imageURI.toURL();
                            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                            image = imageDescriptor.createImage();
                            if (image != null) {
                                registry.put(imagePath, image);
                            }
                        }
                        catch (MalformedURLException malformedURLException2) {
                        }
                    }
                    catch (SWTException sWTException) {}
                } else if (image.isDisposed()) {
                    registry.remove(imagePath);
                    image = this.getImage(imagePath, element);
                }
            }
        }
        return image;
    }
}

