/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCopyTo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyToContainerCommandHandler
extends AbstractHandler {
    private static final String ERROR_COPYING_TO_CONTAINER_NO_CONNECTION = "command.copytocontainer.failure.no_connection";
    private static final String MISSING_CONNECTION = "missing_connection";
    private static final String ERROR_COPYING_TO_CONTAINER = "command.copytocontainer.error.msg";
    private static final String COPY_TO_CONTAINER_JOB_TASK = "command.copytocontainer.job.task";
    private static final String COPY_TO_CONTAINER_JOB_TITLE = "command.copytocontainer.job.title";
    private static final String COPY_TO_CONTAINER_JOB_SUBTASK = "command.copytocontainer.job.subtask";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        List<IDockerContainer> selectedContainers = CommandUtils.getSelectedContainers(activePart);
        if (selectedContainers.size() != 1) {
            return null;
        }
        IDockerContainer container = selectedContainers.get(0);
        if (connection == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getString(MISSING_CONNECTION), (String)CommandMessages.getString(ERROR_COPYING_TO_CONTAINER_NO_CONNECTION));
        } else {
            ContainerCopyTo wizard = new ContainerCopyTo(connection, container);
            boolean copyToContainer = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (copyToContainer) {
                this.performCopyToContainer(connection, container, wizard.getTarget(), wizard.getSources());
            }
        }
        return null;
    }

    private void performCopyToContainer(final IDockerConnection connection, final IDockerContainer container, final String target, final List<Object> files) {
        Job copyToContainerJob = new Job(CommandMessages.getFormattedString(COPY_TO_CONTAINER_JOB_TITLE, container.name())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask(CommandMessages.getString(CopyToContainerCommandHandler.COPY_TO_CONTAINER_JOB_TASK), files.size() + 1);
                Path tmpDir = null;
                try (Closeable token2 = ((DockerConnection)connection).getOperationToken();){
                    for (Object proxy : files) {
                        File file = (File)proxy;
                        if (monitor.isCanceled()) {
                            monitor.done();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            Path sourcePath;
                            monitor.setTaskName(CommandMessages.getFormattedString(CopyToContainerCommandHandler.COPY_TO_CONTAINER_JOB_SUBTASK, proxy.toString()));
                            monitor.worked(1);
                            if (tmpDir == null) {
                                tmpDir = Files.createTempDirectory("org.eclipse.linuxtools.docker.ui", new FileAttribute[0]);
                            }
                            if (file.isDirectory()) {
                                sourcePath = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
                                final Path target2 = tmpDir.resolve(sourcePath.getFileName());
                                Files.createDirectory(target2, new FileAttribute[0]);
                                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                                    @Override
                                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                        Path targetPath = target2.resolve(sourcePath.relativize(dir));
                                        Files.createDirectories(targetPath, new FileAttribute[0]);
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        monitor.setTaskName(CommandMessages.getFormattedString(CopyToContainerCommandHandler.COPY_TO_CONTAINER_JOB_SUBTASK, file.toString()));
                                        Files.copy(file, target2.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                                continue;
                            }
                            monitor.worked(1);
                            sourcePath = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
                            Path targetPath = tmpDir.resolve(sourcePath.getFileName());
                            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getFormattedString(CopyToContainerCommandHandler.ERROR_COPYING_TO_CONTAINER, proxy.toString(), container.name()), (String)e.getMessage()));
                        }
                    }
                    try {
                        ((DockerConnection)connection).copyToContainer(token2, tmpDir.toString(), container.id(), target);
                        CopyToContainerCommandHandler.this.deleteTmpDir(tmpDir);
                    }
                    catch (IOException | DockerException e) {
                        Display.getDefault().syncExec(() -> 1.lambda$run$1(target, container, (Exception)e));
                    }
                }
                catch (InterruptedException token2) {
                }
                catch (IOException e1) {
                    Activator.log(e1);
                }
                catch (DockerException e1) {
                    Activator.log(e1);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            private static /* synthetic */ void lambda$run$1(String target2, IDockerContainer container2, Exception e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommandMessages.getFormattedString(CopyToContainerCommandHandler.ERROR_COPYING_TO_CONTAINER, target2, container2.name()), (String)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            }
        };
        copyToContainerJob.schedule();
    }

    private void deleteTmpDir(Path tmpPath) {
        File tmpDir = tmpPath.toFile();
        for (File f : tmpDir.listFiles()) {
            f.delete();
        }
        tmpDir.delete();
    }
}

