/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageBuildPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImageBuild
extends Wizard {
    private ImageBuildPage mainPage;
    private String imageName;
    private IPath directory;
    private int lines;

    public ImageBuild() {
        this.setWindowTitle(WizardMessages.getString("ImageBuild.title"));
    }

    public String getImageName() {
        return this.imageName;
    }

    public IPath getDirectory() {
        return this.directory;
    }

    public int getNumberOfLines() {
        return this.lines;
    }

    public void addPages() {
        this.mainPage = new ImageBuildPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    private int numberOfLines() throws IOException {
        String fileName = this.directory.append("Dockerfile").toString();
        int count = 0;
        boolean empty = false;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));){
            byte[] c = new byte[1024];
            int readChars = 0;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
        }
        return count == 0 && !empty ? 1 : count;
    }

    public boolean performFinish() {
        this.imageName = this.mainPage.getImageName();
        this.directory = new Path(this.mainPage.getDirectory());
        try {
            this.lines = this.numberOfLines();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

