/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.data.DiscovererParameterDisplay;
import org.eclipse.modisco.infra.discovery.ui.internal.launch.parametersdisplay.ParametersTableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DiscovererParametersComposite
extends Composite {
    private Group discovererParametersGroup = null;
    private InnerParametersGroup inParametersGroup = null;
    private InnerParametersGroup inoutParametersGroup = null;
    private InnerParametersGroup outParametersGroup = null;
    private ExpandBar parametersBar = null;
    private List<DiscovererParameterDisplay> discoveryParameters = Collections.emptyList();

    public DiscovererParametersComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private final void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.setLayout((Layout)gridLayout);
        this.createDiscovererParametersGroup();
    }

    private final void createDiscovererParametersGroup() {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        this.discovererParametersGroup = new Group((Composite)this, 0);
        this.discovererParametersGroup.setText(Messages.DiscovererParametersComposite_DiscovererParams);
        this.discovererParametersGroup.setLayoutData((Object)gridData1);
        this.parametersBar = new ExpandBar((Composite)this.discovererParametersGroup, 512);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.parametersBar.setLayoutData((Object)gridData);
        this.createOutParametersGroup();
        this.createInoutParametersGroup();
        this.createInParametersGroup();
        this.parametersBar.setTabList(new Control[]{this.inParametersGroup.getParametersGroup(), this.inoutParametersGroup.getParametersGroup(), this.outParametersGroup.getParametersGroup()});
        this.discovererParametersGroup.setLayout((Layout)new GridLayout());
    }

    private final void createInParametersGroup() {
        this.inParametersGroup = new InnerParametersGroup();
        this.inParametersGroup.createParametersGroup(this.parametersBar, this.getInDiscoveryParameters(), Messages.DiscovererParametersComposite_inParams, true);
    }

    private final List<DiscovererParameterDisplay> getInDiscoveryParameters() {
        ArrayList<DiscovererParameterDisplay> inParameters = new ArrayList<DiscovererParameterDisplay>();
        for (DiscovererParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDescription().getDirection() != DirectionKind.IN) continue;
            inParameters.add(parameter);
        }
        return inParameters;
    }

    private final void createInoutParametersGroup() {
        this.inoutParametersGroup = new InnerParametersGroup();
        this.inoutParametersGroup.createParametersGroup(this.parametersBar, this.getInDiscoveryParameters(), Messages.DiscovererParametersComposite_inoutParams, true);
    }

    private final List<DiscovererParameterDisplay> getInOutDiscoveryParameters() {
        ArrayList<DiscovererParameterDisplay> inoutParameters = new ArrayList<DiscovererParameterDisplay>();
        for (DiscovererParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDescription().getDirection() != DirectionKind.INOUT) continue;
            inoutParameters.add(parameter);
        }
        return inoutParameters;
    }

    private final void createOutParametersGroup() {
        this.outParametersGroup = new InnerParametersGroup();
        this.outParametersGroup.createParametersGroup(this.parametersBar, this.getInDiscoveryParameters(), Messages.DiscovererParametersComposite_outParams, false);
    }

    private final List<DiscovererParameterDisplay> getOutDiscoveryParameters() {
        ArrayList<DiscovererParameterDisplay> outParameters = new ArrayList<DiscovererParameterDisplay>();
        for (DiscovererParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDescription().getDirection() != DirectionKind.OUT) continue;
            outParameters.add(parameter);
        }
        return outParameters;
    }

    public void updateDiscoveryParameters(List<DiscovererParameterDisplay> displayParameters) {
        this.discoveryParameters = displayParameters;
        this.inParametersGroup.updateDisplayParameters(this.getInDiscoveryParameters());
        this.inoutParametersGroup.updateDisplayParameters(this.getInOutDiscoveryParameters());
        this.outParametersGroup.updateDisplayParameters(this.getOutDiscoveryParameters());
    }

    public ParametersTableComposite getInParametersGroup() {
        return this.inParametersGroup.getParametersGroup();
    }

    public ParametersTableComposite getInoutParametersGroup() {
        return this.inoutParametersGroup.getParametersGroup();
    }

    public ParametersTableComposite getOutParametersGroup() {
        return this.outParametersGroup.getParametersGroup();
    }

    private static final class InnerParametersGroup {
        private ParametersTableComposite parametersGroup = null;
        private ExpandItem parametersItem = null;

        InnerParametersGroup() {
        }

        void createParametersGroup(ExpandBar parametersBar, List<DiscovererParameterDisplay> discoveryParameters, String message, boolean editable) {
            this.parametersGroup = new ParametersTableComposite((Composite)parametersBar, 0, discoveryParameters, editable);
            this.parametersItem = new ExpandItem(parametersBar, 0, 0);
            this.parametersItem.setText(message);
            this.parametersItem.setHeight(this.parametersGroup.computeSize((int)-1, (int)-1).y);
            this.parametersItem.setControl((Control)this.parametersGroup);
            this.parametersItem.setExpanded(!discoveryParameters.isEmpty());
        }

        void updateDisplayParameters(List<DiscovererParameterDisplay> discoveryParameters) {
            this.parametersGroup.updateDisplayParameters(discoveryParameters);
            this.parametersItem.setHeight(this.parametersGroup.computeSize((int)-1, (int)-1).y);
            if (discoveryParameters.size() > 0) {
                this.parametersItem.setExpanded(true);
            } else {
                this.parametersItem.setExpanded(false);
            }
        }

        public ParametersTableComposite getParametersGroup() {
            return this.parametersGroup;
        }
    }
}

