/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pshelf;

import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class PaletteShelfRenderer
extends AbstractRenderer {
    private int textMargin = 2;
    private int margin = 2;
    private PShelf parent;
    private int spacing = 4;
    private Color shadeColor;

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        PShelfItem item = (PShelfItem)((Object)value);
        if (item.getImage() == null) {
            return new Point(wHint, gc.getFontMetrics().getHeight() + 2 * (this.margin + this.textMargin));
        }
        int h = Math.max(item.getImage().getBounds().height, gc.getFontMetrics().getHeight() + 2 * this.textMargin) + 2 * this.margin;
        if (h % 2 != 0) {
            ++h;
        }
        return new Point(wHint, h);
    }

    @Override
    public void paint(GC gc, Object value) {
        int y2;
        PShelfItem item = (PShelfItem)((Object)value);
        Color fore = this.parent.getForeground();
        gc.fillRectangle(0, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height - 1);
        gc.setForeground(this.shadeColor);
        gc.fillGradientRectangle(0, this.getBounds().y, 40, this.getBounds().height - 1, false);
        gc.setForeground(this.parent.getDisplay().getSystemColor(20));
        gc.drawLine(0, this.getBounds().y, 0, this.getBounds().y + this.getBounds().height - 1);
        gc.drawLine(0, this.getBounds().y, this.getBounds().width - 1, this.getBounds().y);
        gc.setForeground(this.parent.getDisplay().getSystemColor(18));
        gc.drawLine(0, this.getBounds().y + this.getBounds().height - 1, this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        gc.drawLine(this.getBounds().width - 1, this.getBounds().y, this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        int x = 6;
        if (item.getImage() != null) {
            y2 = (this.getBounds().height - item.getImage().getBounds().height) / 2;
            if ((this.getBounds().height - item.getImage().getBounds().height) % 2 != 0) {
                ++y2;
            }
            gc.drawImage(item.getImage(), x, this.getBounds().y + y2);
            x += item.getImage().getBounds().width + this.spacing;
        }
        gc.setForeground(fore);
        y2 = (this.getBounds().height - gc.getFontMetrics().getHeight()) / 2;
        if ((this.getBounds().height - gc.getFontMetrics().getHeight()) % 2 != 0) {
            ++y2;
        }
        if (this.isHover() && !this.isSelected()) {
            gc.setForeground(gc.getDevice().getSystemColor(26));
        }
        String text = PaletteShelfRenderer.getShortString(gc, item.getText(), this.getBounds().width - x - 4);
        gc.drawString(text, x, this.getBounds().y + y2, true);
        if (this.isFocus()) {
            gc.drawFocus(1, 1, this.getBounds().width - 2, this.getBounds().height - 1);
        }
    }

    @Override
    public void initialize(Control control) {
        this.parent = (PShelf)control;
        this.shadeColor = this.parent.getDisplay().getSystemColor(18);
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    private static String getShortString(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        if (t.equals("")) {
            return "";
        }
        if (width >= gc.stringExtent((String)t).x) {
            return t;
        }
        int w = gc.stringExtent((String)"...").x;
        Object text = t;
        int l = ((String)text).length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = ((String)text).substring(0, s);
            String s2 = ((String)text).substring(e, l);
            int l1 = gc.stringExtent((String)s1).x;
            int l2 = gc.stringExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = s1 + "..." + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = ((String)text).substring(0, 1) + "..." + ((String)text).substring(l - 1, l);
        }
        return text;
    }
}

