/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions;

import java.time.ZonedDateTime;
import java.util.function.Function;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodOpen;
import org.eclipse.passage.lic.api.tests.conditions.ValidityPeriodContractTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class ValidityPeriodOpenContractTest<V extends ValidityPeriodOpen>
extends ValidityPeriodContractTest<V> {
    @Test(expected=NullPointerException.class)
    public final void doNotInventFrom() {
        this.atLeastMonthLongFrom(null);
    }

    @Test
    public final void mustStartWithDefinedFrom() {
        this.mustBoundWithDefinedDate(this::atLeastMonthLongFrom, ValidityPeriodOpen::from);
    }

    protected final void mustBoundWithDefinedDate(Function<ZonedDateTime, V> ctor, Function<V, ZonedDateTime> bound) {
        ZonedDateTime now = ZonedDateTime.now();
        ValidityPeriodOpen period = (ValidityPeriodOpen)ctor.apply(now);
        ZonedDateTime original = bound.apply(period);
        Assert.assertEquals((Object)now, (Object)original);
    }
}

