/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.fakes.conditions;

import java.util.Optional;
import org.eclipse.passage.lic.api.EvaluationInstructions;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.api.conditions.VersionMatch;

public final class FakeCondition
implements Condition {
    private Optional<String> identifier = Optional.empty();
    private Optional<FeatureIdentifier> feature = Optional.empty();
    private Optional<VersionMatch> version = Optional.empty();
    private Optional<ValidityPeriod> period = Optional.empty();
    private Optional<EvaluationInstructions> evaluation = Optional.empty();

    public String identifier() {
        return this.getOrFail(this.identifier);
    }

    public FeatureIdentifier feature() {
        return this.getOrFail(this.feature);
    }

    public VersionMatch versionMatch() {
        return this.getOrFail(this.version);
    }

    public ValidityPeriod validityPeriod() {
        return this.getOrFail(this.period);
    }

    public EvaluationInstructions evaluationInstructions() {
        return this.getOrFail(this.evaluation);
    }

    private <T> T getOrFail(Optional<T> optional) {
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new UnsupportedOperationException();
    }

    public FakeCondition withVersionMatch(VersionMatch v) {
        this.version = Optional.ofNullable(v);
        return this;
    }

    public FakeCondition withValidityPeriod(ValidityPeriod p) {
        this.period = Optional.ofNullable(p);
        return this;
    }

    public FakeCondition withFeature(FeatureIdentifier f) {
        this.feature = Optional.ofNullable(f);
        return this;
    }

    public FakeCondition withEvaluationInstructions(EvaluationInstructions e) {
        this.evaluation = Optional.ofNullable(e);
        return this;
    }
}

