/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.RSEServicesMessages;

public class RemoteUtil {
    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Socket createSocket(final String host, final int port, int timeout, IProgressMonitor monitor) throws UnknownHostException, IOException {
        final Socket[] socket = new Socket[1];
        final Exception[] exception = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Socket newSocket = new Socket(host, port);
                    Socket[] socketArray = socket;
                    synchronized (socket) {
                        if (Thread.interrupted()) {
                            newSocket.close();
                        } else {
                            socket[0] = newSocket;
                        }
                        // ** MonitorExit[var2_4] (shouldn't be in output)
                    }
                }
                catch (UnknownHostException e) {
                    exception[0] = e;
                }
                catch (IOException e) {
                    exception[0] = e;
                }
                {
                    return;
                }
            }
        });
        thread.start();
        if (timeout <= 0) {
            timeout = 60;
        }
        int i = 0;
        while (i < timeout) {
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Socket[] socketArray = socket;
            // MONITORENTER : socket
            if (monitor.isCanceled()) {
                if (thread.isAlive()) {
                    thread.interrupt();
                }
                if (socket[0] != null) {
                    socket[0].close();
                }
                RemoteUtil.checkCanceled(monitor);
            }
            // MONITOREXIT : socketArray
            ++i;
        }
        Socket[] socketArray = socket;
        // MONITORENTER : socket
        if (thread.isAlive()) {
            thread.interrupt();
        }
        // MONITOREXIT : socketArray
        if (exception[0] != null) {
            if (!(exception[0] instanceof UnknownHostException)) throw (IOException)exception[0];
            throw (UnknownHostException)exception[0];
        }
        if (socket[0] != null) return socket[0];
        throw new InterruptedIOException(NLS.bind((String)RSEServicesMessages.Socket_timeout, (Object[])new String[]{host}));
    }
}

