/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.listener.ModelAdapter;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.navigator.CommonViewer;

public class PeerModelListener
extends ModelAdapter
implements IActivityManagerListener {
    private final IPeerModel parentModel;
    final CommonViewer viewer;

    public PeerModelListener(IPeerModel parent, CommonViewer viewer) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)viewer);
        this.parentModel = parent;
        this.viewer = viewer;
    }

    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        Tree tree;
        if (this.parentModel.equals(model) && (tree = this.viewer.getTree()) != null && !tree.isDisposed()) {
            Display display = tree.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (PeerModelListener.this.viewer.getTree() != null && !PeerModelListener.this.viewer.getTree().isDisposed()) {
                        PeerModelListener.this.viewer.refresh(true);
                    }
                }
            });
        }
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
            Tree tree = this.viewer.getTree();
            if (tree != null && !tree.isDisposed()) {
                Display display = tree.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PeerModelListener.this.viewer.getTree() != null && !PeerModelListener.this.viewer.getTree().isDisposed()) {
                            PeerModelListener.this.viewer.refresh(true);
                        }
                    }
                });
            }
            IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    IPeerNode peerNode = this.getPeerNode(ref.getEditorInput());
                    if (peerNode != null && !peerNode.isVisible()) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(new IEditorReference[]{ref}, true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    protected IPeerNode getPeerNode(Object element) {
        IPeerNode peerNode = null;
        if (element instanceof IPeerNode) {
            peerNode = (IPeerNode)element;
        } else if (element instanceof IAdaptable) {
            peerNode = (IPeerNode)((IAdaptable)element).getAdapter(IPeerNode.class);
        }
        if (peerNode == null) {
            peerNode = (IPeerNode)Platform.getAdapterManager().getAdapter(element, IPeerNode.class);
        }
        return peerNode;
    }
}

