/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.tables.properties;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.tcf.te.ui.WorkbenchPartControl;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.interfaces.IUIConstants;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.Section;

public abstract class NodePropertiesTableControl
extends WorkbenchPartControl {
    private TableViewer viewer;
    private ISelectionChangedListener editorSelectionChangedListener;
    private final Map<TableColumn, Boolean> columnSortOrder = new LinkedHashMap<TableColumn, Boolean>();

    public NodePropertiesTableControl(IWorkbenchPart parentPart) {
        super(parentPart);
    }

    @Override
    public void dispose() {
        ISelectionProvider selectionProvider;
        if (this.editorSelectionChangedListener != null && (selectionProvider = (ISelectionProvider)this.getParentPart().getAdapter(ISelectionProvider.class)) != null) {
            selectionProvider.removeSelectionChangedListener(this.editorSelectionChangedListener);
            this.editorSelectionChangedListener = null;
        }
        super.dispose();
    }

    @Override
    public void setupFormPanel(Composite parent, CustomFormToolkit toolkit) {
        ISelectionProvider selectionProvider;
        super.setupFormPanel(parent, toolkit);
        this.viewer = this.doCreateTableViewer(parent);
        this.configureTableViewer(this.viewer);
        this.configureTable(this.viewer.getTable(), this.viewer.getComparator() != null);
        ISelectionProvider iSelectionProvider = selectionProvider = this.getParentPart() != null ? (ISelectionProvider)this.getParentPart().getAdapter(ISelectionProvider.class) : null;
        if (selectionProvider != null) {
            this.editorSelectionChangedListener = this.doCreateEditorSelectionChangedListener();
            selectionProvider.addSelectionChangedListener(this.editorSelectionChangedListener);
        }
        this.createContributionItems(this.viewer);
        this.viewer.setInput((Object)(selectionProvider != null ? selectionProvider.getSelection() : null));
    }

    protected ISelectionChangedListener doCreateEditorSelectionChangedListener() {
        return new NodePropertiesTableControlSelectionChangedListener();
    }

    protected TableViewer doCreateTableViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        TableViewer tableViewer = new TableViewer(parent, 67586);
        return tableViewer;
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        Assert.isNotNull((Object)tableViewer);
        tableViewer.setLabelProvider((IBaseLabelProvider)this.doCreateTableViewerLabelProvider(tableViewer));
        tableViewer.setContentProvider((IContentProvider)this.doCreateTableViewerContentProvider(tableViewer));
        tableViewer.setComparator(this.doCreateTableViewerComparator(tableViewer));
    }

    protected abstract ITableLabelProvider doCreateTableViewerLabelProvider(TableViewer var1);

    protected abstract IStructuredContentProvider doCreateTableViewerContentProvider(TableViewer var1);

    protected ViewerComparator doCreateTableViewerComparator(TableViewer viewer) {
        return null;
    }

    protected void configureTable(Table table, boolean sorted) {
        Assert.isNotNull((Object)table);
        this.createTableColumns(table, sorted);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected void createTableColumns(final Table table, boolean sorted) {
        Assert.isNotNull((Object)table);
        TableColumn sortColumn = null;
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.NodePropertiesTableControl_column_name_label);
        this.columnSortOrder.put(column, Boolean.TRUE);
        if (sorted) {
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TableColumn) {
                        NodePropertiesTableControl.this.switchSortColumn(table, (TableColumn)e.widget);
                    }
                }
            });
        }
        sortColumn = column;
        column = new TableColumn(table, 16384);
        column.setText(Messages.NodePropertiesTableControl_column_value_label);
        this.columnSortOrder.put(column, Boolean.FALSE);
        if (sorted) {
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TableColumn) {
                        NodePropertiesTableControl.this.switchSortColumn(table, (TableColumn)e.widget);
                    }
                }
            });
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        table.setLayout((Layout)tableLayout);
        GridData layoutData = new GridData(1810);
        table.setLayoutData((Object)layoutData);
        if (sorted) {
            table.setSortColumn(sortColumn);
            table.setSortDirection(this.columnSortOrder.get(sortColumn) != false ? 128 : 1024);
        }
    }

    protected final void switchSortColumn(Table table, TableColumn column) {
        if (table == null || table.isDisposed() || column == null || column.isDisposed()) {
            return;
        }
        boolean newSortOrder = this.columnSortOrder.get(column) == false;
        table.setSortColumn(column);
        table.setSortDirection(newSortOrder ? 128 : 1024);
        this.columnSortOrder.put(column, newSortOrder);
        this.getViewer().refresh();
    }

    protected void createContributionItems(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        manager.setRemoveAllWhenShown(true);
        viewer.getTable().setMenu(manager.createContextMenu((Control)viewer.getTable()));
        if (this.getParentPart() != null && this.getParentPart().getSite() != null && this.getContextMenuId() != null) {
            IWorkbenchPartSite site = this.getParentPart().getSite();
            site.registerContextMenu(this.getContextMenuId(), manager, (ISelectionProvider)viewer);
        }
        this.createToolbarContributionItem(viewer);
    }

    protected String getContextMenuId() {
        return String.valueOf(IUIConstants.ID_CONTROL_MENUS_BASE) + ".menu.propertiesTable";
    }

    protected void createToolbarContributionItem(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        Composite parent = viewer.getTable().getParent();
        while (parent != null && !(parent instanceof Section)) {
            parent = parent.getParent();
        }
        if (parent == null || parent.isDisposed()) {
            return;
        }
        ToolBar toolbar = new ToolBar(parent, 8519936);
        final Cursor handCursor = new Cursor((Device)parent.getDisplay(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        ((Section)parent).setTextClient((Control)toolbar);
        this.createToolBarItems(toolbar);
    }

    protected void createToolBarItems(ToolBar toolbar) {
        Assert.isNotNull((Object)toolbar);
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (Viewer.class.isAssignableFrom(adapter)) {
            Viewer viewer = this.getViewer();
            if (!adapter.isAssignableFrom(viewer.getClass())) {
                viewer = null;
            }
            return viewer;
        }
        if (ISelectionListener.class.isAssignableFrom(adapter)) {
            return this.editorSelectionChangedListener;
        }
        return super.getAdapter(adapter);
    }

    protected class NodePropertiesTableControlSelectionChangedListener
    implements ISelectionChangedListener {
        protected NodePropertiesTableControlSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (NodePropertiesTableControl.this.getViewer() != null) {
                NodePropertiesTableControl.this.getViewer().setInput((Object)event.getSelection());
            }
        }
    }
}

