/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.examples.uml.ui.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.action.CommandAction;
import org.eclipse.uml2.common.util.UML2Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesAction
extends CommandAction {
    protected static final String PROPERTIES_SEPARATOR = " = ";

    protected static String format(String name, String separator, String prefix, boolean includePrefix) {
        List<String> parsedName = new ArrayList<String>();
        if (prefix != null) {
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
            }
            if (includePrefix) {
                parsedName = PropertiesAction.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(PropertiesAction.parseName(name, '_'));
        }
        StringBuffer result = new StringBuffer();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(result.length() == 0 ? nameComponent : PropertiesAction.capName(nameComponent));
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        return result.length() == 0 && prefix != null ? prefix : result.toString();
    }

    protected static List<String> parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    protected static String capName(String name) {
        return name.length() == 0 ? name : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected static String getPropertiesKey(String prefix, String string) {
        return String.valueOf(prefix) + UML2Util.getValidJavaIdentifier((String)string.replace(':', '_'));
    }

    protected static PrintWriter getPropertiesWriter(EObject eObject) {
        ArrayList<String> properties;
        URI uri;
        ResourceSet resourceSet;
        block19: {
            Resource eResource = eObject.eResource();
            resourceSet = eResource.getResourceSet();
            uri = eResource.getURI().trimFileExtension().appendFileExtension("properties");
            properties = new ArrayList<String>();
            BufferedReader lineNumberReader = null;
            try {
                try {
                    lineNumberReader = new LineNumberReader(new InputStreamReader(resourceSet.getURIConverter().createInputStream(uri)));
                    String line = ((LineNumberReader)lineNumberReader).readLine();
                    while (line != null) {
                        properties.add(line);
                        line = ((LineNumberReader)lineNumberReader).readLine();
                    }
                }
                catch (Exception line) {
                    try {
                        if (lineNumberReader != null) {
                            lineNumberReader.close();
                        }
                        break block19;
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (lineNumberReader != null) {
                        lineNumberReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (lineNumberReader != null) {
                    lineNumberReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(resourceSet.getURIConverter().createOutputStream(uri), true);
            if (!properties.isEmpty()) {
                for (String property : properties) {
                    printWriter.println(property);
                }
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return printWriter;
    }
}

