/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.update;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.transformation.evm.update.IUpdateCompleteListener;
import org.eclipse.viatra.transformation.evm.update.IUpdateCompleteProvider;

public abstract class UpdateCompleteProvider
implements IUpdateCompleteProvider {
    private final Set<IUpdateCompleteListener> listeners = new HashSet<IUpdateCompleteListener>();

    @Override
    public boolean addUpdateCompleteListener(IUpdateCompleteListener listener, boolean fireNow) {
        boolean empty = this.listeners.isEmpty();
        boolean added = this.listeners.add(listener);
        if (added) {
            if (empty) {
                this.firstListenerAdded();
            }
            if (fireNow) {
                listener.updateComplete();
            }
        }
        return added;
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    @Override
    public boolean removeUpdateCompleteListener(IUpdateCompleteListener listener) {
        boolean removed = this.listeners.remove(listener);
        if (removed && this.listeners.isEmpty()) {
            this.lastListenerRemoved();
        }
        return removed;
    }

    protected void updateCompleted() {
        for (IUpdateCompleteListener listener : this.listeners) {
            listener.updateComplete();
        }
    }

    public void dispose() {
        if (!this.listeners.isEmpty()) {
            this.lastListenerRemoved();
        }
        this.listeners.clear();
    }
}

