/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.ObserveTypeContainer;
import org.eclipse.wb.internal.core.databinding.model.SynchronizeManager;
import org.eclipse.wb.internal.core.databinding.ui.BindingDesignPage;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.filter.AllPropertiesFilter;
import org.eclipse.wb.internal.core.databinding.ui.filter.PropertyFilter;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveDecoratingLabelProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.DataBindingsRootInfo;
import org.eclipse.wb.internal.swing.databinding.model.JavaInfoDecorator;
import org.eclipse.wb.internal.swing.databinding.model.JavaInfoDeleteManager;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.DetailBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JComboBoxBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JListBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.VirtualBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.filters.HideAdvancedPropertyFilter;
import org.eclipse.wb.internal.swing.databinding.ui.filters.ShowAdvancedPropertyFilter;
import org.eclipse.wb.internal.swing.databinding.ui.filters.TypesPropertyFilter;
import org.eclipse.wb.internal.swing.databinding.ui.property.JavaInfoPropertiesManager;
import org.eclipse.wb.internal.swing.databinding.ui.providers.BindingLabelProvider;
import org.eclipse.wb.internal.swing.databinding.ui.providers.TypeImageProvider;

public final class DatabindingsProvider
implements IDatabindingsProvider {
    private static List<PropertyFilter> m_filters;
    private final JavaInfo m_javaInfoRoot;
    private final DataBindingsRootInfo m_rootInfo = new DataBindingsRootInfo(this);
    private final List<ObserveTypeContainer> m_containers;
    private final List<ObserveType> m_types = new ArrayList<ObserveType>();
    private final Map<ObserveType, ObserveTypeContainer> m_typeToContainer = new HashMap<ObserveType, ObserveTypeContainer>();
    private BindingDesignPage m_bindingPage;
    private ObserveType m_targetStartType;
    private ObserveType m_modelStartType;
    private JavaInfoDeleteManager m_javaInfoDeleteManager;

    public DatabindingsProvider(JavaInfo javaInfoRoot) throws Exception {
        this.m_javaInfoRoot = javaInfoRoot;
        this.m_containers = ExternalFactoriesHelper.getElementsInstances(ObserveTypeContainer.class, (String)"org.eclipse.wb.swing.databinding.observeTypeContainer", (String)"container");
        for (ObserveTypeContainer container : this.m_containers) {
            ObserveType observeType = container.getObserveType();
            this.m_types.add(observeType);
            this.m_typeToContainer.put(observeType, container);
            if (container.isTargetStartType()) {
                this.m_targetStartType = observeType;
            }
            if (!container.isModelStartType()) continue;
            this.m_modelStartType = observeType;
        }
    }

    public JavaInfo getJavaInfoRoot() {
        return this.m_javaInfoRoot;
    }

    public List<ObserveTypeContainer> getContainers() {
        return this.m_containers;
    }

    public ObserveTypeContainer getContainer(ObserveType type) {
        return this.m_typeToContainer.get(type);
    }

    public DataBindingsRootInfo getRootInfo() {
        return this.m_rootInfo;
    }

    public void hookJavaInfoEvents() throws Exception {
        new SynchronizeManager((IDatabindingsProvider)this, this.m_javaInfoRoot);
        this.m_javaInfoDeleteManager = new JavaInfoDeleteManager(this);
        new JavaInfoDecorator(this);
        new JavaInfoPropertiesManager(this, this.m_javaInfoRoot);
    }

    public void configureBindingViewer(IDialogSettings settings, TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn bindingColumn = new TableColumn(table, 0);
        bindingColumn.setWidth(23);
        bindingColumn.setResizable(false);
        TableColumn targetColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"TargetColumn", (int)250);
        targetColumn.setText(Messages.DatabindingsProvider_targetColumnText);
        TableColumn modelColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"ModelColumn", (int)250);
        modelColumn.setText(Messages.DatabindingsProvider_modelColumnText);
        TableColumn strategyColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"StrategyColumn", (int)170);
        strategyColumn.setText(Messages.DatabindingsProvider_strategyColumnText);
        TableColumn variableBindingColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"VariableBindingColumn", (int)250);
        variableBindingColumn.setText(Messages.DatabindingsProvider_bindingColumnText);
        viewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
    }

    public List<IBindingInfo> getBindings() {
        return CoreUtils.cast(this.m_rootInfo.getBindings());
    }

    public String getBindingPresentationText(IBindingInfo ibinding) throws Exception {
        BindingInfo binding = (BindingInfo)ibinding;
        return "Binding[" + binding.getTargetPresentationText(true) + " : " + binding.getModelPresentationText(true) + "]";
    }

    public void gotoDefinition(IBindingInfo ibinding) {
        try {
            BindingInfo binding = (BindingInfo)ibinding;
            String variable = binding.getVariableIdentifier();
            if (variable != null) {
                if (variable.endsWith("()")) {
                    variable = variable.substring(0, variable.length() - 2);
                }
                int position = this.m_javaInfoRoot.getEditor().getEnclosingNode(variable).getStartPosition();
                IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)this.m_javaInfoRoot);
                site.openSourcePosition(position);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public List<ObserveType> getTypes() {
        return this.m_types;
    }

    public ObserveType getTargetStartType() {
        return this.m_targetStartType;
    }

    public ObserveType getModelStartType() {
        return this.m_modelStartType;
    }

    public IBaseLabelProvider createPropertiesViewerLabelProvider(TreeViewer viewer) {
        return new ObserveDecoratingLabelProvider((StructuredViewer)viewer);
    }

    public List<PropertyFilter> getObservePropertyFilters() {
        if (m_filters == null) {
            m_filters = new ArrayList<PropertyFilter>();
            m_filters.add(new HideAdvancedPropertyFilter());
            m_filters.add(new ShowAdvancedPropertyFilter());
            m_filters.add((PropertyFilter)new AllPropertiesFilter(Messages.DatabindingsProvider_allTypes, TypeImageProvider.OBJECT_IMAGE));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("String", TypeImageProvider.STRING_IMAGE, String.class, Byte.TYPE, Character.TYPE));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("Boolean", TypeImageProvider.BOOLEAN_IMAGE, Boolean.TYPE, Boolean.class));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("Numbers", TypeImageProvider.NUMBER_IMAGE, Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("Color", TypeImageProvider.COLOR_IMAGE, Color.class));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("Font", TypeImageProvider.FONT_IMAGE, Font.class));
            m_filters.add((PropertyFilter)new TypesPropertyFilter("Image", TypeImageProvider.IMAGE_IMAGE, Image.class, Icon.class));
        }
        return m_filters;
    }

    public List<IObserveInfo> getObserves(ObserveType type) {
        ObserveTypeContainer container = this.m_typeToContainer.get(type);
        return container == null ? Collections.emptyList() : container.getObservables();
    }

    public void synchronizeObserves() throws Exception {
        AstEditor editor = this.m_javaInfoRoot.getEditor();
        TypeDeclaration rootNode = JavaInfoUtils.getTypeDeclaration((JavaInfo)this.m_javaInfoRoot);
        if (rootNode == null) {
            CompilationUnit astUnit = editor.getAstUnit();
            rootNode = (TypeDeclaration)astUnit.types().get(0);
        }
        for (ObserveTypeContainer container : this.m_containers) {
            container.synchronizeObserves(this.m_javaInfoRoot, editor, rootNode);
        }
    }

    public void fillExternalBindingActions(ToolBar toolBar, Menu contextMenu) {
    }

    public List<IUiContentProvider> getContentProviders(IBindingInfo ibinding, IPageListener listener) throws Exception {
        ArrayList<IUiContentProvider> providers = new ArrayList<IUiContentProvider>();
        BindingInfo binding = (BindingInfo)ibinding;
        binding.createContentProviders(this.m_rootInfo.getBindings(), providers, listener, this);
        return providers;
    }

    public boolean validate(IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty) throws Exception {
        if (target == model && targetProperty == modelProperty) {
            return false;
        }
        ObserveInfo targetObserve = (ObserveInfo)target;
        ObserveInfo targetPropertyObserve = (ObserveInfo)targetProperty;
        ObserveInfo modelObserve = (ObserveInfo)model;
        ObserveInfo modelPropertyObserve = (ObserveInfo)modelProperty;
        boolean isTargetSwingBinding = DatabindingsProvider.isSwingBinding(targetObserve, targetPropertyObserve);
        boolean isModelSwingBinding = DatabindingsProvider.isSwingBinding(modelObserve, modelPropertyObserve);
        if (isTargetSwingBinding && isModelSwingBinding) {
            return false;
        }
        if (isTargetSwingBinding ? this.findBinding(targetObserve, targetPropertyObserve) : isModelSwingBinding && this.findBinding(modelObserve, modelPropertyObserve)) {
            return false;
        }
        if (targetObserve.getCreationType() == ObserveCreationType.VirtualBinding) {
            return isModelSwingBinding;
        }
        if (modelObserve.getCreationType() == ObserveCreationType.VirtualBinding) {
            return isTargetSwingBinding;
        }
        return !targetObserve.getReference().equals(modelObserve.getReference()) || !targetPropertyObserve.getReference().equals(modelPropertyObserve.getReference());
    }

    private boolean findBinding(IObserveInfo object, IObserveInfo property) {
        for (BindingInfo binding : this.m_rootInfo.getBindings()) {
            if (binding.getTarget() == object && binding.getTargetProperty() == property) {
                return true;
            }
            if (binding.getModel() != object || binding.getModelProperty() != property) continue;
            return true;
        }
        return false;
    }

    public static boolean isSwingBinding(ObserveInfo observe, ObserveInfo propertyObserve) {
        ObserveCreationType creationType = observe.getCreationType();
        return propertyObserve.getCreationType() == ObserveCreationType.SelfProperty && (creationType == ObserveCreationType.JListBinding || creationType == ObserveCreationType.JTableBinding || creationType == ObserveCreationType.JComboBoxBinding);
    }

    public IBindingInfo createBinding(IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty) throws Exception {
        IBindingInfo binding;
        ObserveInfo targetObserve = (ObserveInfo)target;
        ObserveInfo targetPropertyObserve = (ObserveInfo)targetProperty;
        ObserveInfo modelObserve = (ObserveInfo)model;
        ObserveInfo modelPropertyObserve = (ObserveInfo)modelProperty;
        if (targetObserve.getCreationType() == ObserveCreationType.VirtualBinding || modelObserve.getCreationType() == ObserveCreationType.VirtualBinding) {
            return new VirtualBindingInfo(targetObserve, targetPropertyObserve, this.createProperty(targetObserve, targetPropertyObserve), modelObserve, modelPropertyObserve, this.createProperty(modelObserve, modelPropertyObserve));
        }
        if (targetObserve.getCreationType() != ObserveCreationType.AutoBinding && (binding = this.createSwingBinding(targetObserve, targetPropertyObserve, modelObserve, modelPropertyObserve)) != null) {
            return binding;
        }
        if (modelObserve.getCreationType() != ObserveCreationType.AutoBinding && (binding = this.createSwingBinding(modelObserve, modelPropertyObserve, targetObserve, targetPropertyObserve)) != null) {
            return binding;
        }
        UpdateStrategyInfo strategy = new UpdateStrategyInfo(UpdateStrategyInfo.Value.READ);
        PropertyInfo targetAstProperty = this.createProperty(targetObserve, targetPropertyObserve);
        PropertyInfo modelAstProperty = this.createProperty(modelObserve, modelPropertyObserve);
        return new AutoBindingInfo(strategy, targetObserve, targetPropertyObserve, targetAstProperty, modelObserve, modelPropertyObserve, modelAstProperty);
    }

    private IBindingInfo createSwingBinding(ObserveInfo component, ObserveInfo componentProperty, ObserveInfo model, ObserveInfo modelProperty) throws Exception {
        if (componentProperty.getCreationType() != ObserveCreationType.SelfProperty) {
            return null;
        }
        if (modelProperty.getCreationType() != ObserveCreationType.ListSelfProperty && modelProperty.getCreationType() != ObserveCreationType.ListProperty) {
            return null;
        }
        UpdateStrategyInfo strategy = new UpdateStrategyInfo(UpdateStrategyInfo.Value.READ);
        PropertyInfo componentAstProperty = this.createProperty(component, componentProperty);
        PropertyInfo modelAstProperty = this.createProperty(model, modelProperty);
        switch (component.getCreationType()) {
            case JListBinding: {
                return new JListBindingInfo(strategy, component, componentProperty, componentAstProperty, model, modelProperty, modelAstProperty);
            }
            case JTableBinding: {
                return new JTableBindingInfo(strategy, component, componentProperty, componentAstProperty, model, modelProperty, modelAstProperty);
            }
            case JComboBoxBinding: {
                return new JComboBoxBindingInfo(strategy, component, componentProperty, componentAstProperty, model, modelProperty, modelAstProperty);
            }
        }
        return null;
    }

    private PropertyInfo createProperty(ObserveInfo observe, ObserveInfo observeProperty) throws Exception {
        PropertyInfo astProperty = observeProperty.createProperty(observe);
        if (observeProperty.canShared()) {
            for (BindingInfo binding : this.m_rootInfo.getBindings()) {
                PropertyInfo targetAstProperty = binding.getTargetAstProperty();
                if (((Object)((Object)targetAstProperty)).getClass() == ((Object)((Object)astProperty)).getClass() && (binding.getTarget() == observe && binding.getTargetProperty() == observeProperty || targetAstProperty.canShared(astProperty))) {
                    return targetAstProperty;
                }
                PropertyInfo modelAstProperty = binding.getModelAstProperty();
                if (((Object)((Object)modelAstProperty)).getClass() != ((Object)((Object)astProperty)).getClass() || (binding.getModel() != observe || binding.getModelProperty() != observeProperty) && !modelAstProperty.canShared(astProperty)) continue;
                return modelAstProperty;
            }
        }
        return astProperty;
    }

    public void addBinding(final IBindingInfo ibinding) {
        this.getBindings().add(ibinding);
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                binding.create(DatabindingsProvider.this.m_rootInfo.getBindings());
            }
        });
        this.saveEdit();
    }

    public void editBinding(final IBindingInfo ibinding) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                binding.edit(DatabindingsProvider.this.m_rootInfo.getBindings());
            }
        });
        this.saveEdit();
    }

    public void deleteBinding(final IBindingInfo ibinding) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                if (binding.delete(DatabindingsProvider.this.m_rootInfo.getBindings())) {
                    binding.postDelete();
                    DatabindingsProvider.this.getBindings().remove((Object)binding);
                }
            }
        });
        this.saveEdit();
    }

    public void deleteAllBindings() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                for (BindingInfo binding : DatabindingsProvider.this.m_rootInfo.getBindings()) {
                    binding.postDelete();
                }
            }
        });
        this.getBindings().clear();
        this.saveEdit();
    }

    public void deleteBindings(JavaInfo javaInfo) throws Exception {
        if (this.m_javaInfoDeleteManager != null) {
            this.m_javaInfoDeleteManager.deleteJavaInfo((ObjectInfo)javaInfo);
        }
    }

    public boolean canMoveBinding(IBindingInfo binding, int targetIndex, boolean upDown) {
        if (binding instanceof DetailBindingInfo) {
            return false;
        }
        IBindingInfo target = this.getBindings().get(targetIndex);
        if (binding instanceof ColumnBindingInfo) {
            return target instanceof ColumnBindingInfo;
        }
        if (target instanceof DetailBindingInfo || target instanceof ColumnBindingInfo) {
            return upDown;
        }
        return true;
    }

    public void moveBinding(IBindingInfo binding, int sourceIndex, int targetIndex, boolean upDown) {
        if (upDown) {
            targetIndex = this.configureMoveUpDown(binding, sourceIndex, targetIndex);
        }
        List<IBindingInfo> bindings = this.getBindings();
        bindings.remove(sourceIndex);
        bindings.add(targetIndex, binding);
        BindingInfo bindingInfo = (BindingInfo)binding;
        bindingInfo.move(this.m_rootInfo.getBindings());
        this.saveEdit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int configureMoveUpDown(IBindingInfo binding, int sourceIndex, int targetIndex) {
        boolean up;
        if (binding instanceof ColumnBindingInfo) return targetIndex;
        List<IBindingInfo> bindings = this.getBindings();
        IBindingInfo target = bindings.get(targetIndex);
        boolean bl = up = sourceIndex > targetIndex;
        if (target instanceof ColumnBindingInfo) {
            ColumnBindingInfo column = (ColumnBindingInfo)target;
            if (up) {
                return bindings.indexOf(column.getJTableBinding());
            }
            target = bindings.get(targetIndex += column.getJTableBinding().getColumns().size());
            if (target instanceof JTableBindingInfo) {
                JTableBindingInfo tableBinding = (JTableBindingInfo)target;
                return targetIndex += tableBinding.getColumns().size();
            }
            if (!(target instanceof JListBindingInfo)) return targetIndex;
            return ++targetIndex;
        }
        if (target instanceof DetailBindingInfo) {
            if (up) {
                DetailBindingInfo detail = (DetailBindingInfo)target;
                return bindings.indexOf((Object)detail.getJListBinding());
            }
            if ((target = bindings.get(++targetIndex)) instanceof JTableBindingInfo) {
                JTableBindingInfo tableBinding = (JTableBindingInfo)target;
                return targetIndex += tableBinding.getColumns().size();
            }
            if (!(target instanceof JListBindingInfo)) return targetIndex;
            return ++targetIndex;
        }
        if (target instanceof JTableBindingInfo) {
            JTableBindingInfo tableBinding = (JTableBindingInfo)target;
            if (!up) {
                return targetIndex += tableBinding.getColumns().size();
            }
        }
        if (!(target instanceof JListBindingInfo)) return targetIndex;
        if (up) return targetIndex;
        ++targetIndex;
        return targetIndex;
    }

    public void setBindingPage(Object bindingPage) {
        this.m_bindingPage = (BindingDesignPage)bindingPage;
    }

    public void refreshDesigner() {
    }

    public void saveEdit() {
        final boolean[] reparse = new boolean[1];
        ExecutionUtils.run((ObjectInfo)this.m_javaInfoRoot, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                try {
                    DatabindingsProvider.this.m_rootInfo.preCommit();
                    reparse[0] = DatabindingsProvider.this.m_rootInfo.commit();
                }
                finally {
                    DatabindingsProvider.this.m_rootInfo.postCommit();
                }
                if (reparse[0]) {
                    BindingDesignPage.handleReparse((BindingDesignPage)DatabindingsProvider.this.m_bindingPage, (JavaInfo)DatabindingsProvider.this.m_javaInfoRoot);
                }
            }
        });
        if (!reparse[0]) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DatabindingsProvider.this.synchronizeObserves();
                }
            });
        }
    }
}

