/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;

public class AddExceptionBreakpointAction
implements IWorkbenchWindowActionDelegate {
    private Performer currentPerformer = null;

    public void run(IAction action) {
        if (this.currentPerformer == null) {
            return;
        }
        this.currentPerformer.run();
        this.currentPerformer = null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentPerformer = this.createPerformer(selection);
    }

    private Performer createPerformer(ISelection selection) {
        final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        return new Performer(this){

            @Override
            void run() {
                IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                boolean includingCaught = true;
                try {
                    ChromiumExceptionBreakpoint exceptionBreakpoint = new ChromiumExceptionBreakpoint((IResource)resource, includingCaught, "org.eclipse.wst.jsdt.chromium.debug");
                    breakpointManager.addBreakpoint((IBreakpoint)exceptionBreakpoint);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private abstract class Performer {
        private Performer() {
        }

        abstract void run();
    }
}

