/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;

public class BP2021
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2021(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPHeader[] soapHeaders = this.validator.getSoapHeaders(binding);
        if (soapHeaders.length == 0) {
            this.result = "notApplicable";
        } else {
            int header = 0;
            while (header < soapHeaders.length && this.result.equals("passed")) {
                if (soapHeaders[header].getPart() == null || !XMLUtils.isNmtoken(soapHeaders[header].getPart())) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(soapHeaders[header].toString(), entryContext);
                } else {
                    List soapHeaderFaultList = soapHeaders[header].getSOAPHeaderFaults();
                    Iterator iterator = soapHeaderFaultList.iterator();
                    while (iterator.hasNext() && this.result.equals("passed")) {
                        SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)iterator.next();
                        if (soapHeaderFault.getPart() != null && XMLUtils.isNmtoken(soapHeaderFault.getPart())) continue;
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail(soapHeaderFault.toString(), entryContext);
                    }
                }
                ++header;
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

