/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPVariableElement;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class BPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fJARImage = DLTKPluginImages.get("org.eclipse.dltk.ui.jar_l_obj.png");
    private Image fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Color fResolvedBackground;
    private boolean fHighlightReadOnly;

    public BPVariableElementLabelProvider(boolean highlightReadOnly) {
        this.fHighlightReadOnly = highlightReadOnly;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object element) {
        if (element instanceof BPVariableElement) {
            BPVariableElement curr = (BPVariableElement)element;
            IPath path = curr.getPath();
            if (path.toFile().isFile()) {
                return this.fJARImage;
            }
            return this.fFolderImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof BPVariableElement) {
            BPVariableElement curr = (BPVariableElement)element;
            String name = curr.getName();
            IPath path = curr.getPath();
            String result = name;
            ArrayList<String> restrictions = new ArrayList<String>(2);
            if (curr.isReadOnly() && this.fHighlightReadOnly) {
                restrictions.add(NewWizardMessages.BPVariableElementLabelProvider_read_only);
            }
            if (restrictions.size() == 1) {
                result = NLS.bind((String)NewWizardMessages.BPVariableElementLabelProvider_one_restriction, (Object[])new Object[]{result, restrictions.get(0)});
            } else if (restrictions.size() == 2) {
                result = NLS.bind((String)NewWizardMessages.BPVariableElementLabelProvider_two_restrictions, (Object[])new Object[]{result, restrictions.get(0), restrictions.get(1)});
            }
            if (path != null) {
                String appendix = !path.isEmpty() ? TextProcessor.process((String)path.toOSString(), (String)"*.?/\\:.") : NewWizardMessages.BPVariableElementLabelProvider_empty;
                result = NLS.bind((String)NewWizardMessages.BPVariableElementLabelProvider_appendix, (Object[])new Object[]{result, appendix});
            }
            return result;
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof BPVariableElement) {
            BPVariableElement curr = (BPVariableElement)element;
            if (this.fHighlightReadOnly && curr.isReadOnly()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

