/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NodeStyle implements Enumerator
{
    BOLD(0, "bold", "bold"),
    DASHED(1, "dashed", "dashed"),
    DIAGONALS(2, "diagonals", "diagonals"),
    DOTTED(3, "dotted", "dotted"),
    FILLED(4, "filled", "filled"),
    INVIS(5, "invis", "invis"),
    RADIAL(6, "radial", "radial"),
    ROUNDED(7, "rounded", "rounded"),
    SOLID(8, "solid", "solid"),
    STRIPED(9, "striped", "striped"),
    WEDGED(10, "wedged", "wedged");

    public static final int BOLD_VALUE = 0;
    public static final int DASHED_VALUE = 1;
    public static final int DIAGONALS_VALUE = 2;
    public static final int DOTTED_VALUE = 3;
    public static final int FILLED_VALUE = 4;
    public static final int INVIS_VALUE = 5;
    public static final int RADIAL_VALUE = 6;
    public static final int ROUNDED_VALUE = 7;
    public static final int SOLID_VALUE = 8;
    public static final int STRIPED_VALUE = 9;
    public static final int WEDGED_VALUE = 10;
    private static final NodeStyle[] VALUES_ARRAY;
    public static final List<NodeStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NodeStyle[]{BOLD, DASHED, DIAGONALS, DOTTED, FILLED, INVIS, RADIAL, ROUNDED, SOLID, STRIPED, WEDGED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NodeStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NodeStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NodeStyle get(int value) {
        switch (value) {
            case 0: {
                return BOLD;
            }
            case 1: {
                return DASHED;
            }
            case 2: {
                return DIAGONALS;
            }
            case 3: {
                return DOTTED;
            }
            case 4: {
                return FILLED;
            }
            case 5: {
                return INVIS;
            }
            case 6: {
                return RADIAL;
            }
            case 7: {
                return ROUNDED;
            }
            case 8: {
                return SOLID;
            }
            case 9: {
                return STRIPED;
            }
            case 10: {
                return WEDGED;
            }
        }
        return null;
    }

    private NodeStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

