/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.anchors;

import java.util.List;
import java.util.Set;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IComputationStrategy;
import org.eclipse.gef.fx.anchors.ProjectionStrategy;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.Ellipse;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;

public class ChopBoxStrategy
extends ProjectionStrategy {
    protected Point computeAnchorageReferencePointInLocal(Node anchorage, IGeometry geometryInLocal, Point anchoredReferencePointInAnchorageLocal) {
        Point boundsCenterInLocal;
        if (geometryInLocal instanceof IShape) {
            IShape shape = (IShape)geometryInLocal;
            Point boundsCenterInLocal2 = geometryInLocal.getBounds().getCenter();
            if (shape.contains(boundsCenterInLocal2)) {
                return boundsCenterInLocal2;
            }
        } else if (geometryInLocal instanceof Path && geometryInLocal.contains(boundsCenterInLocal = geometryInLocal.getBounds().getCenter())) {
            return boundsCenterInLocal;
        }
        return null;
    }

    protected Point computeAnchorageReferencePointInScene(Node anchorage, IGeometry geometryInLocal, Point anchoredReferencePointInScene) {
        Point2D anchoredReferencePointInAnchorageLocal = anchorage.sceneToLocal(anchoredReferencePointInScene.x, anchoredReferencePointInScene.y);
        Point anchorageReferencePointInLocal = this.computeAnchorageReferencePointInLocal(anchorage, geometryInLocal, new Point(anchoredReferencePointInAnchorageLocal.getX(), anchoredReferencePointInAnchorageLocal.getY()));
        if (anchorageReferencePointInLocal == null) {
            return null;
        }
        return NodeUtils.localToScene(anchorage, anchorageReferencePointInLocal);
    }

    @Override
    public Point computePositionInScene(Node anchorage, Node anchored, Set<IComputationStrategy.Parameter<?>> parameters) {
        Point anchoredReferencePointInLocal;
        Point anchoredReferencePointInScene;
        IGeometry anchorageReferenceGeometryInLocal = (IGeometry)IComputationStrategy.Parameter.get(parameters, DynamicAnchor.AnchorageReferenceGeometry.class).get();
        Point anchorageReferencePointInScene = this.computeAnchorageReferencePointInScene(anchorage, anchorageReferenceGeometryInLocal, anchoredReferencePointInScene = NodeUtils.localToScene(anchored, anchoredReferencePointInLocal = (Point)IComputationStrategy.Parameter.get(parameters, DynamicAnchor.AnchoredReferencePoint.class).get()));
        if (anchorageReferencePointInScene == null) {
            return super.computePositionInScene(anchorage, anchored, parameters);
        }
        Line referenceLineInScene = new Line(anchorageReferencePointInScene, anchoredReferencePointInScene);
        IGeometry anchorageGeometryInScene = NodeUtils.localToScene(anchorage, anchorageReferenceGeometryInLocal);
        if (anchorageGeometryInScene instanceof Ellipse) {
            Point[] intersections = ((Ellipse)anchorageGeometryInScene).getIntersections(referenceLineInScene);
            if (intersections.length > 0) {
                return Point.nearest((Point)anchoredReferencePointInScene, (Point[])intersections);
            }
        } else {
            List<ICurve> anchorageOutlinesInScene = this.getOutlineSegments(anchorageGeometryInScene);
            Point nearestProjectionInScene = null;
            double nearestDistance = 0.0;
            for (ICurve anchorageOutlineInScene : anchorageOutlinesInScene) {
                if (anchorageOutlineInScene.contains(anchoredReferencePointInScene)) {
                    return anchoredReferencePointInScene;
                }
                Point[] intersections = anchorageOutlineInScene.getIntersections((ICurve)referenceLineInScene);
                if (intersections.length <= 0) continue;
                Point nearestIntersection = Point.nearest((Point)anchoredReferencePointInScene, (Point[])intersections);
                double distance = anchoredReferencePointInScene.getDistance(nearestIntersection);
                if (nearestProjectionInScene != null && !(distance < nearestDistance)) continue;
                nearestProjectionInScene = nearestIntersection;
                nearestDistance = distance;
            }
            if (nearestProjectionInScene != null) {
                return nearestProjectionInScene;
            }
        }
        return super.computePositionInScene(anchorage, anchored, parameters);
    }
}

