/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaAttributesContainer;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaJaxbClass;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.AbstractOxmTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.ELXmlAccessOrder;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.ELXmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmAttributesContainer;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmJavaAttributeImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmTypeName;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class OxmJavaTypeImpl
extends AbstractOxmTypeMapping
implements OxmJavaType {
    protected String specifiedName;
    protected String superTypeName;
    protected String defaultSuperTypeName;
    protected String specifiedSuperTypeName;
    protected JaxbClassMapping superclass;
    protected XmlAccessOrder defaultAccessOrder;
    protected XmlAccessOrder specifiedAccessOrder;
    protected XmlAccessType accessType;
    protected XmlAccessType defaultAccessType;
    protected XmlAccessType specifiedAccessType;
    protected final Vector<OxmJavaAttribute> specifiedAttributes = new Vector();
    protected final SpecifiedAttributeContainerAdapter specifiedAttributeContainerAdapter = new SpecifiedAttributeContainerAdapter();
    protected static final String DEFAULT_ATTRIBUTES_COLLECTION = "defaultAttributes";
    protected final JaxbAttributesContainer defaultAttributesContainer = new DefaultAttributesContainer(this, new DefaultAttributesContainerContext());

    public OxmJavaTypeImpl(OxmXmlBindings parent, EJavaType eJavaType) {
        super(parent, eJavaType);
        this.initSpecifiedName();
        this.initSuperTypeName();
        this.initSpecifiedAccessOrder();
        this.initDefaultAccessOrder();
        this.initAccessType();
        this.initAttributes();
    }

    @Override
    public EJavaType getETypeMapping() {
        return (EJavaType)super.getETypeMapping();
    }

    public TypeKind getTypeKind() {
        return TypeKind.CLASS;
    }

    protected JavaClass buildJavaType(JavaResourceAbstractType resourceType) {
        if (resourceType.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE) {
            return new GenericJavaJaxbClass((JaxbContextNode)this, (JavaResourceType)resourceType);
        }
        return null;
    }

    @Override
    public JavaClass getJavaType() {
        return (JavaClass)super.getJavaType();
    }

    protected JaxbClassMapping getJavaClassMapping() {
        JavaClass javaClass = this.getJavaType();
        return javaClass == null ? null : javaClass.getMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.syncSuperTypeName();
        this.syncSpecifiedAccessOrder();
        this.syncAccessType();
        this.syncAttributes();
    }

    @Override
    public void update() {
        super.update();
        this.updateSuperTypeName();
        this.updateSuperclass();
        this.updateDefaultAccessOrder();
        this.updateAccessType();
        this.updateAttributes();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newName) {
        this.setSpecifiedName_(newName);
        this.getETypeMapping().setName(newName);
    }

    protected void setSpecifiedName_(String newName) {
        String oldName = this.specifiedName;
        this.specifiedName = newName;
        this.firePropertyChanged("specifiedName", oldName, newName);
    }

    protected void initSpecifiedName() {
        this.specifiedName = this.buildSpecifiedName();
    }

    protected String buildSpecifiedName() {
        return this.getETypeMapping().getName();
    }

    @Override
    protected void updateTypeName() {
        String newFqName;
        String fqName = this.typeName.getFullyQualifiedName();
        if (!ObjectTools.equals((Object)fqName, (Object)(newFqName = this.getXmlBindings().getQualifiedName(this.specifiedName)))) {
            this.setTypeName_(this.buildTypeName());
        }
    }

    @Override
    protected TypeName buildTypeName() {
        return new OxmTypeName(this.getXmlBindings().getQualifiedName(this.specifiedName));
    }

    @Override
    public String getSuperTypeName() {
        return this.superTypeName;
    }

    protected void setSuperTypeName_(String superTypeName) {
        String old = this.superTypeName;
        this.superTypeName = superTypeName;
        this.firePropertyChanged("superTypeName", old, superTypeName);
    }

    @Override
    public String getDefaultSuperTypeName() {
        return this.defaultSuperTypeName;
    }

    protected void setDefaultSuperTypeName_(String superTypeName) {
        String old = this.defaultSuperTypeName;
        this.defaultSuperTypeName = superTypeName;
        this.firePropertyChanged("defaultSuperTypeName", old, superTypeName);
    }

    @Override
    public String getSpecifiedSuperTypeName() {
        return this.specifiedSuperTypeName;
    }

    @Override
    public void setSpecifiedSuperTypeName(String superTypeName) {
        this.setSpecifiedSuperTypeName_(superTypeName);
        this.getETypeMapping().setSuperType(superTypeName);
    }

    protected void setSpecifiedSuperTypeName_(String superTypeName) {
        String old = this.specifiedSuperTypeName;
        this.specifiedSuperTypeName = superTypeName;
        this.firePropertyChanged("specifiedSuperTypeName", old, superTypeName);
    }

    protected void initSuperTypeName() {
        this.specifiedSuperTypeName = this.getETypeMapping().getSuperType();
    }

    protected void syncSuperTypeName() {
        this.setSpecifiedSuperTypeName_(this.getETypeMapping().getSuperType());
    }

    protected void updateSuperTypeName() {
        JavaResourceAbstractType resourceType;
        String defaultTypeName = null;
        JavaClass javaType = this.getJavaType();
        if (javaType != null && (resourceType = javaType.getJavaResourceType()).getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.TYPE) {
            defaultTypeName = ((JavaResourceType)resourceType).getSuperclassQualifiedName();
        }
        this.setDefaultSuperTypeName_(defaultTypeName);
        String typeName = this.specifiedSuperTypeName != null ? this.specifiedSuperTypeName : this.defaultSuperTypeName;
        this.setSuperTypeName_(typeName);
    }

    public JaxbClassMapping getSuperclass() {
        return this.superclass;
    }

    protected void setSuperclass_(JaxbClassMapping superclass) {
        JaxbClassMapping old = this.superclass;
        this.superclass = superclass;
        this.firePropertyChanged("superclass", old, superclass);
    }

    protected void updateSuperclass() {
        if (this.superTypeName != null) {
            this.setSuperclass_(this.getContextRoot().getClassMapping(this.superTypeName));
        } else {
            this.setSuperclass_(null);
        }
    }

    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.defaultAccessOrder;
    }

    public XmlAccessOrder getDefaultAccessOrder() {
        return this.defaultAccessOrder;
    }

    protected void setDefaultAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.defaultAccessOrder;
        this.defaultAccessOrder = accessOrder;
        this.firePropertyChanged("defaultAccessOrder", old, accessOrder);
    }

    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getETypeMapping().setXmlAccessorOrder(ELXmlAccessOrder.toOxmResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", old, accessOrder);
    }

    protected void initDefaultAccessOrder() {
        this.defaultAccessOrder = this.buildDefaultAccessOrder();
    }

    protected void updateDefaultAccessOrder() {
        this.setDefaultAccessOrder_(this.buildDefaultAccessOrder());
    }

    protected XmlAccessOrder buildDefaultAccessOrder() {
        XmlAccessOrder access;
        JaxbClassMapping javaMapping;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaClassMapping()) != null && (access = javaMapping.getSpecifiedAccessOrder()) != null) {
            return access;
        }
        if (this.superclass != null && (access = this.getSuperclass().getAccessOrder()) != null) {
            return access;
        }
        access = this.getXmlBindings().getSpecifiedAccessOrder();
        if (access != null) {
            return access;
        }
        return XmlAccessOrder.UNDEFINED;
    }

    protected void initSpecifiedAccessOrder() {
        this.specifiedAccessOrder = this.buildSpecifiedAccessOrder();
    }

    protected void syncSpecifiedAccessOrder() {
        this.setSpecifiedAccessOrder_(this.buildSpecifiedAccessOrder());
    }

    protected XmlAccessOrder buildSpecifiedAccessOrder() {
        return ELXmlAccessOrder.fromOxmResourceModel(this.getETypeMapping().getXmlAccessorOrder());
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    protected void setAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.accessType;
        this.accessType = accessType;
        this.firePropertyChanged("accessType", old, accessType);
    }

    public XmlAccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    protected void setDefaultAccessType_(XmlAccessType access) {
        XmlAccessType old = this.defaultAccessType;
        this.defaultAccessType = access;
        this.firePropertyChanged("defaultAccessType", old, access);
    }

    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    public void setSpecifiedAccessType(XmlAccessType access) {
        this.setSpecifiedAccessType_(access);
        this.getETypeMapping().setXmlAccessorType(ELXmlAccessType.toOxmResourceModel(access));
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", old, access);
    }

    protected void initAccessType() {
        this.specifiedAccessType = this.buildSpecifiedAccessType();
    }

    protected void syncAccessType() {
        this.setSpecifiedAccessType_(this.buildSpecifiedAccessType());
    }

    protected void updateAccessType() {
        this.setDefaultAccessType_(this.buildDefaultAccessType());
        XmlAccessType actual = this.specifiedAccessType != null ? this.specifiedAccessType : this.defaultAccessType;
        this.setAccessType_(actual);
    }

    protected XmlAccessType buildDefaultAccessType() {
        XmlAccessType access;
        JaxbClassMapping javaMapping;
        if (!this.getXmlBindings().isXmlMappingMetadataComplete() && (javaMapping = this.getJavaClassMapping()) != null && (access = javaMapping.getSpecifiedAccessType()) != null) {
            return access;
        }
        if (this.superclass != null && (access = this.getSuperclass().getAccessType()) != null) {
            return access;
        }
        access = this.getXmlBindings().getSpecifiedAccessType();
        if (access != null) {
            return access;
        }
        return XmlAccessType.PUBLIC_MEMBER;
    }

    protected XmlAccessType buildSpecifiedAccessType() {
        return ELXmlAccessType.fromOxmResourceModel(this.getETypeMapping().getXmlAccessorType());
    }

    public String getFactoryClass() {
        return null;
    }

    public String getSpecifiedFactoryClass() {
        return null;
    }

    public void setSpecifiedFactoryClass(String factoryClass) {
    }

    public String getFactoryMethod() {
        return null;
    }

    public void setFactoryMethod(String factoryMethod) {
    }

    public ListIterable<String> getPropOrder() {
        return EmptyListIterable.instance();
    }

    public int getPropOrderSize() {
        return 0;
    }

    public String getProp(int index) {
        return null;
    }

    public void addProp(int index, String prop) {
    }

    public void removeProp(int index) {
    }

    public void removeProp(String prop) {
    }

    public void moveProp(int targetIndex, int sourceIndex) {
    }

    public Iterable<JaxbPersistentAttribute> getAttributes() {
        return EmptyIterable.instance();
    }

    public int getAttributesSize() {
        return 0;
    }

    public Iterable<JaxbPersistentAttribute> getIncludedAttributes() {
        return EmptyIterable.instance();
    }

    public int getIncludedAttributesSize() {
        return 0;
    }

    public Iterable<JaxbPersistentAttribute> getAllLocallyDefinedAttributes() {
        return EmptyIterable.instance();
    }

    public Iterable<JaxbPersistentAttribute> getInheritedAttributes() {
        return EmptyIterable.instance();
    }

    public JaxbAttributesContainer buildIncludedAttributesContainer(JaxbClassMapping parent, JaxbAttributesContainer.Context context) {
        return new OxmAttributesContainer(parent);
    }

    protected Iterable<JaxbAttributeMapping> getDefaultAttributes() {
        return this.defaultAttributesContainer.getAttributes();
    }

    @Override
    public ListIterable<OxmJavaAttribute> getSpecifiedAttributes() {
        return IterableTools.cloneLive(this.specifiedAttributes);
    }

    @Override
    public int getSpecifiedAttributesSize() {
        return this.specifiedAttributes.size();
    }

    protected void addSpecifiedAttribute_(int index, EJavaAttribute resourceAttribute) {
        OxmJavaAttribute attribute = this.buildSpecifiedAttribute(resourceAttribute);
        this.addItemToList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void removeSpecifiedAttribute_(OxmJavaAttribute attribute) {
        this.removeItemFromList(attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void moveSpecifiedAttribute_(int index, OxmJavaAttribute attribute) {
        this.moveItemInList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void initAttributes() {
        for (EJavaAttribute eJavaAttribute : this.getETypeMapping().getJavaAttributes()) {
            this.specifiedAttributes.add(this.buildSpecifiedAttribute(eJavaAttribute));
        }
    }

    protected void syncAttributes() {
        ContextContainerTools.synchronizeWithResourceModel((ContextContainerTools.Adapter)this.specifiedAttributeContainerAdapter);
    }

    protected void updateAttributes() {
        ContextContainerTools.update((ContextContainerTools.Adapter)this.specifiedAttributeContainerAdapter);
    }

    protected OxmJavaAttribute buildSpecifiedAttribute(EJavaAttribute resourceAttribute) {
        return new OxmJavaAttributeImpl(this, resourceAttribute);
    }

    @Override
    public void attributeMappingChanged(OxmJavaAttribute attribute, OxmAttributeMapping oldMapping, OxmAttributeMapping newMapping) {
    }

    public JaxbAttributeMapping getXmlIdMapping() {
        return null;
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getETypeMapping().getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getNameTextRange() {
        return this.getETypeMapping().getNameTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages, reporter);
    }

    protected void validateName(List<IMessage> messages, IReporter reporter) {
        if (StringTools.isBlank((String)this.specifiedName)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJaxbEclipseLinkCoreValidationMessages.OXM_JAVA_TYPE__NAME_NOT_SPECIFIED));
            return;
        }
        String packageName = TypeDeclarationTools.packageName((String)this.specifiedName);
        if (!StringTools.isBlank((String)packageName) && !ObjectTools.equals((Object)packageName, (Object)this.getXmlBindings().getPackageName())) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJaxbEclipseLinkCoreValidationMessages.OXM_JAVA_TYPE__PACKAGE_NAME_NOT_UNIFORM));
        }
    }

    protected class DefaultAttributesContainer
    extends GenericJavaAttributesContainer {
        protected DefaultAttributesContainer(OxmJavaTypeImpl parent, JaxbAttributesContainer.Context context) {
            super((JaxbClassMapping)parent, context, null);
        }

        public boolean isFor(JavaResourceType javaResourceType) {
            if (this.javaResourceType == null) {
                return false;
            }
            return super.isFor(javaResourceType);
        }

        protected Iterable<JavaResourceField> getResourceFields() {
            if (this.javaResourceType == null) {
                return EmptyIterable.instance();
            }
            return super.getResourceFields();
        }

        protected Iterable<JavaResourceMethod> getResourceMethods() {
            if (this.javaResourceType == null) {
                return EmptyIterable.instance();
            }
            return super.getResourceMethods();
        }

        protected void setJavaResourceType(JavaResourceType javaResourceType) {
            this.javaResourceType = javaResourceType;
        }
    }

    protected class DefaultAttributesContainerContext
    implements JaxbAttributesContainer.Context {
        protected DefaultAttributesContainerContext() {
        }

        public XmlAccessType getAccessType() {
            return OxmJavaTypeImpl.this.getAccessType();
        }

        public void attributeAdded(JaxbPersistentAttribute attribute) {
            OxmJavaTypeImpl.this.fireItemAdded(OxmJavaTypeImpl.DEFAULT_ATTRIBUTES_COLLECTION, attribute);
        }

        public void attributeRemoved(JaxbPersistentAttribute attribute) {
            OxmJavaTypeImpl.this.fireItemRemoved(OxmJavaTypeImpl.DEFAULT_ATTRIBUTES_COLLECTION, attribute);
        }
    }

    protected class SpecifiedAttributeContainerAdapter
    implements ContextContainerTools.Adapter<OxmJavaAttribute, EJavaAttribute> {
        protected SpecifiedAttributeContainerAdapter() {
        }

        public Iterable<OxmJavaAttribute> getContextElements() {
            return OxmJavaTypeImpl.this.getSpecifiedAttributes();
        }

        public Iterable<EJavaAttribute> getResourceElements() {
            return OxmJavaTypeImpl.this.getETypeMapping().getJavaAttributes();
        }

        public EJavaAttribute getResourceElement(OxmJavaAttribute contextElement) {
            return contextElement.getEJavaAttribute();
        }

        public void addContextElement(int index, EJavaAttribute resourceElement) {
            OxmJavaTypeImpl.this.addSpecifiedAttribute_(index, resourceElement);
        }

        public void removeContextElement(OxmJavaAttribute element) {
            OxmJavaTypeImpl.this.removeSpecifiedAttribute_(element);
        }

        public void moveContextElement(int index, OxmJavaAttribute element) {
            OxmJavaTypeImpl.this.moveSpecifiedAttribute_(index, element);
        }
    }
}

