/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractCustomizableLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.internal.AbstractJavaProjectConfigurator;
import org.eclipse.m2e.pde.connector.PDEProjectHelper;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;

public class TychoLifecycleMapping
extends AbstractCustomizableLifecycleMapping {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.mavenProject();
        IMavenProjectFacade facade = request.mavenProjectFacade();
        IProject project = facade.getProject();
        String packaging = facade.getPackaging();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            PDEProjectHelper.configurePDEBundleProject(project, mavenProject, monitor);
        } else if ("eclipse-feature".equals(packaging)) {
            PDEProjectHelper.configurePDEFeatureProject(facade, monitor);
        }
        super.configure(request, monitor);
    }

    public List<AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade projectFacade, IProgressMonitor monitor) {
        String packaging = projectFacade.getPackaging();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            ArrayList<AbstractProjectConfigurator> list = new ArrayList<AbstractProjectConfigurator>(super.getProjectConfigurators(projectFacade, monitor));
            list.add((AbstractProjectConfigurator)new EclipsePluginProjectConfigurator());
            return list;
        }
        return super.getProjectConfigurators(projectFacade, monitor);
    }

    private static IBuild getBuild(IProject project) throws CoreException {
        IFile buildFile = PDEProject.getBuildProperties((IProject)project);
        WorkspaceBuildModel buildModel = null;
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        return buildModel != null ? buildModel.getBuild() : null;
    }

    private static final class EclipsePluginProjectConfigurator
    extends AbstractJavaProjectConfigurator {
        private EclipsePluginProjectConfigurator() {
        }

        protected void addProjectSourceFolders(IClasspathDescriptor classpath, Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            MavenProject mavenProject = request.mavenProject();
            IProject project = request.mavenProjectFacade().getProject();
            IBuild build = TychoLifecycleMapping.getBuild(project);
            if (build == null) {
                super.addProjectSourceFolders(classpath, options, request, monitor);
            } else {
                IBuildEntry sourceEntry = build.getEntry("source..");
                if (sourceEntry == null) {
                    return;
                }
                IBuildEntry outputEntry = build.getEntry("output..");
                String outputDirectory = outputEntry != null && outputEntry.getTokens().length > 0 ? outputEntry.getTokens()[0] : mavenProject.getBuild().getOutputDirectory();
                IContainer outputFolder = this.getFolder(project, outputDirectory);
                M2EUtils.createFolder((IContainer)outputFolder, (boolean)true, (IProgressMonitor)subMonitor.split(10));
                IPath[] inclusion = new IPath[]{};
                IPath[] exclusion = new IPath[]{};
                String mainSourceEncoding = null;
                this.addSourceDirs(classpath, project, Arrays.asList(sourceEntry.getTokens()), outputFolder.getFullPath(), inclusion, exclusion, mainSourceEncoding, (IProgressMonitor)subMonitor.split(10), false);
            }
        }

        protected IContainer getOutputLocation(ProjectConfigurationRequest request, IProject project) throws CoreException {
            IBuild build = TychoLifecycleMapping.getBuild(project);
            if (build == null) {
                return super.getOutputLocation(request, project);
            }
            IBuildEntry outputEntry = build.getEntry("output..");
            if (outputEntry != null && outputEntry.getTokens().length > 0) {
                return this.getFolder(project, outputEntry.getTokens()[0]);
            }
            return super.getOutputLocation(request, project);
        }

        protected void addJavaProjectOptions(Map<String, String> options, ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
            IProject project = request.mavenProjectFacade().getProject();
            IPluginModelBase model = PluginRegistry.findModel((IProject)project);
            if (model != null) {
                ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
            } else {
                super.addJavaProjectOptions(options, request, monitor);
            }
        }
    }
}

