/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;

public class XmlCleaner {
    public static BufferedReader clean(Reader in, File tempFile) {
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer(in, null);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter content = new BufferedWriter(new FileWriter(tempFile));){
                content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                        String resourceID;
                        HtmlTag tag = (HtmlTag)token.getValue();
                        if (tag.getAttribute("resource") != null) {
                            resourceID = tag.getAttribute("resource");
                            tag.setAttribute("resource", resourceID.replace("&", "&amp;"));
                        }
                        if (tag.getAttribute("rdf:about") != null) {
                            resourceID = tag.getAttribute("rdf:about");
                            tag.setAttribute("rdf:about", resourceID.replace("&", "&amp;"));
                        }
                    }
                    if (!token.toString().startsWith("<?xml")) {
                        content.append(token.toString());
                    }
                    token = tokenizer.nextToken();
                }
                return new BufferedReader(new FileReader(tempFile));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException exception) {
            return null;
        }
    }
}

