/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Function;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public interface ISequenceElement
extends Adapter {
    public static final Function<ISequenceElement, View> NOTATION_VIEW = new Function<ISequenceElement, View>(){

        public View apply(ISequenceElement from) {
            return from.getNotationView();
        }
    };
    public static final Function<ISequenceElement, EObject> SEMANTIC_TARGET = new Function<ISequenceElement, EObject>(){

        public EObject apply(ISequenceElement from) {
            EObject semantic = null;
            View notationView = from.getNotationView();
            if (notationView != null && notationView.getElement() instanceof DSemanticDecorator) {
                semantic = ((DSemanticDecorator)notationView.getElement()).getTarget();
            }
            return semantic;
        }
    };
    public static final Function<ISequenceElement, Rectangle> PROPER_LOGICAL_BOUNDS = new Function<ISequenceElement, Rectangle>(){

        public Rectangle apply(ISequenceElement from) {
            return from.getProperLogicalBounds();
        }
    };

    public View getNotationView();

    public Option<EObject> getSemanticTargetElement();

    public SequenceDiagram getDiagram();

    public Option<Lifeline> getLifeline();

    public Rectangle getProperLogicalBounds();
}

