/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

public final class StrictChecks {
    private static final boolean STRICT_CHECKS_ENABLED = System.getProperty("org.eclipse.swt.internal.enableStrictChecks") != null;
    private static boolean temporarilyDisabled = false;

    private StrictChecks() {
    }

    public static void runIfStrictChecksEnabled(Runnable runnable) {
        if (STRICT_CHECKS_ENABLED && !temporarilyDisabled) {
            runnable.run();
        }
    }

    public static void runWithStrictChecksDisabled(Runnable runnable) {
        temporarilyDisabled = true;
        try {
            runnable.run();
        }
        finally {
            temporarilyDisabled = false;
        }
    }
}

