/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.model;

import java.util.Objects;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.model.IElement;

public abstract class AbstractElement
implements IElement {
    private double x = 0.0;
    private double y = 0.0;
    private Color color = Display.getDefault().getSystemColor(2);
    private int alpha = 255;

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.getX(), this.getY());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractElement other = (AbstractElement)obj;
        return Objects.equals(this.color, other.color) && Double.doubleToLongBits(this.getX()) == Double.doubleToLongBits(other.getX()) && Double.doubleToLongBits(this.getY()) == Double.doubleToLongBits(other.getY());
    }

    public String toString() {
        return "AbstractElement [x=" + this.getX() + ", y=" + this.getY() + ", color=" + String.valueOf(this.color) + "]";
    }
}

