/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationTypeDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmElementImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JvmAnnotationReferenceImpl
extends JvmElementImpl<JvmAnnotationReference>
implements AnnotationReference {
    public AnnotationTypeDeclaration getAnnotationTypeDeclaration() {
        TypeDeclaration _typeDeclaration = this.getCompilationUnit().toTypeDeclaration((JvmDeclaredType)((JvmAnnotationReference)this.getDelegate()).getAnnotation());
        return (AnnotationTypeDeclaration)_typeDeclaration;
    }

    public Expression getExpression(String property) {
        JvmOperation op = this.findOperation(property);
        Functions.Function1 _function = it -> Objects.equals(it.getOperation(), op) || it.getOperation() == null && Objects.equals(op.getSimpleName(), "value");
        JvmAnnotationValue annotationValue = (JvmAnnotationValue)IterableExtensions.findFirst((Iterable)((JvmAnnotationReference)this.getDelegate()).getValues(), (Functions.Function1)_function);
        boolean _matched = false;
        if (annotationValue instanceof JvmCustomAnnotationValue) {
            _matched = true;
            EObject _head = (EObject)IterableExtensions.head((Iterable)((JvmCustomAnnotationValue)annotationValue).getValues());
            XExpression expression = (XExpression)_head;
            if (expression != null && this.getCompilationUnit().isBelongedToCompilationUnit((EObject)expression)) {
                return this.getCompilationUnit().toExpression(expression);
            }
        }
        return null;
    }

    public Object getValue(String property) {
        try {
            boolean isArrayType;
            JvmOperation op = this.findOperation(property);
            Functions.Function1 _function = it -> Objects.equals(it.getOperation(), op) || it.getOperation() == null && Objects.equals(op.getSimpleName(), "value");
            JvmAnnotationValue annotationValue = (JvmAnnotationValue)IterableExtensions.findFirst((Iterable)((JvmAnnotationReference)this.getDelegate()).getValues(), (Functions.Function1)_function);
            boolean bl = isArrayType = op != null && this.getCompilationUnit().getTypeReferences().isArray(op.getReturnType());
            if (annotationValue != null) {
                return this.getCompilationUnit().translateAnnotationValue(annotationValue, isArrayType);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                this.getCompilationUnit().getProblemSupport().addError((Element)this, e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return null;
    }

    private JvmOperation findOperation(String name) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        AnnotationTypeDeclaration _annotationTypeDeclaration = this.getAnnotationTypeDeclaration();
        JvmAnnotationType jvmAnnoType = (JvmAnnotationType)((JvmAnnotationTypeDeclarationImpl)_annotationTypeDeclaration).getDelegate();
        Functions.Function1 _function = it -> {
            String _simpleName = it.getSimpleName();
            return Objects.equals(_simpleName, name);
        };
        JvmOperation jvmOperation = (JvmOperation)IterableExtensions.findFirst((Iterable)jvmAnnoType.getDeclaredOperations(), (Functions.Function1)_function);
        if (jvmOperation == null) {
            String _identifier = jvmAnnoType.getIdentifier();
            String _plus = "The annotation property '" + name + "' is not declared on the annotation type '" + _identifier;
            String _plus_1 = _plus + "'.";
            throw new IllegalArgumentException(_plus_1);
        }
        return jvmOperation;
    }

    public AnnotationReference getAnnotationValue(String name) {
        Object _value = this.getValue(name);
        return (AnnotationReference)_value;
    }

    public AnnotationReference[] getAnnotationArrayValue(String name) {
        Object _value = this.getValue(name);
        return (AnnotationReference[])_value;
    }

    public boolean[] getBooleanArrayValue(String name) {
        Object _value = this.getValue(name);
        return (boolean[])_value;
    }

    public boolean getBooleanValue(String name) {
        Boolean _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return false;
        }
        _xblockexpression = (Boolean)value;
        return _xblockexpression;
    }

    public byte[] getByteArrayValue(String name) {
        Object _value = this.getValue(name);
        return (byte[])_value;
    }

    public byte getByteValue(String name) {
        Byte _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        _xblockexpression = (Byte)value;
        return _xblockexpression;
    }

    public char[] getCharArrayValue(String name) {
        Object _value = this.getValue(name);
        return (char[])_value;
    }

    public char getCharValue(String name) {
        Character _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return '\u0000';
        }
        Character _switchResult = null;
        boolean _matched = false;
        if (value instanceof Byte) {
            _matched = true;
            _switchResult = Character.valueOf((char)((Byte)value).byteValue());
        }
        if (!_matched) {
            _switchResult = (Character)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression.charValue();
    }

    public TypeReference getClassValue(String name) {
        Object _value = this.getValue(name);
        return (TypeReference)_value;
    }

    public TypeReference[] getClassArrayValue(String name) {
        Object _value = this.getValue(name);
        return (TypeReference[])_value;
    }

    public double[] getDoubleArrayValue(String name) {
        Object _value = this.getValue(name);
        return (double[])_value;
    }

    public double getDoubleValue(String name) {
        Double _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0.0;
        }
        Double _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (double)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (double)((Short)value);
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = (double)((Integer)value);
        }
        if (!_matched && value instanceof Long) {
            _matched = true;
            _switchResult = (double)((Long)value);
        }
        if (!_matched && value instanceof Float) {
            _matched = true;
            _switchResult = ((Float)value).floatValue();
        }
        if (!_matched) {
            _switchResult = (Double)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public EnumerationValueDeclaration getEnumValue(String name) {
        Object _value = this.getValue(name);
        return (EnumerationValueDeclaration)_value;
    }

    public EnumerationValueDeclaration[] getEnumArrayValue(String name) {
        Object _value = this.getValue(name);
        return (EnumerationValueDeclaration[])_value;
    }

    public float[] getFloatArrayValue(String name) {
        Object _value = this.getValue(name);
        return (float[])_value;
    }

    public float getFloatValue(String name) {
        Float _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0.0f;
        }
        Float _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = Float.valueOf(((Character)value).charValue());
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = Float.valueOf(((Byte)value).byteValue());
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = Float.valueOf(((Short)value).shortValue());
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = Float.valueOf(((Integer)value).intValue());
        }
        if (!_matched && value instanceof Long) {
            _matched = true;
            _switchResult = Float.valueOf(((Long)value).longValue());
        }
        if (!_matched) {
            _switchResult = (Float)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression.floatValue();
    }

    public int[] getIntArrayValue(String name) {
        Object _value = this.getValue(name);
        return (int[])_value;
    }

    public int getIntValue(String name) {
        Integer _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        Integer _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (int)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (int)((Short)value);
        }
        if (!_matched) {
            _switchResult = (Integer)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public long[] getLongArrayValue(String name) {
        Object _value = this.getValue(name);
        return (long[])_value;
    }

    public long getLongValue(String name) {
        Long _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0L;
        }
        Long _switchResult = null;
        boolean _matched = false;
        if (value instanceof Character) {
            _matched = true;
            _switchResult = ((Character)value).charValue();
        }
        if (!_matched && value instanceof Byte) {
            _matched = true;
            _switchResult = (long)((Byte)value);
        }
        if (!_matched && value instanceof Short) {
            _matched = true;
            _switchResult = (long)((Short)value);
        }
        if (!_matched && value instanceof Integer) {
            _matched = true;
            _switchResult = (long)((Integer)value);
        }
        if (!_matched) {
            _switchResult = (Long)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public short[] getShortArrayValue(String name) {
        Object _value = this.getValue(name);
        return (short[])_value;
    }

    public short getShortValue(String name) {
        Short _xblockexpression = null;
        Object value = this.getValue(name);
        if (value == null) {
            return 0;
        }
        Short _switchResult = null;
        boolean _matched = false;
        if (value instanceof Byte) {
            _matched = true;
            _switchResult = (short)((Byte)value);
        }
        if (!_matched) {
            _switchResult = (Short)value;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String[] getStringArrayValue(String name) {
        Object _value = this.getValue(name);
        return (String[])_value;
    }

    public String getStringValue(String name) {
        Object _value = this.getValue(name);
        return (String)_value;
    }
}

