/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.breakpoint.actions;

import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.breakpointactions.IReverseDebugEnabler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MIReverseDebugEnabler
implements IReverseDebugEnabler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fServiceTracker;
    private final ICommandControlService.ICommandControlDMContext fContext;

    public MIReverseDebugEnabler(DsfExecutor executor, DsfServicesTracker serviceTracker, IDMContext context) {
        this.fExecutor = executor;
        this.fServiceTracker = serviceTracker;
        this.fContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
        assert (this.fContext != null);
    }

    public void enable() throws Exception {
        this.setMode(REVERSE_DEBUG_MODE.ENABLE);
    }

    public void disable() throws Exception {
        this.setMode(REVERSE_DEBUG_MODE.DISABLE);
    }

    public void toggle() throws Exception {
        this.setMode(REVERSE_DEBUG_MODE.TOGGLE);
    }

    private void setMode(final REVERSE_DEBUG_MODE mode) throws Exception {
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                final IReverseRunControl runControl = (IReverseRunControl)MIReverseDebugEnabler.this.fServiceTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.isReverseModeEnabled(MIReverseDebugEnabler.this.fContext, new DataRequestMonitor<Boolean>((Executor)MIReverseDebugEnabler.this.fExecutor, null){

                        public void handleSuccess() {
                            Boolean enabled = (Boolean)this.getData();
                            if (enabled.equals(false) && mode.equals((Object)REVERSE_DEBUG_MODE.ENABLE) || enabled.equals(true) && mode.equals((Object)REVERSE_DEBUG_MODE.DISABLE) || mode.equals((Object)REVERSE_DEBUG_MODE.TOGGLE)) {
                                runControl.enableReverseMode((this).MIReverseDebugEnabler.this.fContext, enabled == false, new RequestMonitor((Executor)(this).MIReverseDebugEnabler.this.fExecutor, null));
                            }
                        }
                    });
                }
            }
        });
    }

    private static enum REVERSE_DEBUG_MODE {
        ENABLE,
        DISABLE,
        TOGGLE;

    }
}

