/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.ui.DotUiMessages;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class DotActivatorEx
extends DotActivator {
    public static Preferences dotUiPreferences() {
        return ConfigurationScope.INSTANCE.getNode(DotActivatorEx.getInstance().getBundle().getSymbolicName());
    }

    public static IPreferenceStore dotUiPreferenceStore() {
        return new ScopedPreferenceStore(ConfigurationScope.INSTANCE, DotActivatorEx.getInstance().getBundle().getSymbolicName());
    }

    public static void logError(Exception exception) {
        String message = DotUiMessages.DotErrorPrefix;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage != null) {
            message = String.valueOf(message) + " - " + exceptionMessage;
        }
        String pluginID = DotActivatorEx.getInstance().getBundle().getSymbolicName();
        Status status = new Status(4, pluginID, message, (Throwable)exception);
        DotActivatorEx.getInstance().getLog().log((IStatus)status);
        exception.printStackTrace();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        for (String colorScheme : DotColors.getColorSchemes()) {
            for (String colorName : DotColors.getColorNames((String)colorScheme)) {
                String hex = DotColors.get((String)colorScheme, (String)colorName);
                if (reg.get(hex) != null) continue;
                Image image = this.createImage(hex);
                reg.put(hex, image);
            }
        }
    }

    private Image createImage(String colorCode) {
        Display display = Display.getDefault();
        Image image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        Color color = new DotColorUtil().hex2Rgb(colorCode);
        gc.setBackground(color);
        gc.fillRectangle(1, 1, 14, 14);
        gc.setForeground(display.getSystemColor(2));
        gc.drawLine(0, 0, 15, 0);
        gc.drawLine(15, 0, 15, 15);
        gc.drawLine(15, 15, 0, 15);
        gc.drawLine(0, 15, 0, 0);
        gc.dispose();
        return image;
    }
}

