/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

class WindowFreeformHelper
implements FreeformListener {
    FreeformLayeredPane x;
    private FreeformFigure host;
    private Rectangle freeformExtent;
    private FigureListener figureListener = new ChildTracker();

    public WindowFreeformHelper(FreeformFigure host) {
        this.host = host;
    }

    public Rectangle getFreeformExtent() {
        if (this.freeformExtent != null) {
            return this.freeformExtent;
        }
        List children = this.host.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle r = child instanceof FreeformFigure ? ((FreeformFigure)child).getFreeformExtent() : child.getBounds();
            if (this.freeformExtent == null) {
                this.freeformExtent = r.getCopy();
            } else {
                this.freeformExtent.union(r);
            }
            ++i;
        }
        Insets insets = this.host.getInsets();
        if (this.freeformExtent == null) {
            this.freeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            this.host.translateToParent((Translatable)this.freeformExtent);
            this.freeformExtent.expand(insets);
        }
        return this.freeformExtent;
    }

    public void hookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).addFreeformListener((FreeformListener)this);
        } else {
            child.addFigureListener(this.figureListener);
        }
    }

    void invalidate() {
        this.freeformExtent = null;
        this.host.fireExtentChanged();
        if (this.host.getParent() != null) {
            this.host.getParent().revalidate();
        } else {
            this.host.revalidate();
        }
    }

    public void notifyFreeformExtentChanged() {
        this.invalidate();
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.host.setBounds(bounds);
        bounds = bounds.getCopy();
        this.host.translateFromParent((Translatable)bounds);
        List children = this.host.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child instanceof FreeformFigure) {
                ((FreeformFigure)child).setFreeformBounds(bounds);
            }
            ++i;
        }
        this.host.getLayoutManager().layout((IFigure)this.host);
    }

    public void unhookChild(IFigure child) {
        this.invalidate();
        if (child instanceof FreeformFigure) {
            ((FreeformFigure)child).removeFreeformListener((FreeformListener)this);
        } else {
            child.removeFigureListener(this.figureListener);
        }
    }

    class ChildTracker
    implements FigureListener {
        ChildTracker() {
        }

        public void figureMoved(IFigure source) {
            WindowFreeformHelper.this.invalidate();
        }
    }
}

