/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.xtext.base.serializer.DeclarativeSerializer;
import org.eclipse.ocl.xtext.base.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.xtext.base.serializer.DynamicRuleMatch;
import org.eclipse.ocl.xtext.base.serializer.EnumerationValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarCardinality;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleValue;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleVector;
import org.eclipse.ocl.xtext.base.serializer.ParserRuleValue;
import org.eclipse.ocl.xtext.base.serializer.SerializationBuilder;
import org.eclipse.ocl.xtext.base.serializer.SerializationMatchStep;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationRuleHelper;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.ocl.xtext.base.serializer.SerializationStep;
import org.eclipse.ocl.xtext.base.serializer.SerializationUtils;
import org.eclipse.ocl.xtext.base.serializer.UserElementAnalysis;
import org.eclipse.ocl.xtext.base.serializer.UserElementSerializer;
import org.eclipse.ocl.xtext.base.serializer.UserModelAnalysis;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class SerializationRule
implements Nameable {
    private static final @NonNull SerializationMatchStep @NonNull [] RUNTIME_STEP = new SerializationMatchStep[]{new SerializationMatchStep.MatchStep_Runtime()};
    private final @Nullable SerializationMetaData serializationMetaData;
    protected final @NonNull String name;
    protected final int grammarRuleValueIndex;
    private final @NonNull SerializationMatchStep @NonNull [] matchSteps;
    private final @NonNull SerializationStep @NonNull [] serializationSteps;
    private final @NonNull SerializationFeature @Nullable [] serializationFeatures;
    private @Nullable SerializationRuleHelper helper;

    public SerializationRule(@NonNull SerializationMetaData serializationMetaData, @NonNull String name, int grammarRuleValueIndex, @NonNull SerializationMatchStep @Nullable [] matchSteps, @NonNull SerializationStep @NonNull [] serializationSteps, @NonNull SerializationFeature @Nullable [] serializationFeatures) {
        this.serializationMetaData = serializationMetaData;
        this.name = name;
        this.grammarRuleValueIndex = grammarRuleValueIndex;
        this.matchSteps = matchSteps != null ? matchSteps : RUNTIME_STEP;
        this.serializationSteps = serializationSteps;
        this.serializationFeatures = serializationFeatures;
        this.helper = null;
    }

    public SerializationRule(@NonNull SerializationRuleHelper helper, @NonNull String name, int grammarRuleValueIndex, @NonNull SerializationMatchStep @Nullable [] matchSteps, @NonNull SerializationStep @NonNull [] serializationSteps, @NonNull SerializationFeature @Nullable [] serializationFeatures) {
        this.serializationMetaData = null;
        this.name = name;
        this.grammarRuleValueIndex = grammarRuleValueIndex;
        this.matchSteps = matchSteps != null ? matchSteps : RUNTIME_STEP;
        this.serializationSteps = serializationSteps;
        this.serializationFeatures = serializationFeatures;
        this.helper = helper;
    }

    public @NonNull EnumerationValue @Nullable [] basicGetEnumerationValues(@NonNull EAttribute eAttribute) {
        SerializationAttribute serializationAttribute = this.basicGetSerializationAttribute(eAttribute);
        return serializationAttribute != null ? serializationAttribute.getEnumerationValues() : null;
    }

    public @Nullable GrammarCardinality basicGetGrammarCardinality(@NonNull EStructuralFeature eStructuralFeature) {
        SerializationAttribute serializationAttribute;
        if (eStructuralFeature instanceof EAttribute && (serializationAttribute = this.basicGetSerializationAttribute((EAttribute)eStructuralFeature)) != null) {
            GrammarCardinality grammarCardinality = serializationAttribute.basicGetGrammarCardinality(null);
            return grammarCardinality;
        }
        return null;
    }

    public @Nullable GrammarCardinality basicGetGrammarCardinality(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        SerializationAttribute serializationAttribute = this.basicGetSerializationAttribute(eAttribute);
        return serializationAttribute != null ? serializationAttribute.basicGetGrammarCardinality(enumerationValue) : null;
    }

    public @Nullable GrammarCardinality basicGetGrammarCardinality(@NonNull EReference eReference, @NonNull ParserRuleValue ruleValue) {
        SerializationReference serializationReference = this.basicGetSerializationReference(eReference);
        return serializationReference != null ? serializationReference.basicGetGrammarCardinality(ruleValue.getIndex()) : null;
    }

    public @Nullable SerializationAttribute basicGetSerializationAttribute(@NonNull EAttribute eAttribute) {
        if (this.serializationFeatures != null) {
            SerializationFeature[] serializationFeatureArray = this.serializationFeatures;
            int n = this.serializationFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull SerializationFeature serializationFeature = serializationFeatureArray[n2];
                if (serializationFeature.getEStructuralFeature() == eAttribute) {
                    return (SerializationAttribute)serializationFeature;
                }
                ++n2;
            }
        }
        return null;
    }

    public @NonNull SerializationFeature @Nullable [] basicGetSerializationFeatures() {
        return this.serializationFeatures;
    }

    public @Nullable SerializationReference basicGetSerializationReference(@NonNull EReference eReference) {
        if (this.serializationFeatures != null) {
            SerializationFeature[] serializationFeatureArray = this.serializationFeatures;
            int n = this.serializationFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull SerializationFeature serializationFeature = serializationFeatureArray[n2];
                if (serializationFeature.getEStructuralFeature() == eReference) {
                    return (SerializationReference)serializationFeature;
                }
                ++n2;
            }
        }
        return null;
    }

    public @Nullable GrammarRuleVector basicGetTargetGrammarRuleVector(@NonNull EReference eReference) {
        SerializationReference serializationReference = this.basicGetSerializationReference(eReference);
        return serializationReference != null ? serializationReference.getTargetGrammarRuleVector() : null;
    }

    public void formatRule(@NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        this.formatSubRule(0, this.serializationSteps.length, serializer, serializationBuilder);
    }

    public void formatSubRule(int startIndex, int endIndex, @NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        UserModelAnalysis modelAnalysis = serializer.getModelAnalysis();
        SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
        HashMap<@NonNull String, @NonNull List<@NonNull E>> keyword2leafNodes = new HashMap();
        HashMap<@NonNull EReference, @NonNull List<@NonNull E>> eReference2leafNodes = new HashMap();
        HashMap<@NonNull AbstractRule, @NonNull List<@NonNull E>> calledRule2leafNodes = new HashMap();
        HashMap<@NonNull SerializationRule, @NonNull ArrayList<@NonNull ICompositeNode>> serializationRule2compositeNodes = new HashMap<SerializationRule, ArrayList<ICompositeNode>>();
        ICompositeNode parentNode = NodeModelUtils.getNode((EObject)serializer.getElement());
        assert (parentNode != null);
        for (INode childNode : SerializationUtils.getChildren(parentNode)) {
            AbstractRule calledRule;
            EObject grammarElement;
            if (childNode instanceof ILeafNode) {
                List<ILeafNode> leafNodes;
                ILeafNode leafNode = (ILeafNode)childNode;
                if (leafNode.isHidden()) continue;
                grammarElement = leafNode.getGrammarElement();
                if (grammarElement instanceof Keyword) {
                    String value = ((Keyword)grammarElement).getValue();
                    if (value == null) continue;
                    leafNodes = (ArrayList<ILeafNode>)keyword2leafNodes.get(value);
                    if (leafNodes == null) {
                        leafNodes = new ArrayList<ILeafNode>();
                        keyword2leafNodes.put(value, leafNodes);
                    }
                    leafNodes.add(leafNode);
                    continue;
                }
                if (grammarElement instanceof CrossReference) {
                    EReference eReference = GrammarUtil.getReference((CrossReference)((CrossReference)grammarElement));
                    if (eReference == null) continue;
                    leafNodes = (List)eReference2leafNodes.get(eReference);
                    if (leafNodes == null) {
                        leafNodes = new ArrayList();
                        eReference2leafNodes.put(eReference, leafNodes);
                    }
                    leafNodes.add(leafNode);
                    continue;
                }
                if (grammarElement instanceof RuleCall) {
                    calledRule = ((RuleCall)grammarElement).getRule();
                    if (calledRule == null) continue;
                    leafNodes = (List)calledRule2leafNodes.get(calledRule);
                    if (leafNodes == null) {
                        leafNodes = new ArrayList();
                        calledRule2leafNodes.put(calledRule, leafNodes);
                    }
                    leafNodes.add(leafNode);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            if (childNode instanceof ICompositeNode) {
                ICompositeNode compositeNode = (ICompositeNode)childNode;
                grammarElement = compositeNode.getGrammarElement();
                if (grammarElement instanceof RuleCall) {
                    calledRule = ((RuleCall)grammarElement).getRule();
                    if (calledRule == null) continue;
                    GrammarRuleValue calledRuleValue = serializationMetaData.basicGetGrammarRuleValue(SerializationUtils.getName(calledRule));
                    assert (calledRuleValue != null);
                    EObject childElement = compositeNode.getSemanticElement();
                    assert (childElement != null);
                    UserElementAnalysis childElementAnalysis = modelAnalysis.getElementAnalysis(childElement);
                    DynamicRuleMatch dynamicRuleMatch = childElementAnalysis.basicCreateDynamicRuleMatch(calledRuleValue.getIndex());
                    if (dynamicRuleMatch == null) continue;
                    SerializationRule childSerializationRule = dynamicRuleMatch.getSerializationRule();
                    ArrayList<@NonNull ICompositeNode> compositeNodes = (ArrayList<ICompositeNode>)serializationRule2compositeNodes.get(childSerializationRule);
                    if (compositeNodes == null) {
                        compositeNodes = new ArrayList<ICompositeNode>();
                        serializationRule2compositeNodes.put(childSerializationRule, compositeNodes);
                    }
                    compositeNodes.add(compositeNode);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        int index = startIndex;
        while (index < endIndex) {
            SerializationStep serializationStep = this.serializationSteps[index++];
            @NonNull SerializationSegment @Nullable [] segments = serializationStep.getSerializationSegments();
            if (serializationStep instanceof SerializationStep.SerializationStepSequence) {
                int stepsRange = ((SerializationStep.SerializationStepSequence)serializationStep).getStepsRange();
                if (segments != null) {
                    SerializationSegment[] serializationSegmentArray = segments;
                    int childElement = segments.length;
                    int calledRuleValue = 0;
                    while (calledRuleValue < childElement) {
                        SerializationSegment segment = serializationSegmentArray[calledRuleValue];
                        segment.serialize(index - 1, serializer, serializationBuilder);
                        ++calledRuleValue;
                    }
                } else {
                    int cardinalityVariableIndex = ((SerializationStep.SerializationStepSequence)serializationStep).getVariableIndex();
                    int stepLoopCount = cardinalityVariableIndex >= 0 ? serializer.getValue(cardinalityVariableIndex) : 1;
                    int i = 0;
                    while (i < stepLoopCount) {
                        this.formatSubRule(index - 1, index + stepsRange, serializer, serializationBuilder);
                        ++i;
                    }
                }
                index += stepsRange;
                continue;
            }
            if (segments != null) {
                SerializationSegment[] serializationSegmentArray = segments;
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializationSegment segment = serializationSegmentArray[n2];
                    segment.serialize(index - 1, serializer, serializationBuilder);
                    ++n2;
                }
                continue;
            }
            serializationStep.serializeInnerValue(index - 1, serializer, serializationBuilder);
        }
    }

    public @NonNull DiagnosticStringBuilder getDiagnosticStringBuilder() {
        if (this.serializationMetaData != null) {
            return new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(this.serializationMetaData);
        }
        return new DiagnosticStringBuilder.DiagnosticStringBuilderWithHelper(this.helper);
    }

    public int getGrammarRuleValueIndex() {
        return this.grammarRuleValueIndex;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull SerializationAttribute getSerializationAttribute(@NonNull EAttribute eAttribute) {
        return (SerializationAttribute)ClassUtil.nonNullState((Object)this.basicGetSerializationAttribute(eAttribute));
    }

    public @Nullable SerializationFeature getSerializationFeature(@NonNull EStructuralFeature eStructuralFeature) {
        @NonNull SerializationFeature @Nullable [] serializationFeatures2 = this.serializationFeatures;
        if (serializationFeatures2 == null) {
            return null;
        }
        SerializationFeature[] serializationFeatureArray = serializationFeatures2;
        int n = serializationFeatures2.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationFeature serializationFeature = serializationFeatureArray[n2];
            if (serializationFeature.getEStructuralFeature() == eStructuralFeature) {
                return serializationFeature;
            }
            ++n2;
        }
        return null;
    }

    public @NonNull SerializationFeature @Nullable [] getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public @NonNull SerializationMatchStep @NonNull [] getSerializationMatchSteps() {
        return this.matchSteps;
    }

    public @NonNull SerializationReference getSerializationReference(@NonNull EReference eReference) {
        return (SerializationReference)ClassUtil.nonNullState((Object)this.basicGetSerializationReference(eReference));
    }

    public @NonNull SerializationStep @NonNull [] getSerializationSteps() {
        return this.serializationSteps;
    }

    public boolean needsDefault(@NonNull EAttribute eAttribute) {
        SerializationAttribute serializationAttribute = this.basicGetSerializationAttribute(eAttribute);
        return serializationAttribute != null ? serializationAttribute.needsDefault() : false;
    }

    public void serialize(@NonNull UserElementSerializer serializer, @NonNull SerializationBuilder serializationBuilder) {
        UserModelAnalysis modelAnalysis = serializer.getModelAnalysis();
        boolean isTracing = DeclarativeSerializer.SERIALIZER_FRAGMENTS.isActive();
        modelAnalysis.pushDepth();
        int index = 0;
        while (index < this.serializationSteps.length) {
            SerializationStep serializationStep = this.serializationSteps[index];
            if (isTracing) {
                DeclarativeSerializer.SERIALIZER_FRAGMENTS.println(String.valueOf(modelAnalysis.getIndent()) + "step: " + serializationStep);
            }
            index = serializationStep.serializeOuterValue(index, serializer, serializationBuilder);
        }
        modelAnalysis.popDepth();
    }

    public void toMatchTermString(@NonNull DiagnosticStringBuilder s, int depth) {
        this.toRuleString(s);
        if (this.matchSteps.length > 0) {
            SerializationMatchStep[] serializationMatchStepArray = this.matchSteps;
            int n = this.matchSteps.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull SerializationMatchStep matchStep = serializationMatchStepArray[n2];
                s.appendIndentation(depth);
                matchStep.toString(s);
                s.append(";");
                ++n2;
            }
        }
    }

    public @NonNull String toRuleString() {
        DiagnosticStringBuilder s = this.getDiagnosticStringBuilder();
        this.toRuleString(s);
        return s.toString();
    }

    public void toRuleString(@NonNull DiagnosticStringBuilder s) {
        this.toRuleString(s, 0, this.serializationSteps.length);
    }

    protected void toRuleString(@NonNull DiagnosticStringBuilder s, int start, int end) {
        int i = start;
        while (i < end) {
            SerializationStep serializationStep;
            if ((serializationStep = this.serializationSteps[i++]) instanceof SerializationStep.SerializationStepSequence) {
                SerializationStep.SerializationStepSequence serializationStepSequence = (SerializationStep.SerializationStepSequence)serializationStep;
                s.append("(");
                this.toRuleString(s, i, i + serializationStepSequence.getStepsRange());
                s.append(")[");
                int variableIndex = serializationStepSequence.getVariableIndex();
                if (variableIndex >= 0) {
                    s.appendVariableName(variableIndex);
                    s.append(":");
                }
                s.appendObject((Object)serializationStepSequence.getGrammarCardinality());
                s.append("]");
                i += serializationStepSequence.getStepsRange();
            } else if (!(serializationStep instanceof SerializationStep.SerializationStepWrapper)) {
                serializationStep.toStepString(s);
            }
            if (i >= end || serializationStep instanceof SerializationStep.SerializationStepWrapper) continue;
            s.append(" ");
        }
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder s = this.getDiagnosticStringBuilder();
        s.append(this.getName());
        s.append(": ");
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        this.toRuleString(s, 0, this.serializationSteps.length);
    }

    public static abstract class SerializationAttribute
    extends SerializationFeature {
        protected final boolean needsDefault;

        public SerializationAttribute(@NonNull EAttribute eAttribute, boolean needsDefault) {
            super((EStructuralFeature)eAttribute);
            this.needsDefault = needsDefault;
        }

        public @Nullable SerializationEnumeratedAttribute asEnumerated() {
            return null;
        }

        public abstract @Nullable GrammarCardinality basicGetGrammarCardinality(@Nullable EnumerationValue var1);

        public abstract @NonNull EnumerationValue @NonNull [] getEnumerationValues();

        public boolean needsDefault() {
            return this.needsDefault;
        }
    }

    public static class SerializationEnumeratedAttribute
    extends SerializationAttribute {
        protected final @NonNull EnumerationValue @NonNull [] enumerationValues;
        protected final @NonNull GrammarCardinality @NonNull [] grammarCardinalities;

        public SerializationEnumeratedAttribute(@NonNull EAttribute eAttribute, boolean needsDefault, @NonNull EnumerationValue @NonNull [] enumerationValues, @NonNull GrammarCardinality @NonNull [] grammarCardinalities) {
            super(eAttribute, needsDefault);
            this.enumerationValues = enumerationValues;
            this.grammarCardinalities = grammarCardinalities;
            EnumerationValue[] enumerationValueArray = enumerationValues;
            int n = enumerationValues.length;
            int n2 = 0;
            while (n2 < n) {
                EnumerationValue enumerationValue = enumerationValueArray[n2];
                assert (!enumerationValue.isNull());
                ++n2;
            }
        }

        @Override
        public @Nullable SerializationEnumeratedAttribute asEnumerated() {
            return this;
        }

        @Override
        public @NonNull EnumerationValue @NonNull [] getEnumerationValues() {
            return this.enumerationValues;
        }

        @Override
        public @Nullable GrammarCardinality basicGetGrammarCardinality(@Nullable EnumerationValue enumerationValue) {
            if (enumerationValue == null) {
                return this.eStructuralFeature.isRequired() ? GrammarCardinality.ONE : GrammarCardinality.ZERO_OR_ONE;
            }
            int i = 0;
            while (i < this.enumerationValues.length) {
                if (this.enumerationValues[i] == enumerationValue) {
                    return this.grammarCardinalities[i];
                }
                ++i;
            }
            return null;
        }

        public @NonNull GrammarCardinality getGrammarCardinality(@Nullable EnumerationValue enumerationValue) {
            return (GrammarCardinality)((Object)ClassUtil.nonNullState((Object)((Object)this.basicGetGrammarCardinality(enumerationValue))));
        }

        @Override
        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.eStructuralFeature.getEContainingClass().getName());
            s.append("::");
            s.append(this.eStructuralFeature.getName());
            s.append(" ");
            int i = 0;
            while (i < this.enumerationValues.length) {
                if (i > 0) {
                    s.append(",");
                    s.append(this.enumerationValues[i]);
                    s.append((Object)this.grammarCardinalities[i]);
                }
                ++i;
            }
            return s.toString();
        }
    }

    public static abstract class SerializationFeature
    implements Nameable {
        protected final @NonNull EStructuralFeature eStructuralFeature;

        protected SerializationFeature(@NonNull EStructuralFeature eStructuralFeature) {
            this.eStructuralFeature = eStructuralFeature;
        }

        public @NonNull EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public @NonNull String getName() {
            return SerializationUtils.getName((ENamedElement)this.eStructuralFeature);
        }

        public @NonNull String toString() {
            return String.valueOf(this.eStructuralFeature.getEContainingClass().getName()) + "::" + this.eStructuralFeature.getName();
        }
    }

    public static class SerializationReference
    extends SerializationFeature {
        protected final @Nullable GrammarRuleVector targetGrammarRuleVector;
        protected final int @NonNull [] grammarRuleIndexes;
        protected final @NonNull GrammarCardinality @NonNull [] grammarCardinalities;

        public SerializationReference(@NonNull EReference eReference, @Nullable GrammarRuleVector targetGrammarRuleVector, int @NonNull [] grammarRuleIndexes, @NonNull GrammarCardinality @NonNull [] grammarCardinalities) {
            super((EStructuralFeature)eReference);
            this.targetGrammarRuleVector = targetGrammarRuleVector;
            this.grammarRuleIndexes = grammarRuleIndexes;
            this.grammarCardinalities = grammarCardinalities;
        }

        public @Nullable GrammarCardinality basicGetGrammarCardinality(int grammarRuleIndex) {
            int i = 0;
            while (i < this.grammarRuleIndexes.length) {
                if (this.grammarRuleIndexes[i] == grammarRuleIndex) {
                    return this.grammarCardinalities[i];
                }
                ++i;
            }
            return null;
        }

        public @NonNull GrammarCardinality getGrammarCardinality(int grammarRuleIndex) {
            return (GrammarCardinality)((Object)ClassUtil.nonNullState((Object)((Object)this.basicGetGrammarCardinality(grammarRuleIndex))));
        }

        public int @NonNull [] getGrammarRuleIndexes() {
            return this.grammarRuleIndexes;
        }

        public @Nullable GrammarRuleVector getTargetGrammarRuleVector() {
            return this.targetGrammarRuleVector;
        }

        @Override
        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.eStructuralFeature.getEContainingClass().getName());
            s.append("::");
            s.append(this.eStructuralFeature.getName());
            s.append(":{");
            int i = 0;
            while (i < this.grammarRuleIndexes.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append(this.grammarRuleIndexes[i]);
                s.append((Object)this.grammarCardinalities[i]);
                ++i;
            }
            s.append("}");
            return s.toString();
        }
    }

    public static class SerializationSimpleAttribute
    extends SerializationAttribute {
        protected final @NonNull GrammarCardinality grammarCardinality;

        public SerializationSimpleAttribute(@NonNull EAttribute eAttribute, boolean needsDefault, @NonNull GrammarCardinality grammarCardinality) {
            super(eAttribute, needsDefault);
            this.grammarCardinality = grammarCardinality;
        }

        @Override
        public @NonNull EnumerationValue @NonNull [] getEnumerationValues() {
            return EnumerationValue.NO_ENUMERATION_VALUES;
        }

        public @NonNull GrammarCardinality getGrammarCardinality() {
            return this.grammarCardinality;
        }

        @Override
        public @Nullable GrammarCardinality basicGetGrammarCardinality(@Nullable EnumerationValue enumerationValue) {
            return enumerationValue == null ? this.grammarCardinality : null;
        }

        @Override
        public @NonNull String toString() {
            return String.valueOf(super.toString()) + " " + (Object)((Object)this.grammarCardinality);
        }
    }
}

