/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.requirements.Feature;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.base.requirements.BaseFeature;
import org.eclipse.passage.lic.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.base.restrictions.DefaultRestrictionLevel;
import org.eclipse.passage.lic.base.version.DefaultVersion;
import org.eclipse.passage.lic.base.version.SafeVersion;
import org.eclipse.passage.lic.equinox.requirements.BundleResidentAgreement;
import org.eclipse.passage.lic.equinox.requirements.BundleVendor;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureAgreements;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureId;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureLevel;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureName;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureProvider;
import org.eclipse.passage.lic.equinox.requirements.ComponentLicFeatureVersion;
import org.eclipse.passage.lic.equinox.requirements.ListOfAgreements;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

final class RequirementFromComponent
implements Supplier<Optional<Requirement>> {
    private final ComponentDescriptionDTO component;
    private final BundleContext context;

    public RequirementFromComponent(ComponentDescriptionDTO component, BundleContext context) {
        this.component = component;
        this.context = context;
    }

    @Override
    public Optional<Requirement> get() {
        Optional<Map> properties = Optional.ofNullable(this.component.properties);
        if (!properties.isPresent()) {
            return Optional.empty();
        }
        Optional feature = new ComponentLicFeatureId(properties.get()).get();
        if (!feature.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.requirementFromProperties((FeatureIdentifier)feature.get(), properties.get()));
    }

    private Requirement requirementFromProperties(FeatureIdentifier feature, Map<String, Object> properties) {
        String version = new ComponentLicFeatureVersion(properties).get().map(raw -> new SafeVersion(raw).value()).orElse(new DefaultVersion().value());
        String name = new ComponentLicFeatureName(properties).get().orElse(feature.identifier());
        Bundle bundle = this.context.getBundle(this.component.bundle.id);
        String provider = new ComponentLicFeatureProvider(properties).get().orElseGet(new BundleVendor(bundle));
        RestrictionLevel level = new ComponentLicFeatureLevel(properties).get().map(RestrictionLevel.Of::new).orElseGet((Supplier<RestrictionLevel>)new DefaultRestrictionLevel());
        Object agreements = new BundleResidentAgreement.Pack(bundle, new ListOfAgreements().fromSource(new ComponentLicFeatureAgreements(properties))).get();
        return new BaseRequirement((Feature)new BaseFeature(feature, version, name, provider), level, (List)agreements, (Object)this.component.name);
    }
}

