/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionContentPage;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionPage;

public class EditTargetDefinitionWizard
extends Wizard {
    private ITargetDefinition fDefinition;

    public EditTargetDefinitionWizard(ITargetDefinition definition, boolean createWorkingCopy) {
        this.setTargetDefinition(definition, createWorkingCopy);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        List targets = (List)TargetPlatformHelper.getTargetDefinitionMap().get(this.fDefinition.getHandle());
        if (targets != null) {
            targets.removeIf(Predicate.not(this.fDefinition::equals));
        }
        return true;
    }

    public boolean performCancel() {
        List targets = (List)TargetPlatformHelper.getTargetDefinitionMap().get(this.fDefinition.getHandle());
        if (targets != null) {
            targets.removeIf(this.fDefinition::equals);
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new TargetDefinitionContentPage(this.fDefinition));
    }

    public void setTargetDefinition(ITargetDefinition definition, boolean createWorkingCopy) {
        IWizardPage[] pages;
        ITargetDefinition workingCopy = null;
        if (createWorkingCopy) {
            try {
                ITargetPlatformService service = TargetDefinitionPage.getTargetService();
                if (service != null) {
                    workingCopy = definition.getHandle().exists() ? definition.getHandle().getTargetDefinition() : service.newTarget();
                    service.copyTargetDefinition(definition, workingCopy);
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        } else {
            workingCopy = definition;
        }
        this.fDefinition = workingCopy;
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            ((TargetDefinitionPage)page).targetChanged(workingCopy);
            ++n2;
        }
    }

    public ITargetDefinition getTargetDefinition() {
        return this.fDefinition;
    }
}

