/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.classid;

import java.util.Map;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;
import org.eclipse.text.edits.TextEdit;

public class ClassIdQuickAssistProcessor
implements IQuickAssistProcessor {
    public boolean hasAssists(IInvocationContext context) {
        IJavaCompletionProposal[] assists = this.getAssists(context, null);
        return assists != null && assists.length > 0;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) {
        ClassIdTarget selectedType = ClassIdQuickAssistProcessor.getTarget(context.getCoveringNode());
        if (selectedType != null && !JdtUtils.exists((IJavaElement)selectedType.m_annotation)) {
            CompilationUnitRewrite rewrite = ClassIdQuickAssistProcessor.createRewrite(selectedType);
            return new IJavaCompletionProposal[]{new ClassIdAddProposal(rewrite)};
        }
        return null;
    }

    private static CompilationUnitRewrite createRewrite(ClassIdTarget target) {
        IType type = target.m_type;
        TypeDeclaration td = target.m_td;
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, type.getCompilationUnit(), (CompilationUnit)td.getRoot());
        ListRewrite listRewrite = cuRewrite.getASTRewrite().getListRewrite((ASTNode)td, td.getModifiersProperty());
        SingleMemberAnnotation classIdAnnotation = (SingleMemberAnnotation)EclipseEnvironment.callInEclipseEnvironmentSync((e, p) -> new AstNodeFactory(td, type.getCompilationUnit(), (EclipseEnvironment)e, target.m_scoutApi).newClassIdAnnotation(type.getFullyQualifiedName()), (IProgressMonitor)new NullProgressMonitor());
        cuRewrite.getImportRewrite().addImport(classIdAnnotation.getTypeName().getFullyQualifiedName());
        ASTNode sibling = AstUtils.getAnnotationSibling((BodyDeclaration)td, (Annotation)classIdAnnotation);
        if (sibling == null) {
            listRewrite.insertLast((ASTNode)classIdAnnotation, null);
        } else {
            listRewrite.insertBefore((ASTNode)classIdAnnotation, sibling, null);
        }
        return cuRewrite;
    }

    private static ClassIdTarget getTarget(ASTNode selectedNode) {
        boolean isValidNodeType;
        if (selectedNode != null && selectedNode.getParent() != null && (isValidNodeType = IntStream.of(42, 40, 83, 55).anyMatch(nodeType -> nodeType == selectedNode.getNodeType()))) {
            IJavaElement javaElement;
            TypeDeclaration typeDecl;
            if (selectedNode.getParent().getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode.getParent();
            } else if (selectedNode.getNodeType() == 55) {
                typeDecl = (TypeDeclaration)selectedNode;
            } else {
                return null;
            }
            ITypeBinding resolveTypeBinding = typeDecl.resolveBinding();
            if (resolveTypeBinding != null && JdtUtils.exists((IJavaElement)(javaElement = resolveTypeBinding.getJavaElement())) && javaElement.getElementType() == 7) {
                IType t = (IType)javaElement;
                try {
                    if (!t.isBinary() && !t.isAnonymous()) {
                        ITypeHierarchy superTypeHierarchy = t.newSupertypeHierarchy(null);
                        IScoutApi scoutApi = ApiHelper.requireScoutApiFor((IJavaElement)t);
                        String classIdFqn = scoutApi.ClassId().fqn();
                        if (JdtUtils.hierarchyContains((ITypeHierarchy)superTypeHierarchy, (String)scoutApi.ITypeWithClassId().fqn())) {
                            IAnnotation annotation = JdtUtils.getAnnotation((IAnnotatable)t, (String)classIdFqn);
                            return new ClassIdTarget(typeDecl, t, annotation, scoutApi);
                        }
                    }
                }
                catch (JavaModelException e) {
                    SdkLog.error((CharSequence)"Unable to check if type '{}' is anonymous.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
                }
            }
        }
        return null;
    }

    private static final class ClassIdTarget {
        private final TypeDeclaration m_td;
        private final IType m_type;
        private final IAnnotation m_annotation;
        private final IScoutApi m_scoutApi;

        private ClassIdTarget(TypeDeclaration td, IType type, IAnnotation annotation, IScoutApi api) {
            this.m_td = td;
            this.m_type = type;
            this.m_annotation = annotation;
            this.m_scoutApi = api;
        }
    }

    private static final class ClassIdAddProposal
    extends CUCorrectionProposal {
        private final CompilationUnitRewrite m_rewrite;

        private ClassIdAddProposal(CompilationUnitRewrite cur) {
            super("Add @ClassId annotation", cur.getCu(), 1000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
            this.m_rewrite = cur;
        }

        protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
            Map options = this.m_rewrite.getCu().getJavaProject().getOptions(true);
            editRoot.addChild(this.m_rewrite.getASTRewrite().rewriteAST(document, options));
            if (this.m_rewrite.getImportRewrite().hasRecordedChanges()) {
                editRoot.addChild(this.m_rewrite.getImportRewrite().rewriteImports(null));
            }
        }
    }
}

