/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;

public final class RangeHelper {
    private RangeHelper() {
    }

    public static Function<Range, Integer> lowerBoundFunction() {
        return LowerBoundFunction.INSTANCE;
    }

    public static Function<Range, Integer> upperBoundFunction() {
        return UpperBoundFunction.INSTANCE;
    }

    public static Function<Range, Integer> widthFunction() {
        return WidthFunction.INSTANCE;
    }

    public static Ordering<Range> lowerBoundOrdering() {
        return Ordering.natural().onResultOf(RangeHelper.lowerBoundFunction());
    }

    public static Ordering<Range> upperBoundOrdering() {
        return Ordering.natural().onResultOf(RangeHelper.upperBoundFunction());
    }

    public static Range verticalRange(Rectangle rect) {
        return new Range(rect.y, rect.y + rect.height);
    }

    public static Range horizontalRange(Rectangle rect) {
        return new Range(rect.x, rect.x + rect.width);
    }

    private static enum LowerBoundFunction implements Function<Range, Integer>
    {
        INSTANCE;


        public Integer apply(Range from) {
            return from.getLowerBound();
        }

        public String toString() {
            return "lowerBound";
        }
    }

    private static enum UpperBoundFunction implements Function<Range, Integer>
    {
        INSTANCE;


        public Integer apply(Range from) {
            return from.getUpperBound();
        }

        public String toString() {
            return "upperBound";
        }
    }

    private static enum WidthFunction implements Function<Range, Integer>
    {
        INSTANCE;


        public Integer apply(Range from) {
            return from.width();
        }

        public String toString() {
            return "width";
        }
    }
}

