/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.internal.genericeditor.GenericEditorWithContentTypeIcon;

public class GenericEditorWithIconAssociationOverride
implements IEditorAssociationOverride {
    private final Map<String, IEditorDescriptor> descriptorMap = new HashMap<String, IEditorDescriptor>();

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorInput != null ? this.overrideEditors(editorInput.getName(), contentType, editorDescriptors) : editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return (IEditorDescriptor[])Arrays.stream(editorDescriptors).map(descriptor -> this.getEditorDescriptorForFile((IEditorDescriptor)descriptor, fileName)).toArray(IEditorDescriptor[]::new);
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorInput != null ? this.overrideDefaultEditor(editorInput.getName(), contentType, editorDescriptor) : editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return this.getEditorDescriptorForFile(editorDescriptor, fileName);
    }

    private IEditorDescriptor getEditorDescriptorForFile(IEditorDescriptor defaultDescriptor, String fileName) {
        if (defaultDescriptor != null && "org.eclipse.ui.genericeditor.GenericEditor".equals(defaultDescriptor.getId()) && fileName != null && !fileName.isEmpty()) {
            if (!this.descriptorMap.containsKey(fileName)) {
                this.descriptorMap.put(fileName, new GenericEditorWithContentTypeIcon(fileName, defaultDescriptor));
            }
            return this.descriptorMap.get(fileName);
        }
        return defaultDescriptor;
    }
}

