/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLViewer
extends ContentViewer {
    protected Composite viewerComp;
    protected StackLayout layout;
    protected Text messageText;
    protected Label messageLabel;
    protected boolean xmlTagMissing = false;
    protected boolean setEncoding = false;
    protected boolean missingEncoding = false;
    protected String originalEncoding;
    protected byte[] content;

    @Override
    public void setContent(byte[] b) {
        String out_temp;
        this.content = b;
        String out = "";
        if (b != null) {
            b = MonitorUIPlugin.unzip(b);
            out = MonitorUIPlugin.parse(b);
        }
        String lineSeparator = System.getProperty("line.separator");
        int ls = lineSeparator.length();
        if (out.length() > ls) {
            while (out.substring(0, ls).indexOf(lineSeparator) >= 0) {
                out = out.substring(ls, out.length());
            }
        }
        boolean bl = this.xmlTagMissing = !(out_temp = out.toLowerCase()).startsWith("<?xml");
        if (out.length() > 0) {
            String finalMsg = null;
            try {
                byte[] b1 = this.createDocument(out);
                finalMsg = new String(b1).trim();
            }
            catch (Exception exception) {
                this.messageText.setVisible(false);
                this.layout.topControl = this.messageLabel;
                this.messageLabel.setVisible(true);
                this.messageLabel.setText(Messages.xmlViewInvalid);
                return;
            }
            if (this.xmlTagMissing && (finalMsg.toLowerCase().startsWith("<?xml version=\"1.0\" encoding=\"utf-8\"?>") || finalMsg.toLowerCase().startsWith("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>") || finalMsg.toLowerCase().startsWith("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>"))) {
                int x = finalMsg.indexOf(">") + 1;
                String Msg = finalMsg.substring(x);
                while (Msg.substring(0, ls).indexOf(lineSeparator) >= 0) {
                    Msg = Msg.substring(ls, Msg.length());
                }
                finalMsg = Msg;
                this.messageText.setText(finalMsg);
            } else if (this.setEncoding) {
                int begin = finalMsg.toLowerCase().indexOf("utf-8");
                if (begin >= 0) {
                    int last = begin + 5;
                    String first_half = finalMsg.substring(0, begin);
                    String second_half = finalMsg.substring(last);
                    finalMsg = String.valueOf(first_half) + this.originalEncoding + second_half;
                }
                this.messageText.setText(finalMsg);
            } else if (this.missingEncoding) {
                int begin = finalMsg.toLowerCase().indexOf("encoding=\"utf-8\"");
                int last = begin + 16;
                String first_half = finalMsg.substring(0, begin);
                String second_half = finalMsg.substring(last);
                finalMsg = String.valueOf(first_half) + second_half;
                this.messageText.setText(finalMsg);
            } else {
                this.messageText.setText(finalMsg);
            }
        } else {
            this.messageText.setText(out);
        }
        this.messageLabel.setVisible(false);
        this.layout.topControl = this.messageText;
        this.messageText.setVisible(true);
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void init(Composite parent) {
        this.viewerComp = new Composite(parent, 0);
        this.layout = new StackLayout();
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
        this.viewerComp.setLayout((Layout)this.layout);
        this.messageText = new Text(this.viewerComp, 2826);
        Display display = this.viewerComp.getDisplay();
        this.messageText.setBackground(display.getSystemColor(25));
        this.messageText.setForeground(display.getSystemColor(24));
        this.messageText.setFont(JFaceResources.getTextFont());
        this.messageText.setVisible(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.messageText, "org.eclipse.wst.internet.monitor.ui.tmvw0006");
        this.messageLabel = new Label(this.viewerComp, 0);
        this.messageLabel.setVisible(false);
        this.layout.topControl = this.messageText;
    }

    protected byte[] createDocument(String str) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(true));
                factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", new Boolean(true));
            }
            catch (Exception exception) {}
            DocumentBuilder parser = factory.newDocumentBuilder();
            if (this.xmlTagMissing) {
                str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + str;
            } else {
                String str_temp = str.toLowerCase();
                int ind = str_temp.indexOf("encoding=");
                if (ind >= 0) {
                    String temp1 = str.substring(ind);
                    int beginIndex = temp1.indexOf("\"") + 1;
                    String temp2 = temp1.substring(beginIndex);
                    int endIndex = temp2.indexOf("\"");
                    this.originalEncoding = temp2.substring(0, endIndex);
                    if (!"utf-8".equals(this.originalEncoding)) {
                        this.setEncoding = true;
                    }
                } else if (ind < 0) {
                    this.setEncoding = false;
                    this.missingEncoding = true;
                }
            }
            byte[] parseArray = str.getBytes();
            Document document = parser.parse(new InputSource(new ByteArrayInputStream(parseArray)));
            return this.getContents(document);
        }
        catch (Exception exception) {
            throw new IOException("Invalid XML");
        }
    }

    protected byte[] getContents(Document document) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(document);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("indent-number", new Integer(2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("standalone", "no");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return out.toByteArray();
    }

    @Override
    public void dispose() {
        this.viewerComp.dispose();
        this.viewerComp = null;
        this.content = null;
    }
}

