/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.JsObjectProperty;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.RemoteValueMapping;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipValueBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.FunctionDetailsValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.GetFunctionDetailsData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.GetPropertiesData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.InternalPropertyDescriptorValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.runtime.PropertyDescriptorValue;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.GetFunctionDetailsParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.runtime.GetPropertiesParams;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;
import org.eclipse.wst.jsdt.chromium.util.AsyncFutureRef;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public abstract class WipValueLoader
implements RemoteValueMapping {
    private final WipTabImpl tabImpl;
    private final AtomicInteger cacheStateRef = new AtomicInteger(1);
    private final WipValueBuilder valueBuilder = new WipValueBuilder(this);
    private static final Getter<ObjectProperties> EMPTY_OBJECT_PROPERTIES_GETTER = Getter.newNormal(new ObjectProperties(){

        @Override
        public List<? extends JsObjectProperty> properties() {
            return Collections.emptyList();
        }

        @Override
        public JsVariable getProperty(String name) {
            return null;
        }

        @Override
        public List<? extends JsVariable> internalProperties() {
            return Collections.emptyList();
        }

        @Override
        public int getCacheState() {
            return Integer.MAX_VALUE;
        }
    });
    private static final Collection<String> INTERNAL_PROPERTY_NAME = Arrays.asList("__proto__");

    public WipValueLoader(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
    }

    public void clearCaches() {
        this.cacheStateRef.incrementAndGet();
    }

    WipValueBuilder getValueBuilder() {
        return this.valueBuilder;
    }

    WipTabImpl getTabImpl() {
        return this.tabImpl;
    }

    void loadJsObjectPropertiesInFuture(String objectId, boolean reload, int currentCacheState, AsyncFutureRef<Getter<ObjectProperties>> futureRef) throws MethodIsBlockingException {
        ObjectPropertyProcessor propertyProcessor = new ObjectPropertyProcessor(objectId);
        this.loadPropertiesInFuture(objectId, propertyProcessor, reload, currentCacheState, futureRef);
    }

    int getCacheState() {
        return this.cacheStateRef.get();
    }

    abstract String getObjectGroupId();

    static void setEmptyJsObjectProperties(AsyncFutureRef<Getter<ObjectProperties>> output) {
        output.initializeTrivial(EMPTY_OBJECT_PROPERTIES_GETTER);
    }

    <RES> void loadPropertiesInFuture(final String objectId, final LoadPostprocessor<RES> propertyPostprocessor, boolean reload, final int currentCacheState, AsyncFutureRef<RES> futureRef) throws MethodIsBlockingException {
        if (objectId == null) {
            futureRef.initializeTrivial(propertyPostprocessor.getEmptyResult());
            return;
        }
        AsyncFuture.SyncOperation syncOperation = new AsyncFuture.SyncOperation<RES>(){

            protected RES runSync() throws MethodIsBlockingException {
                LoadPropertiesResponse response = WipValueLoader.this.loadRawPropertiesSync(objectId);
                return response.accept(new LoadPropertiesResponse.Visitor<RES>(){

                    @Override
                    public RES visitData(GetPropertiesData data) {
                        return propertyPostprocessor.process(data.result(), data.internalProperties(), currentCacheState);
                    }

                    @Override
                    public RES visitFailure(Exception exception) {
                        return propertyPostprocessor.forException(new RuntimeException("Failed to read properties from remote", exception));
                    }
                });
            }
        };
        if (reload) {
            futureRef.reinitializeRunning(syncOperation.asAsyncOperation());
        } else {
            futureRef.initializeRunning(syncOperation.asAsyncOperation());
        }
        syncOperation.execute();
    }

    void loadFunctionLocationInFuture(final String objectId, AsyncFutureRef<Getter<FunctionDetailsValue>> loadedPositionRef) throws MethodIsBlockingException {
        AsyncFuture.Operation<Getter<FunctionDetailsValue>> operation = new AsyncFuture.Operation<Getter<FunctionDetailsValue>>(){

            public RelayOk start(final AsyncFuture.Callback<Getter<FunctionDetailsValue>> callback, SyncCallback syncCallback) {
                GetFunctionDetailsParams request = new GetFunctionDetailsParams(objectId);
                GenericCallback<GetFunctionDetailsData> wrappedCallback = new GenericCallback<GetFunctionDetailsData>(){

                    public void success(GetFunctionDetailsData value) {
                        callback.done(Getter.newNormal(value.details()));
                    }

                    public void failure(Exception exception) {
                        callback.done(Getter.newFailure(exception));
                    }
                };
                return WipValueLoader.this.tabImpl.getCommandProcessor().send(request, wrappedCallback, syncCallback);
            }
        };
        loadedPositionRef.initializeRunning((AsyncFuture.Operation)operation);
    }

    private LoadPropertiesResponse loadRawPropertiesSync(String objectId) throws MethodIsBlockingException {
        final LoadPropertiesResponse[] result = new LoadPropertiesResponse[1];
        GenericCallback<GetPropertiesData> callback = new GenericCallback<GetPropertiesData>(){

            public void success(final GetPropertiesData value) {
                result[0] = new LoadPropertiesResponse(){

                    @Override
                    <R> R accept(LoadPropertiesResponse.Visitor<R> visitor) {
                        return visitor.visitData(value);
                    }
                };
            }

            public void failure(final Exception exception) {
                result[0] = new LoadPropertiesResponse(){

                    @Override
                    <R> R accept(LoadPropertiesResponse.Visitor<R> visitor) {
                        return visitor.visitFailure(exception);
                    }
                };
            }
        };
        boolean ownProperties = true;
        GetPropertiesParams request = new GetPropertiesParams(objectId, ownProperties, null, null);
        CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
        RelayOk relayOk = this.tabImpl.getCommandProcessor().send(request, callback, (SyncCallback)callbackSemaphore);
        callbackSemaphore.acquireDefault(relayOk);
        return result[0];
    }

    static WipValueLoader castArgument(RemoteValueMapping mapping) {
        try {
            return (WipValueLoader)mapping;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Incorrect evaluate context argument", e);
        }
    }

    static abstract class Getter<T> {
        Getter() {
        }

        abstract T get();

        static <V> Getter<V> newNormal(final V value) {
            return new Getter<V>(){

                @Override
                V get() {
                    return value;
                }
            };
        }

        static <S> Getter<S> newFailure(final Exception cause) {
            return new Getter<S>(){

                @Override
                S get() {
                    throw new RuntimeException("Failed to load properties", cause);
                }
            };
        }
    }

    static interface LoadPostprocessor<RES> {
        public RES process(List<? extends PropertyDescriptorValue> var1, List<? extends InternalPropertyDescriptorValue> var2, int var3);

        public RES getEmptyResult();

        public RES forException(Exception var1);
    }

    private static abstract class LoadPropertiesResponse {
        private LoadPropertiesResponse() {
        }

        abstract <R> R accept(Visitor<R> var1);

        static interface Visitor<R> {
            public R visitData(GetPropertiesData var1);

            public R visitFailure(Exception var1);
        }
    }

    static interface ObjectProperties {
        public List<? extends JsObjectProperty> properties();

        public JsVariable getProperty(String var1);

        public List<? extends JsVariable> internalProperties();

        public int getCacheState();
    }

    private class ObjectPropertyProcessor
    implements LoadPostprocessor<Getter<ObjectProperties>> {
        private final String objectId;

        ObjectPropertyProcessor(String objectId) {
            this.objectId = objectId;
        }

        @Override
        public Getter<ObjectProperties> process(List<? extends PropertyDescriptorValue> propertyList, List<? extends InternalPropertyDescriptorValue> internalPropertyList, final int currentCacheState) {
            String name;
            final ArrayList<JsObjectProperty> properties = new ArrayList<JsObjectProperty>(propertyList.size());
            final ArrayList<Object> internalProperties = new ArrayList<Object>(2);
            for (PropertyDescriptorValue propertyDescriptorValue : propertyList) {
                name = propertyDescriptorValue.name();
                boolean isInternal = INTERNAL_PROPERTY_NAME.contains(name);
                JsObjectProperty property = WipValueLoader.this.valueBuilder.createObjectProperty(propertyDescriptorValue, this.objectId, name);
                if (isInternal) {
                    internalProperties.add(property);
                    continue;
                }
                properties.add(property);
            }
            if (internalPropertyList != null) {
                for (InternalPropertyDescriptorValue internalPropertyDescriptorValue : internalPropertyList) {
                    name = internalPropertyDescriptorValue.name();
                    JsVariable variable = WipValueLoader.this.valueBuilder.createVariable(internalPropertyDescriptorValue.value(), name);
                    internalProperties.add(variable);
                }
            }
            ObjectProperties objectProperties = new ObjectProperties(){
                private volatile Map<String, JsVariable> propertyMap = null;

                @Override
                public List<? extends JsObjectProperty> properties() {
                    return properties;
                }

                @Override
                public List<? extends JsVariable> internalProperties() {
                    return internalProperties;
                }

                @Override
                public JsVariable getProperty(String name) {
                    Map<String, JsVariable> map = this.propertyMap;
                    if (map == null) {
                        List<? extends JsObjectProperty> list = this.properties();
                        map = new HashMap<String, JsVariable>(list.size());
                        for (JsVariable jsVariable : list) {
                            map.put(jsVariable.getName(), jsVariable);
                        }
                        this.propertyMap = map;
                    }
                    return map.get(name);
                }

                @Override
                public int getCacheState() {
                    return currentCacheState;
                }
            };
            return Getter.newNormal(objectProperties);
        }

        @Override
        public Getter<ObjectProperties> getEmptyResult() {
            return EMPTY_OBJECT_PROPERTIES_GETTER;
        }

        @Override
        public Getter<ObjectProperties> forException(Exception exception) {
            return Getter.newFailure(exception);
        }
    }
}

