/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.doc.doc2model.common.Common.DocumentModel;
import org.polarsys.kitalpha.doc.doc2model.core.IContentHandler;
import org.polarsys.kitalpha.doc.doc2model.core.IParsingFacility;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class Doc2Model<T> {
    private IParsingFacility _parsingFacility = (IParsingFacility)ZigguratInject.make(IParsingFacility.class);
    private IContentHandler<T> userHandler = null;
    private T documentModel;

    public Doc2Model<T> transform(String fileString, Class<T> theClass) {
        if (this.userHandler == null) {
            this.userHandler = this.getContentHandler(fileString, theClass);
        }
        this.documentModel = this._parsingFacility.transform(fileString, this.userHandler);
        return this;
    }

    public Collection<IContentHandler<T>> getContentHandlers(String fileString, Class<T> theClass) {
        IConfigurationElement[] config;
        ArrayList result = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.doc.doc2model.core", "IContentHandler");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object o = ZigguratInject.make((Class)Platform.getBundle((String)element.getContributor().getName()).loadClass(element.getAttribute("handler")));
                if (o instanceof IContentHandler) {
                    IContentHandler handler = (IContentHandler)o;
                    if (theClass == null || theClass.isAssignableFrom(handler.getDocumentClass())) {
                        result.add(handler);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    public IContentHandler<T> getContentHandler(String fileString, String classQualifiedName) {
        Collection<IContentHandler<T>> result = this.getContentHandlers(fileString, null);
        for (IContentHandler<T> h : result) {
            if (!h.getClass().getName().equals(classQualifiedName)) continue;
            return h;
        }
        return null;
    }

    private IContentHandler<T> getContentHandler(String fileString, Class<T> theClass) {
        Collection<IContentHandler<T>> result = this.getContentHandlers(fileString, theClass);
        if (result != null && result.size() > 0) {
            return result.iterator().next();
        }
        return null;
    }

    public String getFileType(String fileString) {
        return this._parsingFacility.getFileType(fileString);
    }

    public Doc2Model<T> setContentHandler(IContentHandler<T> handler) {
        this.userHandler = handler;
        return this;
    }

    public T getDocModel() {
        return this.documentModel;
    }

    public static IContentHandler<DocumentModel> getDefaultContentHandler(String fileString) {
        return null;
    }
}

