/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.EReachable;
import org.polarsys.reqcycle.traceability.emf.ReqCycleTraceability.IRequestManager;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.types.conditions.TypeConditions;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;

@Singleton
public class RequestManager
implements IRequestManager {
    private Object target;
    @Inject
    IReachableCreator creator;

    @Override
    public Request getUpwardRequest(EReachable source) {
        return this.getRequest(source, ITraceabilityEngine.DIRECTION.UPWARD);
    }

    @Override
    public Request getDownwardRequest(EReachable source) {
        return this.getRequest(source, ITraceabilityEngine.DIRECTION.DOWNWARD);
    }

    protected Request getRequest(EReachable source, ITraceabilityEngine.DIRECTION direction) {
        Reachable sourceR = (Reachable)source.getAdapter(Reachable.class);
        CompositeScope scope = new CompositeScope();
        scope.add(Scopes.getWorkspaceScope());
        Request request = new Request().setDirection(direction).setScope((IScope)scope).setDepth(Request.DEPTH.ONE).addProperty("optionCheckCache", (Object)false);
        if (this.target == null) {
            request.addSource(sourceR);
        } else {
            if (this.target instanceof Reachable) {
                request.addSourceAndTarget(sourceR, (Reachable)this.target);
            } else if (this.target instanceof IType) {
                request.addSourceAndCondition(sourceR, TypeConditions.is((IType)((IType)this.target)));
            }
            request.setDepth(Request.DEPTH.ONE);
        }
        return request;
    }
}

