/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSClientChannel;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttChannel;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttChannelMessageHandler;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttJMSClientChannel
extends AbstractJMSClientChannel
implements MqttChannelMessageHandler {
    private static final long serialVersionUID = -4250141332659030158L;
    private int qos;
    private MqttConnectOptions mqttConnectOptions;
    private MqttChannel channel;

    public MqttJMSClientChannel(ISynchAsynchEventHandler handler, int keepAlive, int qos, MqttConnectOptions options) {
        super(handler, keepAlive);
        this.qos = qos;
        this.mqttConnectOptions = options;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    protected Serializable setupJMS(JMSID targetID, Object data) throws ECFException {
        this.channel = new MqttChannel(targetID, this.getLocalID(), this.mqttConnectOptions, this.qos, this);
        return (Serializable)data;
    }

    protected void createAndSendMessage(Serializable object, String jmsCorrelationId) throws JMSException {
        if (this.channel != null) {
            this.channel.sendMessage(object, jmsCorrelationId);
        }
    }

    protected Object readObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return MqttChannel.osu.deserializeFromBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
            this.mqttConnectOptions = null;
        }
        Object object = this.waitResponse;
        synchronized (object) {
            this.waitResponse.notifyAll();
        }
        this.fireListenersDisconnect(new ConnectionEvent((IConnection)this, null));
        this.connectionListeners.clear();
    }

    protected ConnectionFactory createJMSConnectionFactory(JMSID targetID) throws IOException {
        return null;
    }

    public void handleMqttChannelMessage(byte[] data, String correlation) {
        super.handleMessage(data, correlation);
    }

    public void connectionLost(Throwable arg0) {
    }
}

