/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.Array;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.CloneCopyPolicy;
import org.eclipse.persistence.annotations.CopyPolicy;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.annotations.ExcludeDefaultMappings;
import org.eclipse.persistence.annotations.InstantiationCopyPolicy;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.Struct;
import org.eclipse.persistence.annotations.Structure;
import org.eclipse.persistence.annotations.Transformation;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DerivedIdClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ElementCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.TransformationAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VariableOneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CloneCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CustomCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.InstantiationCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLRecordMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.ArrayAccessor;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructMetadata;
import org.eclipse.persistence.internal.jpa.metadata.structures.StructureAccessor;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.oracle.annotations.PLSQLRecord;
import org.eclipse.persistence.platform.database.oracle.annotations.PLSQLRecords;
import org.eclipse.persistence.platform.database.oracle.annotations.PLSQLTable;
import org.eclipse.persistence.platform.database.oracle.annotations.PLSQLTables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassAccessor
extends MetadataAccessor {
    private boolean m_isPreProcessed = false;
    private boolean m_isProcessed = false;
    private Boolean m_excludeDefaultMappings;
    private Boolean m_metadataComplete;
    private ChangeTrackingMetadata m_changeTracking;
    private CloneCopyPolicyMetadata m_cloneCopyPolicy;
    private CustomCopyPolicyMetadata m_customCopyPolicy;
    private InstantiationCopyPolicyMetadata m_instantiationCopyPolicy;
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
    private List<MappedSuperclassAccessor> m_mappedSuperclasses = new ArrayList<MappedSuperclassAccessor>();
    private List<MetadataDescriptor> m_owningDescriptors = new ArrayList<MetadataDescriptor>();
    private MetadataClass m_customizerClass;
    private MetadataClass m_parentClass;
    private String m_className;
    private String m_customizerClassName;
    private String m_parentClassName;
    private String m_description;
    private XMLAttributes m_attributes;
    private List<PLSQLRecordMetadata> m_plsqlRecords = new ArrayList<PLSQLRecordMetadata>();
    private List<PLSQLTableMetadata> m_plsqlTables = new ArrayList<PLSQLTableMetadata>();
    private StructMetadata m_struct;

    protected ClassAccessor(String xmlElement) {
        super(xmlElement);
    }

    public ClassAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataProject project) {
        super(annotation, cls, new MetadataDescriptor(cls), project);
        this.getDescriptor().setClassAccessor(this);
        this.initAccess();
    }

    protected ClassAccessor(MetadataAnnotation annotation, MetadataClass cls, MetadataDescriptor descriptor) {
        super(annotation, cls, descriptor, descriptor.getProject());
        this.initAccess();
    }

    protected void addAccessor(MappingAccessor accessor) {
        if (accessor != null) {
            accessor.processConverters();
            if (accessor.isEmbeddedId()) {
                this.getProject().addIdClass(accessor.getReferenceClassName());
            }
            this.addPotentialEmbeddableAccessor(accessor.getReferenceClass(), accessor.getClassAccessor());
            if (accessor.isMappedKeyMapAccessor()) {
                MappedKeyMapAccessor mapAccessor = (MappedKeyMapAccessor)((Object)accessor);
                MetadataClass mapKeyClass = mapAccessor.getMapKeyClass();
                if (mapKeyClass == null || mapKeyClass.isVoid()) {
                    mapKeyClass = accessor.getMapKeyReferenceClass();
                    mapAccessor.setMapKeyClass(mapKeyClass);
                }
                this.addPotentialEmbeddableAccessor(mapKeyClass, accessor.getClassAccessor());
            }
            this.getDescriptor().addMappingAccessor(accessor);
        }
    }

    public void addAccessors() {
        if (this.m_attributes != null) {
            for (MappingAccessor accessor : this.m_attributes.getAccessors()) {
                MetadataAnnotatedElement accessibleObject = null;
                accessor.initXMLMappingAccessor(this);
                accessibleObject = accessor.usesVirtualAccess() ? this.getAccessibleVirtualMethod(accessor) : (accessor.usesPropertyAccess() ? this.getAccessibleMethod(accessor) : this.getAccessibleField(accessor));
                if (accessibleObject == null) continue;
                accessor.initXMLObject(accessibleObject, this.getEntityMappings());
                accessor.initAccess();
                if (accessor.usesVirtualAccess() && !accessor.hasAttributeType()) {
                    throw ValidationException.noAttributeTypeSpecification(accessor.getAttributeName(), this.getJavaClassName(), this.getLocation());
                }
                this.addAccessor(accessor);
            }
        }
        if (!this.usesVirtualAccess()) {
            if (this.usesPropertyAccess()) {
                this.addAccessorMethods(false);
            } else {
                this.addAccessorFields(false);
            }
        }
    }

    protected void addAccessorFields(boolean processingInverse) {
        for (MetadataField metadataField : this.getJavaClass().getFields().values()) {
            if (metadataField.isAnnotationPresent(Transient.class, this) || metadataField.shouldBeIgnored()) {
                if (metadataField.areAnnotationsCompatibleWithTransient(this)) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(metadataField);
            }
            if (!metadataField.isValidPersistenceField(processingInverse, this) || this.getDescriptor().hasMappingAccessor(metadataField.getAttributeName()) && (!this.getDescriptor().hasMappingAccessor(metadataField.getAttributeName()) || !processingInverse)) continue;
            this.addAccessor(this.buildAccessor(metadataField));
        }
        if (this.hasAccess() && !processingInverse) {
            this.addAccessorMethods(true);
        }
    }

    protected void addAccessorMethods(boolean processingInverse) {
        for (MetadataMethod metadataMethod : this.getJavaClass().getMethods().values()) {
            if (metadataMethod.isAnnotationPresent(Transient.class, this)) {
                if (metadataMethod.areAnnotationsCompatibleWithTransient(this)) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute(metadataMethod);
            }
            if (!metadataMethod.isValidPersistenceMethod(processingInverse, this) || this.getDescriptor().hasMappingAccessor(metadataMethod.getAttributeName()) && (!this.getDescriptor().hasMappingAccessor(metadataMethod.getAttributeName()) || !processingInverse)) continue;
            this.addAccessor(this.buildAccessor(metadataMethod));
        }
        if (this.hasAccess() && !processingInverse) {
            this.addAccessorFields(true);
        }
    }

    protected void addPotentialEmbeddableAccessor(MetadataClass potentialEmbeddableClass, ClassAccessor embeddingAccessor) {
        EmbeddableAccessor embeddableAccessor;
        if (potentialEmbeddableClass != null && (embeddableAccessor = this.getProject().getEmbeddableAccessor(potentialEmbeddableClass)) != null) {
            embeddableAccessor.addEmbeddingAccessor(embeddingAccessor);
            embeddableAccessor.addOwningDescriptor(this.getDescriptor());
            if (this.getDescriptor().isMappedSuperclass() || this.getDescriptor().isEmbeddable()) {
                if (!embeddableAccessor.isPreProcessed()) {
                    embeddableAccessor.preProcess();
                }
            } else {
                this.getProject().addRootEmbeddableAccessor(embeddableAccessor);
            }
        }
    }

    protected void addPotentialMappedSuperclass(MetadataClass metadataClass, boolean addMappedSuperclassAccessors) {
        MappedSuperclassAccessor accessor = this.getProject().getMappedSuperclassAccessor(metadataClass);
        if (accessor == null) {
            if (addMappedSuperclassAccessors && metadataClass.isAnnotationPresent(MappedSuperclass.class)) {
                this.m_mappedSuperclasses.add(new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getDescriptor()));
                this.getProject().addMetamodelMappedSuperclass(new MappedSuperclassAccessor(metadataClass.getAnnotation(MappedSuperclass.class), metadataClass, this.getProject()), this.getDescriptor());
            }
        } else if (addMappedSuperclassAccessors) {
            this.m_mappedSuperclasses.add(this.reloadMappedSuperclass(accessor, this.getDescriptor()));
            this.getProject().addMetamodelMappedSuperclass(this.reloadMappedSuperclass(accessor, new MetadataDescriptor(metadataClass)), this.getDescriptor());
        } else {
            this.m_mappedSuperclasses.add(accessor);
        }
    }

    protected MappingAccessor buildAccessor(MetadataAnnotatedElement accessibleObject) {
        if (accessibleObject.isBasicCollection(this)) {
            return new BasicCollectionAccessor(accessibleObject.getAnnotation(BasicCollection.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isBasicMap(this)) {
            return new BasicMapAccessor(accessibleObject.getAnnotation(BasicMap.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isArray(this)) {
            return new ArrayAccessor(accessibleObject.getAnnotation(Array.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isElementCollection(this)) {
            return new ElementCollectionAccessor(accessibleObject.getAnnotation(ElementCollection.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isVersion(this)) {
            return new VersionAccessor(accessibleObject.getAnnotation(Version.class), accessibleObject, this);
        }
        if (accessibleObject.isId(this) && !accessibleObject.isDerivedId(this)) {
            return new IdAccessor(accessibleObject.getAnnotation(Id.class), accessibleObject, this);
        }
        if (accessibleObject.isDerivedIdClass(this)) {
            return new DerivedIdClassAccessor(accessibleObject, this);
        }
        if (accessibleObject.isBasic(this)) {
            return new BasicAccessor(accessibleObject.getAnnotation(Basic.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isStructure(this)) {
            return new StructureAccessor(accessibleObject.getAnnotation(Structure.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isEmbedded(this)) {
            return new EmbeddedAccessor(accessibleObject.getAnnotation(Embedded.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isEmbeddedId(this)) {
            return new EmbeddedIdAccessor(accessibleObject.getAnnotation(EmbeddedId.class), (MetadataAccessibleObject)accessibleObject, this);
        }
        if (accessibleObject.isTransformation(this)) {
            return new TransformationAccessor(accessibleObject.getAnnotation(Transformation.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToMany(this)) {
            return new ManyToManyAccessor(accessibleObject.getAnnotation(ManyToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isManyToOne(this)) {
            return new ManyToOneAccessor(accessibleObject.getAnnotation(ManyToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToMany(this)) {
            return new OneToManyAccessor(accessibleObject.getAnnotation(OneToMany.class), accessibleObject, this);
        }
        if (accessibleObject.isOneToOne(this)) {
            return new OneToOneAccessor(accessibleObject.getAnnotation(OneToOne.class), accessibleObject, this);
        }
        if (accessibleObject.isVariableOneToOne(this)) {
            return new VariableOneToOneAccessor(accessibleObject.getAnnotation(VariableOneToOne.class), accessibleObject, this);
        }
        if (this.excludeDefaultMappings()) {
            return null;
        }
        return new BasicAccessor(accessibleObject.getAnnotation(Basic.class), (MetadataAccessibleObject)accessibleObject, this);
    }

    protected void clearMappedSuperclassesAndInheritanceParents() {
        this.m_mappedSuperclasses.clear();
        this.getDescriptor().setInheritanceParentDescriptor(null);
        this.getDescriptor().setInheritanceRootDescriptor(null);
    }

    public void clearPreProcessed() {
        this.m_isPreProcessed = false;
        this.getDescriptor().clearMappingAccessors();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ClassAccessor) {
            ClassAccessor accessor = (ClassAccessor)objectToCompare;
            return this.valuesMatch(this.getJavaClassName(), accessor.getJavaClassName());
        }
        return false;
    }

    public boolean excludeDefaultMappings() {
        if (this.getProject().excludeDefaultMappings()) {
            return true;
        }
        if (this.m_excludeDefaultMappings != null) {
            return this.m_excludeDefaultMappings;
        }
        return this.isAnnotationPresent(ExcludeDefaultMappings.class);
    }

    protected MetadataField getAccessibleField(MappingAccessor accessor) {
        MetadataField field = this.getJavaClass().getField(accessor.getName());
        if (field == null) {
            throw ValidationException.invalidFieldForClass(accessor.getName(), this.getJavaClass());
        }
        if (accessor.isTransient() || field.isValidPersistenceField(this, true)) {
            return field;
        }
        return null;
    }

    protected MetadataMethod getAccessibleMethod(MappingAccessor accessor) {
        if (accessor.hasAccessMethods()) {
            MetadataMethod getMethod = this.getJavaClass().getMethod(accessor.getGetMethodName(), new String[0]);
            MetadataMethod setMethod = this.getJavaClass().getMethod(accessor.getSetMethodName(), Arrays.asList(getMethod.getReturnType()));
            getMethod.setSetMethod(setMethod);
            return getMethod;
        }
        MetadataMethod method = this.getJavaClass().getMethodForPropertyName(accessor.getName());
        if (method == null) {
            throw ValidationException.invalidPropertyForClass(accessor.getName(), this.getJavaClass());
        }
        if (accessor.isTransient() || method.isValidPersistenceMethod(this, true)) {
            return method;
        }
        return null;
    }

    protected MetadataMethod getAccessibleVirtualMethod(MappingAccessor accessor) {
        if (!accessor.hasAccessMethods()) {
            accessor.setAccessMethods(this.getDescriptor().getDefaultAccessMethods());
        }
        MetadataMethod getMethod = new MetadataMethod(this.getMetadataFactory(), this.getJavaClass());
        MetadataMethod setMethod = new MetadataMethod(this.getMetadataFactory(), this.getJavaClass());
        getMethod.setSetMethod(setMethod);
        getMethod.setAttributeName(accessor.getName());
        getMethod.setName(accessor.getGetMethodName());
        setMethod.setName(accessor.getSetMethodName());
        return getMethod;
    }

    public String getAccessType() {
        if (this.hasAccess()) {
            return this.getAccess();
        }
        return this.getDescriptor().getDefaultAccess();
    }

    @Override
    protected MetadataAnnotation getAnnotation(String annotation) {
        return this.getAccessibleObject().getAnnotation(annotation, this);
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public CopyPolicyMetadata getCopyPolicy() {
        if (this.m_cloneCopyPolicy != null) {
            return this.m_cloneCopyPolicy;
        }
        if (this.m_instantiationCopyPolicy != null) {
            return this.m_instantiationCopyPolicy;
        }
        return this.m_customCopyPolicy;
    }

    public CloneCopyPolicyMetadata getCloneCopyPolicy() {
        return this.m_cloneCopyPolicy;
    }

    public CustomCopyPolicyMetadata getCustomCopyPolicy() {
        return this.m_customCopyPolicy;
    }

    public MetadataClass getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Boolean getExcludeDefaultMappings() {
        return this.m_excludeDefaultMappings;
    }

    @Override
    public String getIdentifier() {
        return this.getJavaClassName();
    }

    public InstantiationCopyPolicyMetadata getInstantiationCopyPolicy() {
        return this.m_instantiationCopyPolicy;
    }

    @Override
    public MetadataClass getJavaClass() {
        return (MetadataClass)this.getAnnotatedElement();
    }

    @Override
    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    public MetadataDescriptor getOwningDescriptor() {
        return this.getDescriptor();
    }

    public List<MetadataDescriptor> getOwningDescriptors() {
        if (this.m_owningDescriptors.isEmpty() && !this.isEmbeddableAccessor()) {
            this.m_owningDescriptors.add(this.getDescriptor());
        }
        return this.m_owningDescriptors;
    }

    protected MetadataClass getParentClass() {
        return this.m_parentClass;
    }

    public String getParentClassName() {
        return this.m_parentClassName;
    }

    public boolean hasDerivedId() {
        return !this.getDescriptor().getDerivedIdAccessors().isEmpty();
    }

    protected boolean hasParentClass() {
        return this.m_parentClass != null && !this.m_parentClass.isVoid();
    }

    public boolean isMappedSuperclass() {
        return false;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    public boolean isPreProcessed() {
        return this.m_isPreProcessed;
    }

    @Override
    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public boolean ignoreAnnotations() {
        if (this.getProject().isXMLMappingMetadataComplete()) {
            return true;
        }
        return this.isMetadataComplete();
    }

    public void initXMLClassAccessor(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project, XMLEntityMappings entityMappings) {
        this.initXMLAccessor(descriptor, project);
        this.initXMLObject(accessibleObject, entityMappings);
        this.initAccess();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_changeTracking, accessibleObject);
        this.initXMLObject(this.m_cloneCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_customCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_instantiationCopyPolicy, accessibleObject);
        this.initXMLObject(this.m_attributes, accessibleObject);
        this.initXMLObject(this.m_struct, accessibleObject);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_plsqlRecords, accessibleObject);
        this.initXMLObjects(this.m_plsqlTables, accessibleObject);
        this.m_customizerClass = this.initXMLClassName(this.m_customizerClassName);
        this.m_parentClass = this.initXMLClassName(this.m_parentClassName);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation, this);
    }

    public boolean isClassAccessor() {
        return true;
    }

    public boolean isEmbeddableAccessor() {
        return false;
    }

    public boolean isEntityAccessor() {
        return false;
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        ClassAccessor accessor = (ClassAccessor)metadata;
        this.m_customizerClass = (MetadataClass)this.mergeSimpleObjects(this.m_customizerClass, accessor.getCustomizerClass(), accessor, "<customizer>");
        this.m_customizerClassName = (String)this.mergeSimpleObjects(this.m_customizerClassName, accessor.getCustomizerClassName(), accessor, "<customizer>");
        this.m_parentClass = (MetadataClass)this.mergeSimpleObjects(this.m_parentClass, accessor.getParentClass(), accessor, "<parent-class>");
        this.m_parentClassName = (String)this.mergeSimpleObjects(this.m_parentClassName, accessor.getParentClassName(), accessor, "<parent-class>");
        this.m_description = (String)this.mergeSimpleObjects(this.m_description, accessor.getDescription(), accessor, "<description>");
        this.m_metadataComplete = (Boolean)this.mergeSimpleObjects(this.m_metadataComplete, accessor.getMetadataComplete(), accessor, "@metadata-complete");
        this.m_excludeDefaultMappings = (Boolean)this.mergeSimpleObjects(this.m_excludeDefaultMappings, accessor.getExcludeDefaultMappings(), accessor, "@exclude-default-mappings");
        this.m_cloneCopyPolicy = (CloneCopyPolicyMetadata)this.mergeORObjects(this.m_cloneCopyPolicy, accessor.getCloneCopyPolicy());
        this.m_customCopyPolicy = (CustomCopyPolicyMetadata)this.mergeORObjects(this.m_customCopyPolicy, accessor.getCustomCopyPolicy());
        this.m_instantiationCopyPolicy = (InstantiationCopyPolicyMetadata)this.mergeORObjects(this.m_instantiationCopyPolicy, accessor.getInstantiationCopyPolicy());
        this.m_changeTracking = (ChangeTrackingMetadata)this.mergeORObjects(this.m_changeTracking, accessor.getChangeTracking());
        this.m_struct = (StructMetadata)this.mergeORObjects(this.m_struct, accessor.getStruct());
        this.m_associationOverrides = this.mergeORObjectLists(this.m_associationOverrides, accessor.getAssociationOverrides());
        this.m_attributeOverrides = this.mergeORObjectLists(this.m_attributeOverrides, accessor.getAttributeOverrides());
        this.m_plsqlRecords = this.mergeORObjectLists(this.m_plsqlRecords, accessor.getPLSQLRecords());
        this.m_plsqlTables = this.mergeORObjectLists(this.m_plsqlTables, accessor.getPLSQLTables());
        if (this.m_attributes == null) {
            this.m_attributes = accessor.getAttributes();
        } else {
            this.m_attributes.merge(accessor.getAttributes());
        }
    }

    public void preProcess() {
        this.processStruct();
        this.processConverters();
        this.addAccessors();
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            this.preProcessMappedSuperclassMetadata(mappedSuperclass);
        }
        this.setIsPreProcessed();
    }

    public void preProcessForCanonicalModel() {
        this.processAccessType();
        this.addAccessors();
        this.setIsPreProcessed();
    }

    protected void preProcessMappedSuperclassMetadata(MappedSuperclassAccessor mappedSuperclass) {
        mappedSuperclass.preProcess();
    }

    @Override
    public void process() {
        this.processAttributeOverrides();
        this.processAssociationOverrides();
        this.processChangeTracking();
        this.processCustomizer();
        this.processCopyPolicy();
        this.processPartitioning();
        this.processProperties();
        this.processPLSQLTypes();
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            this.processMappedSuperclassMetadata(mappedSuperclass);
        }
        this.setIsProcessed();
    }

    protected abstract void processAccessType();

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.shouldOverride(this.getDescriptor().getAssociationOverrideFor(associationOverride.getName()), this.getLogger(), this.getDescriptor().getJavaClassName())) {
            this.getDescriptor().addAssociationOverride(associationOverride);
        }
    }

    protected void processAssociationOverrides() {
        MetadataAnnotation metadataAnnotation;
        for (AssociationOverrideMetadata associationOverrideMetadata : this.m_associationOverrides) {
            this.processAssociationOverride(associationOverrideMetadata);
        }
        MetadataAnnotation associationOverrides = this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (Object associationOverride3 : (Object[])associationOverrides.getAttributeArray("value")) {
                this.processAssociationOverride(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride3, this));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(new AssociationOverrideMetadata(metadataAnnotation, this));
        }
    }

    protected void processAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.shouldOverride(this.getDescriptor().getAttributeOverrideFor(attributeOverride.getName()), this.getLogger(), this.getDescriptor().getJavaClassName())) {
            this.getDescriptor().addAttributeOverride(attributeOverride);
        }
    }

    protected void processAttributeOverrides() {
        MetadataAnnotation metadataAnnotation;
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.m_attributeOverrides) {
            this.processAttributeOverride(attributeOverrideMetadata);
        }
        MetadataAnnotation attributeOverrides = this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (Object attributeOverride3 : (Object[])attributeOverrides.getAttribute("value")) {
                this.processAttributeOverride(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride3, this));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(new AttributeOverrideMetadata(metadataAnnotation, this));
        }
    }

    protected void processChangeTracking() {
        MetadataAnnotation changeTracking = this.getAnnotation(ChangeTracking.class);
        if (this.m_changeTracking != null || changeTracking != null) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata(changeTracking, this).process(this.getDescriptor());
            } else {
                if (changeTracking != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", changeTracking, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processCopyPolicy() {
        MetadataAnnotation copyPolicy = this.getAnnotation(CopyPolicy.class);
        MetadataAnnotation instantiationCopyPolicy = this.getAnnotation(InstantiationCopyPolicy.class);
        MetadataAnnotation cloneCopyPolicy = this.getAnnotation(CloneCopyPolicy.class);
        if (this.getCopyPolicy() != null || copyPolicy != null || instantiationCopyPolicy != null || cloneCopyPolicy != null) {
            if (this.getDescriptor().hasCopyPolicy()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_copy_policy", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            }
            if (this.getCopyPolicy() == null) {
                if (copyPolicy != null) {
                    if (instantiationCopyPolicy != null || cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new CustomCopyPolicyMetadata(copyPolicy, this).process(this.getDescriptor());
                }
                if (instantiationCopyPolicy != null) {
                    if (cloneCopyPolicy != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass(this.getJavaClassName());
                    }
                    new InstantiationCopyPolicyMetadata(instantiationCopyPolicy, this).process(this.getDescriptor());
                }
                if (cloneCopyPolicy != null) {
                    new CloneCopyPolicyMetadata(cloneCopyPolicy, this).process(this.getDescriptor());
                }
            } else {
                if (copyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", copyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                if (instantiationCopyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", instantiationCopyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                if (cloneCopyPolicy != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", cloneCopyPolicy, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.getCopyPolicy().process(this.getDescriptor());
            }
        }
    }

    protected void processCustomizer() {
        MetadataAnnotation customizer = this.getAnnotation(Customizer.class);
        if (this.m_customizerClass != null && !this.m_customizerClass.isVoid() || customizer != null) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), (Object)this.getJavaClass());
            } else {
                if (this.m_customizerClass == null || this.m_customizerClass.isVoid()) {
                    this.m_customizerClass = this.getMetadataClass((String)customizer.getAttribute("value"));
                } else if (customizer != null) {
                    this.getLogger().logConfigMessage("metadata_warning_override_annotation_with_xml", customizer, (Object)this.getJavaClassName(), this.getLocation());
                }
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    public void processDerivedId(HashSet<ClassAccessor> processing, HashSet<ClassAccessor> processed) {
        if (!processed.contains(this)) {
            if (processing.contains(this)) {
                throw ValidationException.idRelationshipCircularReference(processing);
            }
            processing.add(this);
            for (ObjectAccessor accessor : this.getDescriptor().getDerivedIdAccessors()) {
                MetadataDescriptor referenceDescriptor = accessor.getReferenceDescriptor();
                ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
                if (referenceAccessor.hasDerivedId()) {
                    referenceAccessor.processDerivedId(processing, processed);
                }
                if (accessor.isProcessed()) continue;
                accessor.process();
            }
            processing.remove(this);
            processed.add(this);
        }
    }

    protected void processMappedSuperclassMetadata(MappedSuperclassAccessor mappedSuperclass) {
        mappedSuperclass.process();
    }

    public void processMappingAccessors() {
        this.getDescriptor().processMappingAccessors();
    }

    public void processParentClass() {
        if (this.hasParentClass()) {
            this.getJavaClass().setSuperclass(this.getParentClass());
        } else if (this.getJavaClass().getSuperclass() == null) {
            this.getJavaClass().setSuperclass(this.getMetadataClass(Object.class));
        }
    }

    protected void processProperties() {
        MetadataAnnotation metadataAnnotation;
        for (PropertyMetadata propertyMetadata : this.getProperties()) {
            this.getDescriptor().addProperty(propertyMetadata);
        }
        MetadataAnnotation properties = this.getAnnotation(Properties.class);
        if (properties != null) {
            for (Object property3 : (Object[])properties.getAttributeArray("value")) {
                this.getDescriptor().addProperty(new PropertyMetadata((MetadataAnnotation)property3, this));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(Property.class)) != null) {
            this.getDescriptor().addProperty(new PropertyMetadata(metadataAnnotation, this));
        }
    }

    public void processPLSQLTypes() {
        MetadataAnnotation table;
        MetadataAnnotation metadataAnnotation;
        for (PLSQLRecordMetadata pLSQLRecordMetadata : this.m_plsqlRecords) {
            this.getProject().addPLSQLComplexType(pLSQLRecordMetadata);
        }
        MetadataAnnotation records = this.getAnnotation(PLSQLRecords.class);
        if (records != null) {
            for (Object record3 : (Object[])records.getAttribute("value")) {
                this.getProject().addPLSQLComplexType(new PLSQLRecordMetadata((MetadataAnnotation)record3, this));
            }
        }
        if ((metadataAnnotation = this.getAnnotation(PLSQLRecord.class)) != null) {
            this.getProject().addPLSQLComplexType(new PLSQLRecordMetadata(metadataAnnotation, this));
        }
        for (PLSQLTableMetadata table2 : this.m_plsqlTables) {
            this.getProject().addPLSQLComplexType(table2);
        }
        MetadataAnnotation tables = this.getAnnotation(PLSQLTables.class);
        if (tables != null) {
            for (Object table3 : (Object[])tables.getAttribute("value")) {
                this.getProject().addPLSQLComplexType(new PLSQLTableMetadata((MetadataAnnotation)table3, this));
            }
        }
        if ((table = this.getAnnotation(PLSQLTable.class)) != null) {
            this.getProject().addPLSQLComplexType(new PLSQLTableMetadata(table, this));
        }
    }

    protected void processStruct() {
        MetadataAnnotation struct;
        if (this.m_struct != null) {
            this.m_struct.process(this.getDescriptor());
        }
        if ((struct = this.getAnnotation(Struct.class)) != null) {
            new StructMetadata(struct, this).process(this.getDescriptor());
        }
    }

    protected void processVirtualClass() {
        if (this.usesVirtualAccess() && !this.getJavaClass().isAccessible()) {
            this.getProject().addVirtualClass(this);
            if (this.isEmbeddableAccessor()) {
                this.getProject().addAlias(Helper.getShortClassName(this.getJavaClassName()), this.getDescriptor());
            }
        }
    }

    protected void resolveGenericTypes(List<String> genericTypes, MetadataClass parent) {
        this.getMetadataFactory().resolveGenericTypes(this.getJavaClass(), genericTypes, parent, this.getDescriptor());
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.m_attributes = attributes;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTracking) {
        this.m_changeTracking = changeTracking;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setCloneCopyPolicy(CloneCopyPolicyMetadata copyPolicy) {
        this.m_cloneCopyPolicy = copyPolicy;
    }

    public void setCustomCopyPolicy(CustomCopyPolicyMetadata copyPolicy) {
        this.m_customCopyPolicy = copyPolicy;
    }

    public void setCustomizerClassName(String customizerClassName) {
        this.m_customizerClassName = customizerClassName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setExcludeDefaultMappings(Boolean excludeDefaultMappings) {
        this.m_excludeDefaultMappings = excludeDefaultMappings;
    }

    public void setInstantiationCopyPolicy(InstantiationCopyPolicyMetadata copyPolicy) {
        this.m_instantiationCopyPolicy = copyPolicy;
    }

    protected void setIsPreProcessed() {
        this.m_isPreProcessed = true;
    }

    protected void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public void setJavaClass(MetadataClass cls) {
        this.setAccessibleObject(cls);
        this.getDescriptor().setJavaClass(cls);
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.m_metadataComplete = metadataComplete;
    }

    protected void setParentClass(MetadataClass parentClass) {
        this.m_parentClass = parentClass;
    }

    public void setParentClassName(String parentClassName) {
        this.m_parentClassName = parentClassName;
    }

    public String toString() {
        return this.getJavaClassName();
    }

    public boolean usesFieldAccess() {
        return this.getAccessType().equals("FIELD");
    }

    public boolean usesPropertyAccess() {
        return this.getAccessType().equals("PROPERTY");
    }

    public boolean usesVirtualAccess() {
        return this.getAccessType().equals("VIRTUAL");
    }

    public List<PLSQLRecordMetadata> getPLSQLRecords() {
        return this.m_plsqlRecords;
    }

    public void setPLSQLRecords(List<PLSQLRecordMetadata> records) {
        this.m_plsqlRecords = records;
    }

    public List<PLSQLTableMetadata> getPLSQLTables() {
        return this.m_plsqlTables;
    }

    public void setPLSQLTables(List<PLSQLTableMetadata> tables) {
        this.m_plsqlTables = tables;
    }

    public StructMetadata getStruct() {
        return this.m_struct;
    }

    public void setStruct(StructMetadata struct) {
        this.m_struct = struct;
    }
}

