/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class DatabaseTypeHandle
extends MWHandle {
    private volatile DatabaseType databaseType;
    private volatile String databaseTypeName;

    DatabaseTypeHandle(MWColumn parent) {
        super(parent, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
    }

    DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    protected Node node() {
        return this.getDatabaseType();
    }

    private DatabasePlatform databasePlatform() {
        return this.getDatabase().getDatabasePlatform();
    }

    public void postProjectBuild() {
        if (this.databaseTypeName == null) {
            this.databaseType = this.databasePlatform().defaultDatabaseType();
        } else {
            try {
                this.databaseType = this.databasePlatform().databaseTypeNamed(this.databaseTypeName);
            }
            catch (IllegalArgumentException ex) {
                this.databaseType = this.databasePlatform().defaultDatabaseType();
            }
        }
        this.databaseTypeName = null;
    }

    public int compareTo(Object o) {
        return this.databaseType.compareTo(((DatabaseTypeHandle)o).databaseType);
    }

    public void toString(StringBuffer sb) {
        if (this.databaseType == null) {
            sb.append("null");
        } else {
            this.databaseType.toString(sb);
        }
    }

    String getDatabaseTypeNameForTopLink() {
        return this.databaseType == null ? null : this.databaseType.getName();
    }

    void setDatabaseTypeNameForTopLink(String name) {
        this.databaseTypeName = name;
    }
}

