/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToXmlTypeMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.AffixStrippingPartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.ExhaustivePartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public abstract class MWRelationalClassDescriptor
extends MWMappingDescriptor
implements MWRelationalDescriptor {
    private Collection userDefinedQueryKeys;
    public static final String QUERY_KEYS_COLLECTION = "userDefinedQueryKeys";
    protected static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);
    protected static final float PARTIAL_STRING_AFFIX_THRESHOLD = 0.8f;
    protected static final PartialStringComparatorEngine PARTIAL_STRING_COMPARATOR_ENGINE = AffixStrippingPartialStringComparatorEngine.forPrefixStripping(AffixStrippingPartialStringComparatorEngine.forSuffixStripping((PartialStringComparatorEngine)new ExhaustivePartialStringComparatorEngine(PartialStringComparator.DEFAULT_COMPARATOR), 0.8f), 0.8f);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalClassDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWMappingDescriptor.class);
        XMLCompositeCollectionMapping userDefinedQueryKeysMapping = new XMLCompositeCollectionMapping();
        userDefinedQueryKeysMapping.setAttributeName(QUERY_KEYS_COLLECTION);
        userDefinedQueryKeysMapping.setGetMethodName("getUserDefinedQueryKeysForTopLink");
        userDefinedQueryKeysMapping.setSetMethodName("setUserDefinedQueryKeysForTopLink");
        userDefinedQueryKeysMapping.setReferenceClass(MWUserDefinedQueryKey.class);
        userDefinedQueryKeysMapping.setXPath("user-defined-query-keys/user-defined-query-key");
        descriptor.addMapping((DatabaseMapping)userDefinedQueryKeysMapping);
        return descriptor;
    }

    protected MWRelationalClassDescriptor() {
    }

    protected MWRelationalClassDescriptor(MWRelationalProject parent, MWClass type, String name) {
        super(parent, type, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.userDefinedQueryKeys = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.userDefinedQueryKeys;
        synchronized (collection) {
            children.addAll(this.userDefinedQueryKeys);
        }
    }

    public boolean isTableDescriptor() {
        return false;
    }

    public boolean isAggregateDescriptor() {
        return false;
    }

    public boolean isInterfaceDescriptor() {
        return false;
    }

    public Iterator implementors() {
        return NullIterator.instance();
    }

    public Iterator allAssociatedColumns() {
        return new CompositeIterator(new TransformationIterator(this.associatedTables()){

            protected Object transform(Object next) {
                return ((MWTable)next).columns();
            }
        });
    }

    public int allAssociatedColumnsSize() {
        int numColumns = 0;
        Iterator i = this.associatedTables();
        while (i.hasNext()) {
            numColumns += ((MWTable)i.next()).columnsSize();
        }
        return numColumns;
    }

    public Iterator associatedTablesIncludingInherited() {
        return new CompositeIterator(new TransformationIterator(this.inheritanceHierarchy()){

            protected Object transform(Object next) {
                return ((MWRelationalDescriptor)next).associatedTables();
            }
        });
    }

    public int associatedTablesIncludingInheritedSize() {
        return CollectionTools.size(this.associatedTablesIncludingInherited());
    }

    public Iterator candidateTables() {
        if (this.associatedTablesSize() == 0) {
            return this.getDatabase().tables();
        }
        return this.associatedTables();
    }

    public int candidateTablesSize() {
        return CollectionTools.size(this.candidateTables());
    }

    public Iterator candidateTablesIncludingInherited() {
        if (this.associatedTablesIncludingInheritedSize() == 0) {
            return this.getDatabase().tables();
        }
        return this.associatedTablesIncludingInherited();
    }

    public int candidateTablesIncludingInheritedSize() {
        return CollectionTools.size(this.candidateTablesIncludingInherited());
    }

    public MWAggregateDescriptor asMWAggregateDescriptor() {
        MWAggregateDescriptor newDescriptor = ((MWRelationalProject)this.getProject()).addAggregateDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(newDescriptor);
        return newDescriptor;
    }

    public MWTableDescriptor asMWTableDescriptor() throws InterfaceDescriptorCreationException {
        MWTableDescriptor newDescriptor;
        try {
            newDescriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        }
        catch (InterfaceDescriptorCreationException e) {
            throw new RuntimeException(e);
        }
        this.initializeDescriptorAfterMorphing(newDescriptor);
        return newDescriptor;
    }

    public MWInterfaceDescriptor asMWInterfaceDescriptor() throws InterfaceDescriptorCreationException {
        MWInterfaceDescriptor newDescriptor = (MWInterfaceDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(newDescriptor);
        return newDescriptor;
    }

    public void initializeFromMWAggregateDescriptor(MWAggregateDescriptor oldDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(oldDescriptor);
    }

    public void initializeFromMWRelationalClassDescriptor(MWRelationalClassDescriptor oldDescriptor) {
        this.initializeFromMWMappingDescriptor(oldDescriptor);
        Iterator i = oldDescriptor.userDefinedQueryKeys();
        while (i.hasNext()) {
            this.addQueryKey((MWUserDefinedQueryKey)i.next());
        }
    }

    public void initializeFromMWTableDescriptor(MWTableDescriptor oldDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(oldDescriptor);
    }

    public void initializeFromMWInterfaceDescriptor(MWInterfaceDescriptor oldDescriptor) {
        this.initializeFromMWDescriptor(oldDescriptor);
    }

    protected void refreshClass(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(refreshPolicy);
        if (this.getMWClass().isInterface()) {
            this.asMWInterfaceDescriptor();
        }
    }

    public MWMappingFactory mappingFactory() {
        return MWRelationalMappingFactory.instance();
    }

    public MWManyToManyMapping addManyToManyMapping(MWClassAttribute attribute) {
        MWManyToManyMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createManyToManyMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWOneToManyMapping addOneToManyMapping(MWClassAttribute attribute) {
        MWOneToManyMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createOneToManyMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWOneToOneMapping addOneToOneMapping(MWClassAttribute attribute) {
        MWOneToOneMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createOneToOneMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWVariableOneToOneMapping addVariableOneToOneMapping(MWClassAttribute attribute) {
        MWVariableOneToOneMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createVariableOneToOneMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWDirectToXmlTypeMapping addDirectToXmlTypeMapping(MWClassAttribute attribute) {
        MWDirectToXmlTypeMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createDirectToXmlTypeMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWAggregateMapping addAggregateMapping(MWClassAttribute attribute) {
        MWAggregateMapping mapping = ((MWRelationalMappingFactory)this.mappingFactory()).createAggregateMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWUserDefinedQueryKey addQueryKey(String name, MWColumn column) {
        this.checkQueryKeyName(name);
        MWUserDefinedQueryKey queryKey = new MWUserDefinedQueryKey(name, this, column);
        this.addQueryKey(queryKey);
        return queryKey;
    }

    void checkQueryKeyName(String queryKeyName) {
        if (queryKeyName == null || queryKeyName == "") {
            throw new NullPointerException();
        }
        if (this.queryKeyNamed(queryKeyName) != null) {
            throw new IllegalArgumentException(queryKeyName);
        }
    }

    private void addQueryKey(MWUserDefinedQueryKey newQueryKey) {
        this.userDefinedQueryKeys.add(newQueryKey);
        this.fireItemAdded(QUERY_KEYS_COLLECTION, newQueryKey);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public void removeQueryKey(MWUserDefinedQueryKey queryKeyToRemove) {
        this.removeNodeFromCollection(queryKeyToRemove, this.userDefinedQueryKeys, QUERY_KEYS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public Iterator allQueryKeys() {
        return this.getAllQueryKeys().iterator();
    }

    public Iterator allQueryKeysIncludingInherited() {
        return this.getAllQueryKeysIncludingInherited().iterator();
    }

    public Iterator allQueryKeyNames() {
        return new TransformationIterator(this.allQueryKeys()){

            protected Object transform(Object next) {
                return ((MWQueryKey)next).getName();
            }
        };
    }

    public Iterator userDefinedQueryKeys() {
        return new CloneIterator(this.userDefinedQueryKeys);
    }

    public SortedSet getAllQueryKeys() {
        TreeSet result = new TreeSet();
        result.addAll(this.userDefinedQueryKeys);
        result.addAll(this.getAutoGeneratedQueryKeys());
        return result;
    }

    public Collection getAutoGeneratedQueryKeys() {
        ArrayList<MWQueryKey> queryKeys = new ArrayList<MWQueryKey>();
        Iterator i = this.mappings();
        while (i.hasNext()) {
            MWMapping mapping = (MWMapping)i.next();
            MWQueryKey bldrQueryKey = mapping.getAutoGeneratedQueryKey();
            if (bldrQueryKey == null) continue;
            queryKeys.add(bldrQueryKey);
        }
        return queryKeys;
    }

    public Collection getAutoGeneratedQueryKeysIncludingInherited() {
        Collection autoQueryKeys = super.getAutoGeneratedQueryKeysIncludingInherited();
        if (this.getInheritancePolicy().isRoot()) {
            autoQueryKeys = this.getAutoGeneratedQueryKeys();
        } else if (this.getInheritancePolicy().getParentDescriptor() != null) {
            autoQueryKeys = this.getInheritancePolicy().getParentDescriptor().getAutoGeneratedQueryKeysIncludingInherited();
            autoQueryKeys.addAll(this.getAutoGeneratedQueryKeys());
        }
        return autoQueryKeys;
    }

    public Collection getAllQueryKeysIncludingInherited() {
        Collection allQueryKeys = super.getAllQueryKeysIncludingInherited();
        allQueryKeys.addAll(this.getAllQueryKeys());
        if (this.getInheritancePolicy().isActive() && this.getInheritancePolicy().getParentDescriptor() != null) {
            allQueryKeys.addAll(this.getInheritancePolicy().getParentDescriptor().getAllQueryKeysIncludingInherited());
        }
        return allQueryKeys;
    }

    public MWQueryKey queryKeyNamed(String name) {
        Iterator stream = this.allQueryKeys();
        while (stream.hasNext()) {
            MWQueryKey queryKey = (MWQueryKey)stream.next();
            if (!queryKey.getName().equals(name)) continue;
            return queryKey;
        }
        return null;
    }

    public MWQueryKey queryKeyNamedIncludingInherited(String name) {
        Iterator stream = this.allQueryKeysIncludingInherited();
        while (stream.hasNext()) {
            MWQueryKey queryKey = (MWQueryKey)stream.next();
            if (!queryKey.getName().equals(name)) continue;
            return queryKey;
        }
        return null;
    }

    public MWTable getPrimaryTable() {
        return null;
    }

    public MWQueryable queryableNamed(String queryableName) {
        for (MWQueryable queryable : this.getQueryables(Filter.NULL_INSTANCE)) {
            if (!queryable.getName().equals(queryableName)) continue;
            return queryable;
        }
        return null;
    }

    public List getQueryables(Filter queryableFilter) {
        ArrayList<MWModel> queryables = new ArrayList<MWModel>();
        Iterator mappings = this.mappingsIncludingInherited();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            if (!queryableFilter.accept(mapping)) continue;
            queryables.add(mapping);
        }
        Iterator i = this.userDefinedQueryKeys();
        while (i.hasNext()) {
            MWUserDefinedQueryKey key = (MWUserDefinedQueryKey)i.next();
            if (!queryableFilter.accept(key)) continue;
            queryables.add(key);
        }
        return queryables;
    }

    protected MWDescriptorInheritancePolicy buildInheritancePolicy() {
        return new MWRelationalDescriptorInheritancePolicy(this);
    }

    public boolean supportsInterfaceAliasPolicy() {
        return false;
    }

    public boolean supportsMultitablePolicy() {
        return false;
    }

    public void unmap() {
        super.unmap();
        this.fireCollectionChanged(QUERY_KEYS_COLLECTION);
    }

    protected void automapSuperDescriptorInheritance(Collection automapDescriptors) {
        this.automapInheritanceHierarchy(automapDescriptors);
        MWInheritancePolicy ip = this.getInheritancePolicy();
        if (!ip.isActive()) {
            this.addInheritancePolicy();
            ip = this.getInheritancePolicy();
        }
        if (ip.getParentDescriptor() == null) {
            ((MWDescriptorInheritancePolicy)ip).setIsRoot(true);
        }
        if (ip.getParentDescriptor() == null && !this.getMWClass().isAbstract()) {
            MWClassIndicatorFieldPolicy fieldPolicy = (MWClassIndicatorFieldPolicy)ip.getClassIndicatorPolicy();
            MWClassIndicatorValue indicatorValue = fieldPolicy.getClassIndicatorValueForDescriptor(this);
            indicatorValue.setInclude(true);
            indicatorValue.setIndicatorValue(this.getName());
        }
    }

    protected void automapInternal() {
        this.automapUnmappedAttributes();
        this.automapDirectMappingColumns();
        super.automapInternal();
    }

    private void automapUnmappedAttributes() {
        Set attributes = this.allAttributes();
        CollectionTools.removeAll((Collection)attributes, this.mappedAttributes());
        Iterator stream = attributes.iterator();
        while (stream.hasNext()) {
            this.automapUnmappedAttribute((MWClassAttribute)stream.next());
        }
    }

    private Set allAttributes() {
        Set attributes = CollectionTools.set(this.getMWClass().attributes());
        CollectionTools.addAll((Collection)attributes, this.inheritedAttributes());
        CollectionTools.addAll((Collection)attributes, this.getMWClass().ejb20Attributes());
        return attributes;
    }

    private Iterator mappedAttributes() {
        return new TransformationIterator(this.mappings()){

            protected Object transform(Object next) {
                return ((MWMapping)next).getInstanceVariable();
            }
        };
    }

    private void automapUnmappedAttribute(MWClassAttribute attribute) {
        MWDescriptor descriptor;
        MWMethod getMethod;
        if (attribute.getDimensionality() > 0) {
            return;
        }
        MWClass type = attribute.getType();
        if (type.isValueHolder() && (type = attribute.getValueType()).isObject() && (getMethod = attribute.standardValueGetMethod()) != null) {
            type = getMethod.getReturnType();
        }
        if (type.isContainer()) {
            descriptor = this.findReferenceDescriptorForCollectionAttribute(attribute);
            if (descriptor == null) {
                this.automapAsDirectContainerMapping(attribute, type);
            } else {
                this.automapAsCollectionMapping(attribute, descriptor);
            }
        } else {
            descriptor = this.findReferenceDescriptorForType(type);
            if (descriptor != null) {
                this.automapAsReferenceMapping(attribute, descriptor);
            } else {
                this.automapAsDirectMapping(attribute);
            }
        }
    }

    private MWDescriptor findReferenceDescriptorForCollectionAttribute(MWClassAttribute attribute) {
        CollectionStringHolder[] holders = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore shs = this.match(attribute.getName().toLowerCase(), holders);
        if (shs.getScore() < 0.8) {
            return null;
        }
        String packageName = this.packageName();
        MWDescriptor descriptor = null;
        Iterator stream = ((CollectionStringHolder)shs.getStringHolder()).iterator();
        while (stream.hasNext()) {
            descriptor = (MWDescriptor)stream.next();
            if (!descriptor.packageName().equals(packageName)) continue;
            return descriptor;
        }
        return descriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        HashMap<String, CollectionStringHolder> holders = new HashMap<String, CollectionStringHolder>(this.getProject().descriptorsSize());
        Iterator stream = this.getProject().descriptors();
        while (stream.hasNext()) {
            MWDescriptor descriptor = (MWDescriptor)stream.next();
            String shortName = descriptor.shortName().toLowerCase();
            CollectionStringHolder holder = (CollectionStringHolder)holders.get(shortName);
            if (holder == null) {
                holder = new CollectionStringHolder(shortName);
                holders.put(shortName, holder);
            }
            holder.add(descriptor);
        }
        return holders.values().toArray(new CollectionStringHolder[holders.size()]);
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] multiDescriptorStringHolders) {
        return PARTIAL_STRING_MATCHER.match(string, multiDescriptorStringHolders);
    }

    private void automapAsDirectContainerMapping(MWClassAttribute attribute, MWClass type) {
        if (type.isAssignableToCollection()) {
            this.addDirectCollectionMapping(attribute);
        } else {
            this.addDirectMapMapping(attribute);
        }
    }

    private void automapAsCollectionMapping(MWClassAttribute attribute, MWDescriptor referenceDescriptor) {
        MWOneToManyMapping mapping = this.addOneToManyMapping(attribute);
        mapping.setReferenceDescriptor(referenceDescriptor);
    }

    private MWDescriptor findReferenceDescriptorForType(MWClass type) {
        MWDescriptor descriptor = this.getProject().descriptorForType(type);
        if (descriptor != null) {
            return descriptor;
        }
        if (type.isInterface()) {
            Iterator stream = this.getProject().descriptors();
            while (stream.hasNext()) {
                descriptor = (MWDescriptor)stream.next();
                if (!descriptor.getMWClass().isAssignableTo(type)) continue;
                return descriptor;
            }
        }
        return null;
    }

    private void automapAsReferenceMapping(MWClassAttribute attribute, MWDescriptor referenceDescriptor) {
        MWRelationalDescriptor relationalDescriptor = (MWRelationalDescriptor)((Object)referenceDescriptor);
        if (relationalDescriptor.isInterfaceDescriptor()) {
            MWAbstractReferenceMapping mapping;
            MWClass referenceInterface = relationalDescriptor.getMWClass();
            int numImplementors = 0;
            MWDescriptor implementorDescriptor = null;
            Iterator stream = this.getProject().descriptors();
            while (stream.hasNext()) {
                MWDescriptor descriptor = (MWDescriptor)stream.next();
                if (descriptor == referenceDescriptor || !descriptor.getMWClass().allInterfacesContains(referenceInterface)) continue;
                implementorDescriptor = descriptor;
                ++numImplementors;
            }
            if (numImplementors == 1) {
                mapping = this.addOneToOneMapping(attribute);
                mapping.setReferenceDescriptor(implementorDescriptor);
            } else {
                mapping = this.addVariableOneToOneMapping(attribute);
                mapping.setReferenceDescriptor(referenceDescriptor);
            }
        } else if (relationalDescriptor.isAggregateDescriptor()) {
            MWAggregateMapping mapping = this.addAggregateMapping(attribute);
            mapping.setReferenceDescriptor(referenceDescriptor);
        } else if (relationalDescriptor.isTableDescriptor()) {
            MWOneToOneMapping mapping = this.addOneToOneMapping(attribute);
            mapping.setReferenceDescriptor(referenceDescriptor);
        }
    }

    private void automapAsDirectMapping(MWClassAttribute attribute) {
        this.addDirectMapping(attribute);
    }

    protected void automapDirectMappingColumns() {
    }

    public Collection buildAggregateFieldNameGenerators() {
        ArrayList<MWUserDefinedQueryKey> generators = new ArrayList<MWUserDefinedQueryKey>();
        if (this.getInheritancePolicy().isRoot()) {
            this.getInheritancePolicy().getClassIndicatorPolicy().addToAggregateFieldNameGenerators(generators);
        } else if (this.getInheritancePolicy().getParentDescriptor() != null) {
            generators.addAll(((MWRelationalDescriptor)((Object)this.getInheritancePolicy().getParentDescriptor())).buildAggregateFieldNameGenerators());
        }
        Iterator i = this.userDefinedQueryKeys();
        while (i.hasNext()) {
            MWUserDefinedQueryKey queryKey = (MWUserDefinedQueryKey)i.next();
            generators.add(queryKey);
        }
        return generators;
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor runtimeDescriptor = super.buildRuntimeDescriptor();
        this.adjustUserDefinedQueryKeys(runtimeDescriptor);
        return runtimeDescriptor;
    }

    protected abstract void adjustUserDefinedQueryKeys(ClassDescriptor var1);

    private Collection getUserDefinedQueryKeysForTopLink() {
        return CollectionTools.sort((List)this.userDefinedQueryKeys);
    }

    private void setUserDefinedQueryKeysForTopLink(Collection userDefinedQueryKeys) {
        this.userDefinedQueryKeys = userDefinedQueryKeys;
    }
}

