/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWReferenceHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWManyToManyMapping
extends MWCollectionMapping {
    private MWReferenceHandle targetReferenceHandle;
    public static final String TARGET_REFERENCE_PROPERTY = "targetReference";
    private MWTableHandle relationTableHandle;
    public static final String RELATION_TABLE_PROPERTY = "relationTable";

    private MWManyToManyMapping() {
    }

    MWManyToManyMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.targetReferenceHandle = new MWReferenceHandle(this, this.buildTargetReferenceScrubber());
        this.relationTableHandle = new MWTableHandle(this, this.buildRelationTableScrubber());
    }

    public MWTable getRelationTable() {
        return this.relationTableHandle.getTable();
    }

    public void setRelationTable(MWTable newValue) {
        MWTable oldValue = this.relationTableHandle.getTable();
        this.relationTableHandle.setTable(newValue);
        this.firePropertyChanged(RELATION_TABLE_PROPERTY, oldValue, newValue);
    }

    public void setSourceReference(MWReference ref) {
        this.setReference(ref);
    }

    public MWReference getSourceReference() {
        return this.getReference();
    }

    public MWReference getTargetReference() {
        return this.targetReferenceHandle.getReference();
    }

    public void setTargetReference(MWReference newValue) {
        MWReference oldValue = this.getTargetReference();
        this.targetReferenceHandle.setReference(newValue);
        this.firePropertyChanged(TARGET_REFERENCE_PROPERTY, oldValue, newValue);
    }

    public boolean isManyToManyMapping() {
        return true;
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWManyToManyMapping(this);
    }

    public MWManyToManyMapping asMWManyToManyMapping() {
        return this;
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.targetReferenceHandle);
        children.add(this.relationTableHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTargetReferenceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWManyToManyMapping.this.setTargetReference(null);
            }

            public String toString() {
                return "MWManyToManyMapping.buildTargetReferenceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildRelationTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWManyToManyMapping.this.setRelationTable(null);
            }

            public String toString() {
                return "MWManyToManyMapping.buildRelationTableScrubber()";
            }
        };
    }

    public String iconKey() {
        return "mapping.manyToMany";
    }

    public void automap() {
        super.automap();
        this.automapRelationTable();
        this.automapSourceReference();
        this.automapTargetReference();
    }

    protected void automapTableReference() {
    }

    private void automapRelationTable() {
        if (this.getRelationTable() != null) {
            return;
        }
        Iterator tables = this.candidateRelationTables();
        if (tables.hasNext()) {
            this.setRelationTable((MWTable)tables.next());
        }
    }

    private void automapSourceReference() {
        if (this.getSourceReference() != null) {
            return;
        }
        Iterator references = this.candidateRelationTableSourceReferences();
        if (references.hasNext()) {
            this.setSourceReference((MWReference)references.next());
        }
    }

    private void automapTargetReference() {
        if (this.getTargetReference() != null) {
            return;
        }
        Iterator stream = this.candidateRelationTableTargetReferences();
        if (stream.hasNext()) {
            this.setTargetReference((MWReference)stream.next());
        }
    }

    protected Set buildCandidateReferences() {
        HashSet references = new HashSet();
        references.addAll(this.buildCandidateRelationTableSourceReferences());
        references.addAll(this.buildCandidateRelationTableTargetReferences());
        return references;
    }

    public Iterator candidateRelationTables() {
        MWTableDescriptor sourceDescriptor = (MWTableDescriptor)this.getParentDescriptor();
        MWTableDescriptor referenceDescriptor = (MWTableDescriptor)this.getReferenceDescriptor();
        if (referenceDescriptor == null) {
            return this.getProject().getDatabase().tables();
        }
        Set sourceTables = CollectionTools.set(sourceDescriptor.associatedTables());
        Set targetTables = CollectionTools.set(referenceDescriptor.associatedTables());
        ArrayList<MWTable> candidateRelationTables = new ArrayList<MWTable>();
        Iterator stream = this.unmappedTables();
        while (stream.hasNext()) {
            MWTable unmappedTable = (MWTable)stream.next();
            if (!this.tableIsPossibleRelationTable(unmappedTable, sourceTables, targetTables)) continue;
            candidateRelationTables.add(unmappedTable);
        }
        return candidateRelationTables.iterator();
    }

    private Set buildCandidateRelationTableSourceReferences() {
        MWTable relationTable = this.getRelationTable();
        if (relationTable == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> references = new HashSet<MWReference>();
        Set targetTables = CollectionTools.set(this.getParentRelationalDescriptor().candidateTablesIncludingInherited());
        Iterator stream = relationTable.references();
        while (stream.hasNext()) {
            MWReference reference = (MWReference)stream.next();
            if (!targetTables.contains(reference.getTargetTable())) continue;
            references.add(reference);
        }
        return references;
    }

    public Iterator candidateRelationTableSourceReferences() {
        return this.buildCandidateRelationTableSourceReferences().iterator();
    }

    private Set buildCandidateRelationTableTargetReferences() {
        MWTable relationTable = this.getRelationTable();
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (relationTable == null || referenceDescriptor == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<MWReference> references = new HashSet<MWReference>();
        Set targetTables = CollectionTools.set(referenceDescriptor.candidateTablesIncludingInherited());
        Iterator stream = relationTable.references();
        while (stream.hasNext()) {
            MWReference reference = (MWReference)stream.next();
            if (!targetTables.contains(reference.getTargetTable())) continue;
            references.add(reference);
        }
        return references;
    }

    public Iterator candidateRelationTableTargetReferences() {
        return this.buildCandidateRelationTableTargetReferences().iterator();
    }

    public boolean tableIsPossibleRelationTable(MWTable table) {
        return CollectionTools.contains(this.candidateRelationTables(), (Object)table);
    }

    private Iterator unmappedTables() {
        Set tables = CollectionTools.set(this.getDatabase().tables());
        Iterator stream = this.getProject().descriptors();
        while (stream.hasNext()) {
            MWRelationalDescriptor descriptor = (MWRelationalDescriptor)stream.next();
            CollectionTools.removeAll((Collection)tables, descriptor.associatedTables());
        }
        return tables.iterator();
    }

    private boolean tableIsPossibleRelationTable(MWTable unmappedTable, Set sourceTables, Set targetTables) {
        boolean sourceFound = false;
        boolean targetFound = false;
        Iterator references = unmappedTable.references();
        while (references.hasNext()) {
            MWReference reference = (MWReference)references.next();
            boolean workingWithSource = false;
            boolean workingWithTarget = false;
            if (!sourceFound && sourceTables.contains(reference.getTargetTable())) {
                workingWithSource = true;
            }
            if (!targetFound && targetTables.contains(reference.getTargetTable())) {
                workingWithTarget = true;
            }
            if (!workingWithSource && !workingWithTarget) continue;
            boolean allTargetColumnsHaveUniqueConstraint = true;
            Iterator columnPairs = reference.columnPairs();
            while (columnPairs.hasNext()) {
                MWColumnPair columnPair = (MWColumnPair)columnPairs.next();
                MWColumn targetColumn = columnPair.getTargetColumn();
                allTargetColumnsHaveUniqueConstraint &= targetColumn.isUnique();
            }
            if (allTargetColumnsHaveUniqueConstraint) {
                if (workingWithSource) {
                    sourceFound = true;
                }
                if (workingWithTarget) {
                    targetFound = true;
                }
            }
            if (!sourceFound || !targetFound) continue;
            return true;
        }
        return false;
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.addRelationTableNotSpecifiedProblemTo(newProblems);
        this.addRelationTableNotDedicatedProblemTo(newProblems);
        this.addSourceReferenceNotSpecifiedProblemTo(newProblems);
        this.addTargetReferenceNotSpecifiedProblemTo(newProblems);
    }

    private void addRelationTableNotSpecifiedProblemTo(List newProblems) {
        if (this.getRelationTable() == null) {
            newProblems.add(this.buildProblem("0480"));
        }
    }

    private void addRelationTableNotDedicatedProblemTo(List newProblems) {
        if (this.isReadOnly()) {
            return;
        }
        Iterator mappings = ((MWRelationalProject)this.getProject()).allWriteableManyToManyMappings();
        while (mappings.hasNext()) {
            MWManyToManyMapping mapping = (MWManyToManyMapping)mappings.next();
            if (mapping == this || mapping.getRelationTable() != this.getRelationTable() || mapping.getParentRelationalDescriptor().getPrimaryTable() == null || mapping.getParentRelationalDescriptor().getPrimaryTable() == this.getParentRelationalDescriptor().getPrimaryTable()) continue;
            newProblems.add(this.buildProblem("0481"));
        }
    }

    private void addSourceReferenceNotSpecifiedProblemTo(List newProblems) {
        if (this.getSourceReference() == null) {
            newProblems.add(this.buildProblem("0482"));
        }
    }

    private void addTargetReferenceNotSpecifiedProblemTo(List newProblems) {
        if (this.getTargetReference() == null) {
            newProblems.add(this.buildProblem("0483"));
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new ManyToManyMapping();
    }

    public DatabaseMapping runtimeMapping() {
        MWColumn targetColumn;
        MWColumn sourceColumn;
        MWColumnPair pair;
        Iterator stream;
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)super.runtimeMapping();
        MWTable relationTable = this.getRelationTable();
        if (relationTable != null) {
            manyToManyMapping.setRelationTableName(relationTable.getName());
        }
        if (this.getSourceReference() != null) {
            stream = this.getSourceReference().columnPairs();
            while (stream.hasNext()) {
                pair = (MWColumnPair)stream.next();
                sourceColumn = pair.getSourceColumn();
                targetColumn = pair.getTargetColumn();
                if (sourceColumn == null || targetColumn == null) continue;
                if (!this.parentDescriptorIsAggregate()) {
                    manyToManyMapping.addSourceRelationKeyFieldName(sourceColumn.qualifiedName(), targetColumn.qualifiedName());
                    continue;
                }
                manyToManyMapping.addSourceRelationKeyFieldName(sourceColumn.qualifiedName(), this.getName() + "->" + targetColumn.getName() + "_IN_REFERENCE_" + this.getSourceReference().getName());
            }
        }
        if (this.getTargetReference() != null) {
            stream = this.getTargetReference().columnPairs();
            while (stream.hasNext()) {
                pair = (MWColumnPair)stream.next();
                sourceColumn = pair.getSourceColumn();
                targetColumn = pair.getTargetColumn();
                if (sourceColumn == null || targetColumn == null) continue;
                manyToManyMapping.addTargetRelationKeyFieldName(sourceColumn.qualifiedName(), targetColumn.qualifiedName());
            }
        }
        return manyToManyMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWManyToManyMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWCollectionMapping.class);
        XMLCompositeObjectMapping relationTableMapping = new XMLCompositeObjectMapping();
        relationTableMapping.setAttributeName("relationTableHandle");
        relationTableMapping.setGetMethodName("getRelationTableHandleForTopLink");
        relationTableMapping.setSetMethodName("setRelationTableHandleForTopLink");
        relationTableMapping.setReferenceClass(MWTableHandle.class);
        relationTableMapping.setXPath("relation-table-handle");
        descriptor.addMapping((DatabaseMapping)relationTableMapping);
        XMLCompositeObjectMapping targetReferenceHandleMapping = new XMLCompositeObjectMapping();
        targetReferenceHandleMapping.setAttributeName("targetReferenceHandle");
        targetReferenceHandleMapping.setGetMethodName("getTargetReferenceHandleForTopLink");
        targetReferenceHandleMapping.setSetMethodName("setTargetReferenceHandleForTopLink");
        targetReferenceHandleMapping.setReferenceClass(MWReferenceHandle.class);
        targetReferenceHandleMapping.setXPath("target-reference-handle");
        descriptor.addMapping((DatabaseMapping)targetReferenceHandleMapping);
        return descriptor;
    }

    private MWTableHandle getRelationTableHandleForTopLink() {
        return this.relationTableHandle.getTable() == null ? null : this.relationTableHandle;
    }

    private void setRelationTableHandleForTopLink(MWTableHandle relationTableHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildRelationTableScrubber();
        this.relationTableHandle = relationTableHandle == null ? new MWTableHandle(this, scrubber) : relationTableHandle.setScrubber(scrubber);
    }

    private MWReferenceHandle getTargetReferenceHandleForTopLink() {
        return this.targetReferenceHandle.getReference() == null ? null : this.targetReferenceHandle;
    }

    private void setTargetReferenceHandleForTopLink(MWReferenceHandle targetReferenceHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTargetReferenceScrubber();
        this.targetReferenceHandle = targetReferenceHandle == null ? new MWReferenceHandle(this, scrubber) : targetReferenceHandle.setScrubber(scrubber);
    }
}

