/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXpathedMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractAnyMapping
extends MWMapping
implements MWXmlMapping,
MWXpathedMapping,
MWXpathContext {
    private MWXmlField xmlField;
    private volatile boolean wildcardMapping;
    public static final String WILDCARD_PROPERTY = "wildcardMapping";

    protected MWAbstractAnyMapping() {
    }

    protected MWAbstractAnyMapping(MWXmlDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.xmlField = new MWXmlField(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.xmlField);
    }

    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    public boolean isWildcardMapping() {
        return this.wildcardMapping;
    }

    public void setWildcardMapping(boolean newValue) {
        boolean oldValue = this.wildcardMapping;
        this.wildcardMapping = newValue;
        this.firePropertyChanged(WILDCARD_PROPERTY, oldValue, newValue);
    }

    public MWSchemaContextComponent schemaContext() {
        return this.oxDescriptor().getSchemaContext();
    }

    public MWXmlField firstMappedXmlField() {
        if (this.getXmlField().isResolved()) {
            return this.getXmlField();
        }
        return null;
    }

    public void addWrittenFieldsTo(Collection writtenFields) {
        if (!this.isReadOnly() && !this.getXmlField().getXpath().equals("")) {
            writtenFields.add(this.getXmlField());
        }
    }

    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.schemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return MWAbstractAnyMapping.this.mayUseCollectionData();
            }

            public boolean mayUseComplexData() {
                return true;
            }

            public boolean mayUseSimpleData() {
                return false;
            }
        };
    }

    protected abstract boolean mayUseCollectionData();

    protected MWOXDescriptor oxDescriptor() {
        return (MWOXDescriptor)this.getParent();
    }

    protected void initializeFromMWXpathedMapping(MWXpathedMapping oldMapping) {
        super.initializeFromMWXpathedMapping(oldMapping);
        this.getXmlField().setXpath(oldMapping.getXmlField().getXpath());
    }

    protected void addProblemsTo(List newProblems) {
        this.addXmlFieldProblemsTo(newProblems);
        this.addWildcardProblemsTo(newProblems);
        super.addProblemsTo(newProblems);
    }

    protected void addXmlFieldProblemsTo(List newProblems) {
        if (!this.oxDescriptor().isAnyTypeDescriptor()) {
            this.addXpathNotSpecifiedProblemTo(newProblems);
        }
    }

    private void addXpathNotSpecifiedProblemTo(List newProblems) {
        if (!this.oxDescriptor().isAnyTypeDescriptor() && !this.getXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0810"));
        }
    }

    private void addWildcardProblemsTo(List newProblems) {
        this.addWildcardSpecifiedProblemTo(newProblems);
        this.addNoWildcardInSchemaContextProblemTo(newProblems);
        this.addMapsToNonAttributesProblemTo(newProblems);
    }

    private void addWildcardSpecifiedProblemTo(List newProblems) {
        if (this.oxDescriptor().isAnyTypeDescriptor() && this.isWildcardMapping()) {
            newProblems.add(this.buildProblem("0621"));
        }
    }

    private void addNoWildcardInSchemaContextProblemTo(List newProblems) {
        MWSchemaContextComponent context;
        if (this.isWildcardMapping() && (context = this.schemaContext()) != null && !context.containsWildcard()) {
            newProblems.add(this.buildProblem("0622"));
        }
    }

    private void addMapsToNonAttributesProblemTo(List newProblems) {
    }

    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange change) {
        this.xmlField.schemaChanged(change);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractAnyMapping.class);
        descriptor.descriptorIsAggregate();
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xpath");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        ((XMLDirectMapping)descriptor.addDirectMapping(WILDCARD_PROPERTY, "wildcard-mapping/text()")).setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField xmlField) {
        this.xmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

