/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWEisReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisOneToManyMapping
extends MWEisReferenceMapping
implements MWIndirectableContainerMapping,
MWXpathContext,
MWMapContainerMapping {
    private volatile String foreignKeyLocation;
    public static final String FOREIGN_KEY_LOCATION_PROPERTY = "foreignKeyLocation";
    public static final String KEYS_ON_TARGET = "keysOnTarget";
    public static final String KEYS_ON_SOURCE = "keysOnSource";
    private MWXmlField foreignKeyGroupingElement;
    private volatile MWContainerPolicy containerPolicy;
    private volatile MWEisInteraction deleteAllInteraction;

    private MWEisOneToManyMapping() {
    }

    public MWEisOneToManyMapping(MWEisDescriptor descriptor, MWClassAttribute attribute, String attributeName) {
        super(descriptor, attribute, attributeName);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.foreignKeyLocation = KEYS_ON_TARGET;
        this.foreignKeyGroupingElement = new MWXmlField(this);
        this.deleteAllInteraction = new MWEisInteraction(this);
    }

    protected boolean requiresSelectionInteraction() {
        return true;
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (attribute.isValueHolder()) {
            this.containerPolicy = attribute.getValueType().isAssignableToMap() ? new MWMapContainerPolicy(this) : (attribute.getValueType().isAssignableToList() ? new MWListContainerPolicy(this) : (attribute.getValueType().isAssignableToSet() ? new MWSetContainerPolicy(this) : (attribute.getValueType().isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
            this.setUseValueHolderIndirection();
        } else {
            this.containerPolicy = attribute.isAssignableToMap() ? new MWMapContainerPolicy(this) : (attribute.isAssignableToList() ? new MWListContainerPolicy(this) : (attribute.isAssignableToSet() ? new MWSetContainerPolicy(this) : (attribute.isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this))));
            this.setUseTransparentIndirection();
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.foreignKeyGroupingElement);
        children.add(this.containerPolicy);
        children.add(this.deleteAllInteraction);
    }

    public boolean foreignKeysAreOnSource() {
        return this.foreignKeyLocation == KEYS_ON_SOURCE;
    }

    public boolean foreignKeysAreOnTarget() {
        return this.foreignKeyLocation == KEYS_ON_TARGET;
    }

    public void setForeignKeysOnSource() {
        this.setForeignKeyLocation(KEYS_ON_SOURCE);
    }

    public void setForeignKeysOnTarget() {
        this.setForeignKeyLocation(KEYS_ON_TARGET);
        this.getForeignKeyGroupingElement().setXpath("");
        this.clearXmlFieldPairs();
    }

    private void setForeignKeyLocation(String newValue) {
        String oldValue = this.foreignKeyLocation;
        this.foreignKeyLocation = newValue;
        this.firePropertyChanged(FOREIGN_KEY_LOCATION_PROPERTY, oldValue, newValue);
    }

    public MWXmlField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public MWContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    private void setContainerPolicy(MWContainerPolicy containerPolicy) {
        MWContainerPolicy oldValue = this.containerPolicy;
        this.containerPolicy = containerPolicy;
        this.firePropertyChanged("containerPolicy", oldValue, containerPolicy);
    }

    public MWMapContainerPolicy setMapContainerPolicy() {
        if (this.containerPolicy instanceof MWMapContainerPolicy) {
            return (MWMapContainerPolicy)this.containerPolicy;
        }
        MWMapContainerPolicy cp = new MWMapContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWCollectionContainerPolicy setCollectionContainerPolicy() {
        if (this.containerPolicy instanceof MWCollectionContainerPolicy) {
            return (MWCollectionContainerPolicy)this.containerPolicy;
        }
        MWCollectionContainerPolicy cp = new MWCollectionContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWListContainerPolicy setListContainerPolicy() {
        if (this.containerPolicy instanceof MWListContainerPolicy) {
            return (MWListContainerPolicy)this.containerPolicy;
        }
        MWListContainerPolicy cp = new MWListContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public MWSetContainerPolicy setSetContainerPolicy() {
        if (this.containerPolicy instanceof MWSetContainerPolicy) {
            return (MWSetContainerPolicy)this.containerPolicy;
        }
        MWSetContainerPolicy cp = new MWSetContainerPolicy(this);
        this.setContainerPolicy(cp);
        return cp;
    }

    public Iterator candidateKeyMethods(Filter keyMethodFilter) {
        return this.getReferenceDescriptor() == null ? NullIterator.instance() : new FilteringIterator(this.getReferenceDescriptor().getMWClass().allInstanceMethods(), keyMethodFilter);
    }

    public MWEisInteraction getDeleteAllInteraction() {
        return this.deleteAllInteraction;
    }

    public MWXmlField firstMappedXmlField() {
        return this.getForeignKeyGroupingElement().isResolved() ? this.getForeignKeyGroupingElement() : super.firstMappedXmlField();
    }

    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.eisDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return true;
            }

            public boolean mayUseComplexData() {
                return true;
            }

            public boolean mayUseSimpleData() {
                return false;
            }
        };
    }

    public boolean sourceFieldMayUseCollectionXpath() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return this.getIndirectionType() == "transparentIndirection";
    }

    public void setUseTransparentIndirection() {
        this.setIndirectionType("transparentIndirection");
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkFieldPairs(newProblems);
        this.checkGroupingElement(newProblems);
        this.checkGroupingElementForeignKeys(newProblems);
        this.checkSelectionInteraction(newProblems);
        this.checkDeleteAllInteraction(newProblems);
        this.addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(newProblems);
    }

    private void checkFieldPairs(List newProblems) {
        if (this.foreignKeysAreOnSource() && this.xmlFieldPairsSize() == 0) {
            newProblems.add(this.buildProblem("0600"));
        }
    }

    private void checkGroupingElement(List newProblems) {
        if (this.xmlFieldPairsSize() > 1 && this.getForeignKeyGroupingElement() == null) {
            newProblems.add(this.buildProblem("0601"));
        }
    }

    private void checkGroupingElementForeignKeys(List newProblems) {
        MWXmlField groupingElement = this.getForeignKeyGroupingElement();
        if (!groupingElement.isSpecified() || !groupingElement.isResolved()) {
            return;
        }
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            MWXmlField foreignKeyField = ((MWXmlFieldPair)stream.next()).getSourceXmlField();
            if (!foreignKeyField.isSpecified() || groupingElement.containsXmlField(foreignKeyField)) continue;
            newProblems.add(this.buildProblem("0602"));
            break;
        }
    }

    private void checkSelectionInteraction(List newProblems) {
        if (!this.getSelectionInteraction().isSpecified()) {
            newProblems.add(this.buildProblem("0603"));
        }
    }

    private void checkDeleteAllInteraction(List newProblems) {
        if (this.getDeleteAllInteraction().isSpecified() && !this.isPrivateOwned()) {
            newProblems.add(this.buildProblem("0604"));
        }
    }

    private void addUsesTransparentIndirectionWhileMaintainsBiDirectionalRelationship(List newProblems) {
        if (this.maintainsBidirectionalRelationship() && (this.usesNoIndirection() || this.usesValueHolderIndirection())) {
            newProblems.add(this.buildProblem("0469"));
        }
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWEisOneToManyMapping(this);
    }

    public void initializeFromMWCompositeCollectionMapping(MWCompositeCollectionMapping oldMapping) {
        super.initializeFromMWCompositeCollectionMapping(oldMapping);
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping oldMapping) {
        super.initializeFromMWIndirectableContainerMapping(oldMapping);
        if (oldMapping.usesTransparentIndirection()) {
            this.setUseTransparentIndirection();
        }
    }

    public void resolveXpaths() {
        super.resolveXpaths();
        this.foreignKeyGroupingElement.resolveXpaths();
    }

    public void schemaChanged(SchemaChange change) {
        super.schemaChanged(change);
        this.foreignKeyGroupingElement.schemaChanged(change);
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new EISOneToManyMapping();
    }

    public DatabaseMapping runtimeMapping() {
        EISOneToManyMapping mapping = (EISOneToManyMapping)super.runtimeMapping();
        if (this.getForeignKeyGroupingElement().isSpecified()) {
            mapping.setForeignKeyGroupingElement(this.getForeignKeyGroupingElement().runtimeField().getName());
        }
        ListIterator stream = this.xmlFieldPairs();
        while (stream.hasNext()) {
            ((MWXmlFieldPair)stream.next()).addRuntimeForeignKeyField(mapping, this.getForeignKeyGroupingElement());
        }
        if (this.usesTransparentIndirection()) {
            mapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        }
        mapping.setContainerPolicy(this.getContainerPolicy().runtimeContainerPolicy());
        if (this.getDeleteAllInteraction().isSpecified()) {
            mapping.setDeleteAllCall((Call)this.getDeleteAllInteraction().runtimeInteraction());
        }
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWEisOneToManyMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWEisReferenceMapping.class);
        ObjectTypeConverter foreignKeyLocationConverter = new ObjectTypeConverter();
        foreignKeyLocationConverter.addConversionValue((Object)KEYS_ON_TARGET, (Object)KEYS_ON_TARGET);
        foreignKeyLocationConverter.addConversionValue((Object)KEYS_ON_SOURCE, (Object)KEYS_ON_SOURCE);
        XMLDirectMapping foreignKeyLocationMapping = new XMLDirectMapping();
        foreignKeyLocationMapping.setAttributeName(FOREIGN_KEY_LOCATION_PROPERTY);
        foreignKeyLocationMapping.setXPath("foreign-key-location/text()");
        foreignKeyLocationMapping.setNullValue((Object)KEYS_ON_SOURCE);
        foreignKeyLocationMapping.setConverter((Converter)foreignKeyLocationConverter);
        descriptor.addMapping((DatabaseMapping)foreignKeyLocationMapping);
        XMLCompositeObjectMapping groupingElementMapping = new XMLCompositeObjectMapping();
        groupingElementMapping.setAttributeName("foreignKeyGroupingElement");
        groupingElementMapping.setReferenceClass(MWXmlField.class);
        groupingElementMapping.setGetMethodName("getGroupingElementForTopLink");
        groupingElementMapping.setSetMethodName("setGroupingElementForTopLink");
        groupingElementMapping.setXPath("foreign-key-grouping-element");
        descriptor.addMapping((DatabaseMapping)groupingElementMapping);
        XMLCompositeObjectMapping containerPolicyMapping = new XMLCompositeObjectMapping();
        containerPolicyMapping.setAttributeName("containerPolicy");
        containerPolicyMapping.setReferenceClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        containerPolicyMapping.setXPath("container-policy");
        descriptor.addMapping((DatabaseMapping)containerPolicyMapping);
        XMLCompositeObjectMapping deleteAllInteractionMapping = new XMLCompositeObjectMapping();
        deleteAllInteractionMapping.setAttributeName("deleteAllInteraction");
        deleteAllInteractionMapping.setReferenceClass(MWEisInteraction.class);
        deleteAllInteractionMapping.setXPath("delete-all-interaction");
        descriptor.addMapping((DatabaseMapping)deleteAllInteractionMapping);
        return descriptor;
    }

    private MWXmlField getGroupingElementForTopLink() {
        return "".equals(this.foreignKeyGroupingElement.getXpath()) ? null : this.foreignKeyGroupingElement;
    }

    private void setGroupingElementForTopLink(MWXmlField xmlField) {
        this.foreignKeyGroupingElement = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

