/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWContainerAccessor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodContainerAccessor
extends MWContainerAccessor {
    private MWMethodHandle accessorGetMethodHandle;
    public static final String ACCESSOR_GET_METHOD_PROPERTY = "accessorGetMethod";
    private MWMethodHandle accessorSetMethodHandle;
    public static final String ACCESSOR_SET_METHOD_PROPERTY = "accessorSetMethodHandle";

    public MWMethodContainerAccessor() {
    }

    public MWMethodContainerAccessor(MWNode parent, MWMethod getMethod, MWMethod setMethod) {
        super(parent);
        this.setAccessorGetMethod(getMethod);
        this.setAccessorSetMethod(setMethod);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.accessorGetMethodHandle = new MWMethodHandle(this, this.buildGetMethodScrubber());
        this.accessorSetMethodHandle = new MWMethodHandle(this, this.buildSetMethodScrubber());
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addGetMethodNotSelectedProblemToList(currentProblems);
        this.addSetMethodNotSelectedProblemToList(currentProblems);
    }

    private void addGetMethodNotSelectedProblemToList(List currentProblems) {
        if (this.getAccessorGetMethod() == null) {
            this.buildProblem("0632");
        }
    }

    private void addSetMethodNotSelectedProblemToList(List currentProblems) {
        if (this.getAccessorSetMethod() == null) {
            this.buildProblem("0633");
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.accessorGetMethodHandle);
        children.add(this.accessorSetMethodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildGetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMethodContainerAccessor.this.setAccessorGetMethod(null);
            }

            public String toString() {
                return "MWMethodContainerAccessor.buildGetMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMethodContainerAccessor.this.setAccessorSetMethod(null);
            }

            public String toString() {
                return "MWMethodContainerAccessor.buildSetMethodScrubber()";
            }
        };
    }

    public MWMethod getAccessorGetMethod() {
        return this.accessorGetMethodHandle.getMethod();
    }

    public void setAccessorGetMethod(MWMethod newAccessorMethod) {
        MWMethod oldAccessorMethod = this.getAccessorGetMethod();
        this.accessorGetMethodHandle.setMethod(newAccessorMethod);
        if (this.attributeValueHasChanged(oldAccessorMethod, newAccessorMethod)) {
            this.firePropertyChanged(ACCESSOR_GET_METHOD_PROPERTY, oldAccessorMethod, newAccessorMethod);
            this.firePropertyChanged("containerAccessor", oldAccessorMethod, newAccessorMethod);
        }
    }

    public MWMethod getAccessorSetMethod() {
        return this.accessorSetMethodHandle.getMethod();
    }

    public void setAccessorSetMethod(MWMethod newAccessorMethod) {
        MWMethod oldAccessorMethod = this.getAccessorSetMethod();
        this.accessorSetMethodHandle.setMethod(newAccessorMethod);
        if (this.attributeValueHasChanged(oldAccessorMethod, newAccessorMethod)) {
            this.firePropertyChanged(ACCESSOR_SET_METHOD_PROPERTY, oldAccessorMethod, newAccessorMethod);
            this.firePropertyChanged("containerAccessor", oldAccessorMethod, newAccessorMethod);
        }
    }

    public String accessorDisplayString() {
        MWMethod getMethod = this.getAccessorGetMethod();
        MWMethod setMethod = this.getAccessorSetMethod();
        String displayString = "";
        if (getMethod != null) {
            displayString = displayString + getMethod.displayString();
        }
        if (setMethod != null) {
            displayString = displayString + "/";
            displayString = displayString + setMethod.displayString();
        }
        return displayString;
    }

    public void adjustRuntimeMapping(AbstractCompositeObjectMapping mapping) {
        ((XMLCompositeObjectMapping)mapping).setContainerGetMethodName(this.getAccessorGetMethod().getName());
        ((XMLCompositeObjectMapping)mapping).setContainerSetMethodName(this.getAccessorSetMethod().getName());
    }

    public void adjustRuntimeMapping(AbstractCompositeCollectionMapping mapping) {
        ((XMLCompositeCollectionMapping)mapping).setContainerGetMethodName(this.getAccessorGetMethod().getName());
        ((XMLCompositeCollectionMapping)mapping).setContainerSetMethodName(this.getAccessorSetMethod().getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMethodContainerAccessor.class);
        descriptor.getInheritancePolicy().setParentClass(MWContainerAccessor.class);
        XMLCompositeObjectMapping getMethodHandleMapping = new XMLCompositeObjectMapping();
        getMethodHandleMapping.setAttributeName("accessorGetMethodHandle");
        getMethodHandleMapping.setGetMethodName("getAccessorGetMethodHandleForTopLink");
        getMethodHandleMapping.setSetMethodName("setAccessorGetMethodHandleForTopLink");
        getMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        getMethodHandleMapping.setXPath("accessor-get-method-handle");
        descriptor.addMapping((DatabaseMapping)getMethodHandleMapping);
        XMLCompositeObjectMapping setMethodHandleMapping = new XMLCompositeObjectMapping();
        setMethodHandleMapping.setAttributeName(ACCESSOR_SET_METHOD_PROPERTY);
        setMethodHandleMapping.setGetMethodName("getAccessorSetMethodHandleForTopLink");
        setMethodHandleMapping.setSetMethodName("setAccessorSetMethodHandleForTopLink");
        setMethodHandleMapping.setReferenceClass(MWMethodHandle.class);
        setMethodHandleMapping.setXPath("accessor-set-method-handle");
        descriptor.addMapping((DatabaseMapping)setMethodHandleMapping);
        return descriptor;
    }

    private MWMethodHandle getAccessorGetMethodHandleForTopLink() {
        return this.accessorGetMethodHandle.getMethod() == null ? null : this.accessorGetMethodHandle;
    }

    private void setAccessorGetMethodHandleForTopLink(MWMethodHandle methodHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildGetMethodScrubber();
        this.accessorGetMethodHandle = methodHandle == null ? new MWMethodHandle(this, scrubber) : methodHandle.setScrubber(scrubber);
    }

    private MWMethodHandle getAccessorSetMethodHandleForTopLink() {
        return this.accessorSetMethodHandle.getMethod() == null ? null : this.accessorSetMethodHandle;
    }

    private void setAccessorSetMethodHandleForTopLink(MWMethodHandle methodHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSetMethodScrubber();
        this.accessorSetMethodHandle = methodHandle == null ? new MWMethodHandle(this, scrubber) : methodHandle.setScrubber(scrubber);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isMethods() {
        return true;
    }

    public boolean isAttribute() {
        return false;
    }
}

